/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentTemplateVersionRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateEnvironmentTemplateVersionRequest.Builder, UpdateEnvironmentTemplateVersionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEnvironmentTemplateVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("majorVersion").getter(getter(UpdateEnvironmentTemplateVersionRequest::majorVersion))
            .setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()).build();

    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("minorVersion").getter(getter(UpdateEnvironmentTemplateVersionRequest::minorVersion))
            .setter(setter(Builder::minorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateEnvironmentTemplateVersionRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(UpdateEnvironmentTemplateVersionRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            MAJOR_VERSION_FIELD, MINOR_VERSION_FIELD, STATUS_FIELD, TEMPLATE_NAME_FIELD));

    private final String description;

    private final String majorVersion;

    private final String minorVersion;

    private final String status;

    private final String templateName;

    private UpdateEnvironmentTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.status = builder.status;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * A description of environment template version to update.
     * </p>
     * 
     * @return A description of environment template version to update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * To update a major version of an environment template, include <code>major Version</code>.
     * </p>
     * 
     * @return To update a major version of an environment template, include <code>major Version</code>.
     */
    public final String majorVersion() {
        return majorVersion;
    }

    /**
     * <p>
     * To update a minor version of an environment template, include <code>minorVersion</code>.
     * </p>
     * 
     * @return To update a minor version of an environment template, include <code>minorVersion</code>.
     */
    public final String minorVersion() {
        return minorVersion;
    }

    /**
     * <p>
     * The status of the environment template minor version to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment template minor version to update.
     * @see TemplateVersionStatus
     */
    public final TemplateVersionStatus status() {
        return TemplateVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the environment template minor version to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment template minor version to update.
     * @see TemplateVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the environment template.
     * </p>
     * 
     * @return The name of the environment template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentTemplateVersionRequest)) {
            return false;
        }
        UpdateEnvironmentTemplateVersionRequest other = (UpdateEnvironmentTemplateVersionRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(majorVersion(), other.majorVersion())
                && Objects.equals(minorVersion(), other.minorVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentTemplateVersionRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MajorVersion", majorVersion()).add("MinorVersion", minorVersion()).add("Status", statusAsString())
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "majorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        case "minorVersion":
            return Optional.ofNullable(clazz.cast(minorVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentTemplateVersionRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentTemplateVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnvironmentTemplateVersionRequest> {
        /**
         * <p>
         * A description of environment template version to update.
         * </p>
         * 
         * @param description
         *        A description of environment template version to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * To update a major version of an environment template, include <code>major Version</code>.
         * </p>
         * 
         * @param majorVersion
         *        To update a major version of an environment template, include <code>major Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(String majorVersion);

        /**
         * <p>
         * To update a minor version of an environment template, include <code>minorVersion</code>.
         * </p>
         * 
         * @param minorVersion
         *        To update a minor version of an environment template, include <code>minorVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minorVersion(String minorVersion);

        /**
         * <p>
         * The status of the environment template minor version to update.
         * </p>
         * 
         * @param status
         *        The status of the environment template minor version to update.
         * @see TemplateVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environment template minor version to update.
         * </p>
         * 
         * @param status
         *        The status of the environment template minor version to update.
         * @see TemplateVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateVersionStatus
         */
        Builder status(TemplateVersionStatus status);

        /**
         * <p>
         * The name of the environment template.
         * </p>
         * 
         * @param templateName
         *        The name of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String description;

        private String majorVersion;

        private String minorVersion;

        private String status;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentTemplateVersionRequest model) {
            super(model);
            description(model.description);
            majorVersion(model.majorVersion);
            minorVersion(model.minorVersion);
            status(model.status);
            templateName(model.templateName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        @Transient
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final String getMinorVersion() {
            return minorVersion;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        @Transient
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(TemplateVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentTemplateVersionRequest build() {
            return new UpdateEnvironmentTemplateVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
