/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelServicePipelineDeploymentResponse extends ProtonResponse implements
        ToCopyableBuilder<CancelServicePipelineDeploymentResponse.Builder, CancelServicePipelineDeploymentResponse> {
    private static final SdkField<ServicePipeline> PIPELINE_FIELD = SdkField.<ServicePipeline> builder(MarshallingType.SDK_POJO)
            .memberName("pipeline").getter(getter(CancelServicePipelineDeploymentResponse::pipeline))
            .setter(setter(Builder::pipeline)).constructor(ServicePipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD));

    private final ServicePipeline pipeline;

    private CancelServicePipelineDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
    }

    /**
     * <p>
     * The service pipeline detail data that's returned by Proton.
     * </p>
     * 
     * @return The service pipeline detail data that's returned by Proton.
     */
    public final ServicePipeline pipeline() {
        return pipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelServicePipelineDeploymentResponse)) {
            return false;
        }
        CancelServicePipelineDeploymentResponse other = (CancelServicePipelineDeploymentResponse) obj;
        return Objects.equals(pipeline(), other.pipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelServicePipelineDeploymentResponse").add("Pipeline", pipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelServicePipelineDeploymentResponse, T> g) {
        return obj -> g.apply((CancelServicePipelineDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelServicePipelineDeploymentResponse> {
        /**
         * <p>
         * The service pipeline detail data that's returned by Proton.
         * </p>
         * 
         * @param pipeline
         *        The service pipeline detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(ServicePipeline pipeline);

        /**
         * <p>
         * The service pipeline detail data that's returned by Proton.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServicePipeline.Builder} avoiding the
         * need to create one manually via {@link ServicePipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServicePipeline.Builder#build()} is called immediately and its
         * result is passed to {@link #pipeline(ServicePipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link ServicePipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(ServicePipeline)
         */
        default Builder pipeline(Consumer<ServicePipeline.Builder> pipeline) {
            return pipeline(ServicePipeline.builder().applyMutation(pipeline).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private ServicePipeline pipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelServicePipelineDeploymentResponse model) {
            super(model);
            pipeline(model.pipeline);
        }

        public final ServicePipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(ServicePipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(ServicePipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        @Override
        public CancelServicePipelineDeploymentResponse build() {
            return new CancelServicePipelineDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
