/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRepositorySyncStatusResponse extends ProtonResponse implements
        ToCopyableBuilder<GetRepositorySyncStatusResponse.Builder, GetRepositorySyncStatusResponse> {
    private static final SdkField<RepositorySyncAttempt> LATEST_SYNC_FIELD = SdkField
            .<RepositorySyncAttempt> builder(MarshallingType.SDK_POJO).memberName("latestSync")
            .getter(getter(GetRepositorySyncStatusResponse::latestSync)).setter(setter(Builder::latestSync))
            .constructor(RepositorySyncAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSync").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_SYNC_FIELD));

    private final RepositorySyncAttempt latestSync;

    private GetRepositorySyncStatusResponse(BuilderImpl builder) {
        super(builder);
        this.latestSync = builder.latestSync;
    }

    /**
     * <p>
     * The repository sync status detail data that's returned by Proton.
     * </p>
     * 
     * @return The repository sync status detail data that's returned by Proton.
     */
    public final RepositorySyncAttempt latestSync() {
        return latestSync;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(latestSync());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositorySyncStatusResponse)) {
            return false;
        }
        GetRepositorySyncStatusResponse other = (GetRepositorySyncStatusResponse) obj;
        return Objects.equals(latestSync(), other.latestSync());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRepositorySyncStatusResponse").add("LatestSync", latestSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestSync":
            return Optional.ofNullable(clazz.cast(latestSync()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRepositorySyncStatusResponse, T> g) {
        return obj -> g.apply((GetRepositorySyncStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRepositorySyncStatusResponse> {
        /**
         * <p>
         * The repository sync status detail data that's returned by Proton.
         * </p>
         * 
         * @param latestSync
         *        The repository sync status detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSync(RepositorySyncAttempt latestSync);

        /**
         * <p>
         * The repository sync status detail data that's returned by Proton.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositorySyncAttempt.Builder} avoiding
         * the need to create one manually via {@link RepositorySyncAttempt#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositorySyncAttempt.Builder#build()} is called immediately and
         * its result is passed to {@link #latestSync(RepositorySyncAttempt)}.
         * 
         * @param latestSync
         *        a consumer that will call methods on {@link RepositorySyncAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestSync(RepositorySyncAttempt)
         */
        default Builder latestSync(Consumer<RepositorySyncAttempt.Builder> latestSync) {
            return latestSync(RepositorySyncAttempt.builder().applyMutation(latestSync).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private RepositorySyncAttempt latestSync;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositorySyncStatusResponse model) {
            super(model);
            latestSync(model.latestSync);
        }

        public final RepositorySyncAttempt.Builder getLatestSync() {
            return latestSync != null ? latestSync.toBuilder() : null;
        }

        public final void setLatestSync(RepositorySyncAttempt.BuilderImpl latestSync) {
            this.latestSync = latestSync != null ? latestSync.build() : null;
        }

        @Override
        public final Builder latestSync(RepositorySyncAttempt latestSync) {
            this.latestSync = latestSync;
            return this;
        }

        @Override
        public GetRepositorySyncStatusResponse build() {
            return new GetRepositorySyncStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
