/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceTemplateVersionsResponse extends ProtonResponse implements
        ToCopyableBuilder<ListServiceTemplateVersionsResponse.Builder, ListServiceTemplateVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceTemplateVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ServiceTemplateVersionSummary>> TEMPLATE_VERSIONS_FIELD = SdkField
            .<List<ServiceTemplateVersionSummary>> builder(MarshallingType.LIST)
            .memberName("templateVersions")
            .getter(getter(ListServiceTemplateVersionsResponse::templateVersions))
            .setter(setter(Builder::templateVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceTemplateVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceTemplateVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEMPLATE_VERSIONS_FIELD));

    private final String nextToken;

    private final List<ServiceTemplateVersionSummary> templateVersions;

    private ListServiceTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateVersions = builder.templateVersions;
    }

    /**
     * <p>
     * A token that indicates the location of the next major or minor version in the array of major or minor versions of
     * a service template, after the current requested list of service major or minor versions.
     * </p>
     * 
     * @return A token that indicates the location of the next major or minor version in the array of major or minor
     *         versions of a service template, after the current requested list of service major or minor versions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateVersions() {
        return templateVersions != null && !(templateVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of major or minor versions of a service template with detail data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateVersions} method.
     * </p>
     * 
     * @return An array of major or minor versions of a service template with detail data.
     */
    public final List<ServiceTemplateVersionSummary> templateVersions() {
        return templateVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateVersions() ? templateVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceTemplateVersionsResponse)) {
            return false;
        }
        ListServiceTemplateVersionsResponse other = (ListServiceTemplateVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTemplateVersions() == other.hasTemplateVersions()
                && Objects.equals(templateVersions(), other.templateVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceTemplateVersionsResponse").add("NextToken", nextToken())
                .add("TemplateVersions", hasTemplateVersions() ? templateVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "templateVersions":
            return Optional.ofNullable(clazz.cast(templateVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListServiceTemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceTemplateVersionsResponse> {
        /**
         * <p>
         * A token that indicates the location of the next major or minor version in the array of major or minor
         * versions of a service template, after the current requested list of service major or minor versions.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next major or minor version in the array of major or minor
         *        versions of a service template, after the current requested list of service major or minor versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of major or minor versions of a service template with detail data.
         * </p>
         * 
         * @param templateVersions
         *        An array of major or minor versions of a service template with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersions(Collection<ServiceTemplateVersionSummary> templateVersions);

        /**
         * <p>
         * An array of major or minor versions of a service template with detail data.
         * </p>
         * 
         * @param templateVersions
         *        An array of major or minor versions of a service template with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersions(ServiceTemplateVersionSummary... templateVersions);

        /**
         * <p>
         * An array of major or minor versions of a service template with detail data.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ServiceTemplateVersionSummary>.Builder} avoiding the need to create one manually via {@link List
         * <ServiceTemplateVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceTemplateVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #templateVersions(List<ServiceTemplateVersionSummary>)}.
         * 
         * @param templateVersions
         *        a consumer that will call methods on {@link List<ServiceTemplateVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateVersions(List<ServiceTemplateVersionSummary>)
         */
        Builder templateVersions(Consumer<ServiceTemplateVersionSummary.Builder>... templateVersions);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceTemplateVersionSummary> templateVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceTemplateVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            templateVersions(model.templateVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceTemplateVersionSummary.Builder> getTemplateVersions() {
            List<ServiceTemplateVersionSummary.Builder> result = ServiceTemplateVersionSummaryListCopier
                    .copyToBuilder(this.templateVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateVersions(Collection<ServiceTemplateVersionSummary.BuilderImpl> templateVersions) {
            this.templateVersions = ServiceTemplateVersionSummaryListCopier.copyFromBuilder(templateVersions);
        }

        @Override
        public final Builder templateVersions(Collection<ServiceTemplateVersionSummary> templateVersions) {
            this.templateVersions = ServiceTemplateVersionSummaryListCopier.copy(templateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersions(ServiceTemplateVersionSummary... templateVersions) {
            templateVersions(Arrays.asList(templateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersions(Consumer<ServiceTemplateVersionSummary.Builder>... templateVersions) {
            templateVersions(Stream.of(templateVersions)
                    .map(c -> ServiceTemplateVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceTemplateVersionsResponse build() {
            return new ListServiceTemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
