/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detail data for a provisioned resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedResource.Builder, ProvisionedResource> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ProvisionedResource::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ProvisionedResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVISIONING_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioningEngine").getter(getter(ProvisionedResource::provisioningEngineAsString))
            .setter(setter(Builder::provisioningEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningEngine").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, NAME_FIELD,
            PROVISIONING_ENGINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String name;

    private final String provisioningEngine;

    private ProvisionedResource(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.provisioningEngine = builder.provisioningEngine;
    }

    /**
     * <p>
     * The provisioned resource identifier.
     * </p>
     * 
     * @return The provisioned resource identifier.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The provisioned resource name.
     * </p>
     * 
     * @return The provisioned resource name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
     * Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningEngine} will return {@link ProvisionedResourceEngine#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningEngineAsString}.
     * </p>
     * 
     * @return The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
     *         Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     *         >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
     * @see ProvisionedResourceEngine
     */
    public final ProvisionedResourceEngine provisioningEngine() {
        return ProvisionedResourceEngine.fromValue(provisioningEngine);
    }

    /**
     * <p>
     * The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
     * Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningEngine} will return {@link ProvisionedResourceEngine#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningEngineAsString}.
     * </p>
     * 
     * @return The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
     *         Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     *         >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
     * @see ProvisionedResourceEngine
     */
    public final String provisioningEngineAsString() {
        return provisioningEngine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningEngineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedResource)) {
            return false;
        }
        ProvisionedResource other = (ProvisionedResource) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(provisioningEngineAsString(), other.provisioningEngineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedResource").add("Identifier", identifier()).add("Name", name())
                .add("ProvisioningEngine", provisioningEngineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provisioningEngine":
            return Optional.ofNullable(clazz.cast(provisioningEngineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedResource, T> g) {
        return obj -> g.apply((ProvisionedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedResource> {
        /**
         * <p>
         * The provisioned resource identifier.
         * </p>
         * 
         * @param identifier
         *        The provisioned resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The provisioned resource name.
         * </p>
         * 
         * @param name
         *        The provisioned resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
         * Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
         * >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
         * </p>
         * 
         * @param provisioningEngine
         *        The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
         *        Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed
         *        provisioning.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
         *        >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
         * @see ProvisionedResourceEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedResourceEngine
         */
        Builder provisioningEngine(String provisioningEngine);

        /**
         * <p>
         * The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
         * Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
         * >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
         * </p>
         * 
         * @param provisioningEngine
         *        The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web
         *        Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed
         *        provisioning.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
         *        >Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.
         * @see ProvisionedResourceEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedResourceEngine
         */
        Builder provisioningEngine(ProvisionedResourceEngine provisioningEngine);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String name;

        private String provisioningEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedResource model) {
            identifier(model.identifier);
            name(model.name);
            provisioningEngine(model.provisioningEngine);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningEngine() {
            return provisioningEngine;
        }

        public final void setProvisioningEngine(String provisioningEngine) {
            this.provisioningEngine = provisioningEngine;
        }

        @Override
        public final Builder provisioningEngine(String provisioningEngine) {
            this.provisioningEngine = provisioningEngine;
            return this;
        }

        @Override
        public final Builder provisioningEngine(ProvisionedResourceEngine provisioningEngine) {
            this.provisioningEngine(provisioningEngine == null ? null : provisioningEngine.toString());
            return this;
        }

        @Override
        public ProvisionedResource build() {
            return new ProvisionedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
