/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateSyncConfigRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateTemplateSyncConfigRequest.Builder, UpdateTemplateSyncConfigRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("branch")
            .getter(getter(UpdateTemplateSyncConfigRequest::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UpdateTemplateSyncConfigRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryProvider").getter(getter(UpdateTemplateSyncConfigRequest::repositoryProviderAsString))
            .setter(setter(Builder::repositoryProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build())
            .build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subdirectory").getter(getter(UpdateTemplateSyncConfigRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdirectory").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(UpdateTemplateSyncConfigRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(UpdateTemplateSyncConfigRequest::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD,
            REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SUBDIRECTORY_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD));

    private final String branch;

    private final String repositoryName;

    private final String repositoryProvider;

    private final String subdirectory;

    private final String templateName;

    private final String templateType;

    private UpdateTemplateSyncConfigRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.subdirectory = builder.subdirectory;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * The repository branch.
     * </p>
     * 
     * @return The repository branch.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The name of the repository (for example, <code>myrepos/myrepo</code>).
     * </p>
     * 
     * @return The name of the repository (for example, <code>myrepos/myrepo</code>).
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(repositoryProvider);
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final String repositoryProviderAsString() {
        return repositoryProvider;
    }

    /**
     * <p>
     * A subdirectory path to your template bundle version. When included, limits the template bundle search to this
     * repository directory.
     * </p>
     * 
     * @return A subdirectory path to your template bundle version. When included, limits the template bundle search to
     *         this repository directory.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * The synced template name.
     * </p>
     * 
     * @return The synced template name.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The synced template type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The synced template type.
     * @see TemplateType
     */
    public final TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The synced template type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The synced template type.
     * @see TemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateSyncConfigRequest)) {
            return false;
        }
        UpdateTemplateSyncConfigRequest other = (UpdateTemplateSyncConfigRequest) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryProviderAsString(), other.repositoryProviderAsString())
                && Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateSyncConfigRequest").add("Branch", branch())
                .add("RepositoryName", repositoryName()).add("RepositoryProvider", repositoryProviderAsString())
                .add("Subdirectory", subdirectory()).add("TemplateName", templateName())
                .add("TemplateType", templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryProvider":
            return Optional.ofNullable(clazz.cast(repositoryProviderAsString()));
        case "subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateSyncConfigRequest, T> g) {
        return obj -> g.apply((UpdateTemplateSyncConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateSyncConfigRequest> {
        /**
         * <p>
         * The repository branch.
         * </p>
         * 
         * @param branch
         *        The repository branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The name of the repository (for example, <code>myrepos/myrepo</code>).
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository (for example, <code>myrepos/myrepo</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(String repositoryProvider);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(RepositoryProvider repositoryProvider);

        /**
         * <p>
         * A subdirectory path to your template bundle version. When included, limits the template bundle search to this
         * repository directory.
         * </p>
         * 
         * @param subdirectory
         *        A subdirectory path to your template bundle version. When included, limits the template bundle search
         *        to this repository directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * The synced template name.
         * </p>
         * 
         * @param templateName
         *        The synced template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The synced template type.
         * </p>
         * 
         * @param templateType
         *        The synced template type.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The synced template type.
         * </p>
         * 
         * @param templateType
         *        The synced template type.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String branch;

        private String repositoryName;

        private String repositoryProvider;

        private String subdirectory;

        private String templateName;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateSyncConfigRequest model) {
            super(model);
            branch(model.branch);
            repositoryName(model.repositoryName);
            repositoryProvider(model.repositoryProvider);
            subdirectory(model.subdirectory);
            templateName(model.templateName);
            templateType(model.templateType);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateSyncConfigRequest build() {
            return new UpdateTemplateSyncConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
