/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary;

public class ListServiceTemplateVersionsPublisher
implements SdkPublisher<ListServiceTemplateVersionsResponse> {
    private final ProtonAsyncClient client;
    private final ListServiceTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceTemplateVersionsPublisher(ProtonAsyncClient client, ListServiceTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceTemplateVersionsPublisher(ProtonAsyncClient client, ListServiceTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceTemplateVersionSummary> templateVersions() {
        Function<ListServiceTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateVersions() != null) {
                return response.templateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceTemplateVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<ListServiceTemplateVersionsResponse> {
        private ListServiceTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceTemplateVersionsResponse> nextPage(ListServiceTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceTemplateVersionsPublisher.this.client.listServiceTemplateVersions(ListServiceTemplateVersionsPublisher.this.firstRequest);
            }
            return ListServiceTemplateVersionsPublisher.this.client.listServiceTemplateVersions((ListServiceTemplateVersionsRequest)((Object)ListServiceTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

