/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateAccountSettingsRequest.Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<Boolean> DELETE_PIPELINE_PROVISIONING_REPOSITORY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletePipelineProvisioningRepository")
            .getter(getter(UpdateAccountSettingsRequest::deletePipelineProvisioningRepository))
            .setter(setter(Builder::deletePipelineProvisioningRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("deletePipelineProvisioningRepository").build()).build();

    private static final SdkField<RepositoryBranchInput> PIPELINE_PROVISIONING_REPOSITORY_FIELD = SdkField
            .<RepositoryBranchInput> builder(MarshallingType.SDK_POJO)
            .memberName("pipelineProvisioningRepository")
            .getter(getter(UpdateAccountSettingsRequest::pipelineProvisioningRepository))
            .setter(setter(Builder::pipelineProvisioningRepository))
            .constructor(RepositoryBranchInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineProvisioningRepository")
                    .build()).build();

    private static final SdkField<String> PIPELINE_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineServiceRoleArn").getter(getter(UpdateAccountSettingsRequest::pipelineServiceRoleArn))
            .setter(setter(Builder::pipelineServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineServiceRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELETE_PIPELINE_PROVISIONING_REPOSITORY_FIELD, PIPELINE_PROVISIONING_REPOSITORY_FIELD,
            PIPELINE_SERVICE_ROLE_ARN_FIELD));

    private final Boolean deletePipelineProvisioningRepository;

    private final RepositoryBranchInput pipelineProvisioningRepository;

    private final String pipelineServiceRoleArn;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.deletePipelineProvisioningRepository = builder.deletePipelineProvisioningRepository;
        this.pipelineProvisioningRepository = builder.pipelineProvisioningRepository;
        this.pipelineServiceRoleArn = builder.pipelineServiceRoleArn;
    }

    /**
     * <p>
     * Set to <code>true</code> to remove a configured pipeline repository from the account settings. Don't set this
     * field if you are updating the configured pipeline repository.
     * </p>
     * 
     * @return Set to <code>true</code> to remove a configured pipeline repository from the account settings. Don't set
     *         this field if you are updating the configured pipeline repository.
     */
    public final Boolean deletePipelineProvisioningRepository() {
        return deletePipelineProvisioningRepository;
    }

    /**
     * <p>
     * A linked repository for pipeline provisioning. Specify it if you have environments configured for self-managed
     * provisioning with services that include pipelines. A linked repository is a repository that has been registered
     * with Proton. For more information, see <a>CreateRepository</a>.
     * </p>
     * <p>
     * To remove a previously configured repository, set <code>deletePipelineProvisioningRepository</code> to
     * <code>true</code>, and don't set <code>pipelineProvisioningRepository</code>.
     * </p>
     * 
     * @return A linked repository for pipeline provisioning. Specify it if you have environments configured for
     *         self-managed provisioning with services that include pipelines. A linked repository is a repository that
     *         has been registered with Proton. For more information, see <a>CreateRepository</a>.</p>
     *         <p>
     *         To remove a previously configured repository, set <code>deletePipelineProvisioningRepository</code> to
     *         <code>true</code>, and don't set <code>pipelineProvisioningRepository</code>.
     */
    public final RepositoryBranchInput pipelineProvisioningRepository() {
        return pipelineProvisioningRepository;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by Proton
     * for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed provisioning.
     * </p>
     * <p>
     * To remove a previously configured ARN, specify an empty string.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by
     *         Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed
     *         provisioning.</p>
     *         <p>
     *         To remove a previously configured ARN, specify an empty string.
     */
    public final String pipelineServiceRoleArn() {
        return pipelineServiceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletePipelineProvisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineProvisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineServiceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest) obj;
        return Objects.equals(deletePipelineProvisioningRepository(), other.deletePipelineProvisioningRepository())
                && Objects.equals(pipelineProvisioningRepository(), other.pipelineProvisioningRepository())
                && Objects.equals(pipelineServiceRoleArn(), other.pipelineServiceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsRequest")
                .add("DeletePipelineProvisioningRepository", deletePipelineProvisioningRepository())
                .add("PipelineProvisioningRepository", pipelineProvisioningRepository())
                .add("PipelineServiceRoleArn", pipelineServiceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deletePipelineProvisioningRepository":
            return Optional.ofNullable(clazz.cast(deletePipelineProvisioningRepository()));
        case "pipelineProvisioningRepository":
            return Optional.ofNullable(clazz.cast(pipelineProvisioningRepository()));
        case "pipelineServiceRoleArn":
            return Optional.ofNullable(clazz.cast(pipelineServiceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        /**
         * <p>
         * Set to <code>true</code> to remove a configured pipeline repository from the account settings. Don't set this
         * field if you are updating the configured pipeline repository.
         * </p>
         * 
         * @param deletePipelineProvisioningRepository
         *        Set to <code>true</code> to remove a configured pipeline repository from the account settings. Don't
         *        set this field if you are updating the configured pipeline repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletePipelineProvisioningRepository(Boolean deletePipelineProvisioningRepository);

        /**
         * <p>
         * A linked repository for pipeline provisioning. Specify it if you have environments configured for
         * self-managed provisioning with services that include pipelines. A linked repository is a repository that has
         * been registered with Proton. For more information, see <a>CreateRepository</a>.
         * </p>
         * <p>
         * To remove a previously configured repository, set <code>deletePipelineProvisioningRepository</code> to
         * <code>true</code>, and don't set <code>pipelineProvisioningRepository</code>.
         * </p>
         * 
         * @param pipelineProvisioningRepository
         *        A linked repository for pipeline provisioning. Specify it if you have environments configured for
         *        self-managed provisioning with services that include pipelines. A linked repository is a repository
         *        that has been registered with Proton. For more information, see <a>CreateRepository</a>.</p>
         *        <p>
         *        To remove a previously configured repository, set <code>deletePipelineProvisioningRepository</code> to
         *        <code>true</code>, and don't set <code>pipelineProvisioningRepository</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineProvisioningRepository(RepositoryBranchInput pipelineProvisioningRepository);

        /**
         * <p>
         * A linked repository for pipeline provisioning. Specify it if you have environments configured for
         * self-managed provisioning with services that include pipelines. A linked repository is a repository that has
         * been registered with Proton. For more information, see <a>CreateRepository</a>.
         * </p>
         * <p>
         * To remove a previously configured repository, set <code>deletePipelineProvisioningRepository</code> to
         * <code>true</code>, and don't set <code>pipelineProvisioningRepository</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryBranchInput.Builder} avoiding
         * the need to create one manually via {@link RepositoryBranchInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryBranchInput.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineProvisioningRepository(RepositoryBranchInput)}.
         * 
         * @param pipelineProvisioningRepository
         *        a consumer that will call methods on {@link RepositoryBranchInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineProvisioningRepository(RepositoryBranchInput)
         */
        default Builder pipelineProvisioningRepository(Consumer<RepositoryBranchInput.Builder> pipelineProvisioningRepository) {
            return pipelineProvisioningRepository(RepositoryBranchInput.builder().applyMutation(pipelineProvisioningRepository)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by
         * Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed
         * provisioning.
         * </p>
         * <p>
         * To remove a previously configured ARN, specify an empty string.
         * </p>
         * 
         * @param pipelineServiceRoleArn
         *        The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed
         *        by Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for
         *        self-managed provisioning.</p>
         *        <p>
         *        To remove a previously configured ARN, specify an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineServiceRoleArn(String pipelineServiceRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private Boolean deletePipelineProvisioningRepository;

        private RepositoryBranchInput pipelineProvisioningRepository;

        private String pipelineServiceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            deletePipelineProvisioningRepository(model.deletePipelineProvisioningRepository);
            pipelineProvisioningRepository(model.pipelineProvisioningRepository);
            pipelineServiceRoleArn(model.pipelineServiceRoleArn);
        }

        public final Boolean getDeletePipelineProvisioningRepository() {
            return deletePipelineProvisioningRepository;
        }

        public final void setDeletePipelineProvisioningRepository(Boolean deletePipelineProvisioningRepository) {
            this.deletePipelineProvisioningRepository = deletePipelineProvisioningRepository;
        }

        @Override
        public final Builder deletePipelineProvisioningRepository(Boolean deletePipelineProvisioningRepository) {
            this.deletePipelineProvisioningRepository = deletePipelineProvisioningRepository;
            return this;
        }

        public final RepositoryBranchInput.Builder getPipelineProvisioningRepository() {
            return pipelineProvisioningRepository != null ? pipelineProvisioningRepository.toBuilder() : null;
        }

        public final void setPipelineProvisioningRepository(RepositoryBranchInput.BuilderImpl pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository != null ? pipelineProvisioningRepository.build()
                    : null;
        }

        @Override
        public final Builder pipelineProvisioningRepository(RepositoryBranchInput pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository;
            return this;
        }

        public final String getPipelineServiceRoleArn() {
            return pipelineServiceRoleArn;
        }

        public final void setPipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
        }

        @Override
        public final Builder pipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
