/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(UpdateEnvironmentRequest::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(UpdateEnvironmentRequest::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountConnectionId")
            .getter(getter(UpdateEnvironmentRequest::environmentAccountConnectionId))
            .setter(setter(Builder::environmentAccountConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnectionId")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTON_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protonServiceRoleArn").getter(getter(UpdateEnvironmentRequest::protonServiceRoleArn))
            .setter(setter(Builder::protonServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protonServiceRoleArn").build())
            .build();

    private static final SdkField<RepositoryBranchInput> PROVISIONING_REPOSITORY_FIELD = SdkField
            .<RepositoryBranchInput> builder(MarshallingType.SDK_POJO).memberName("provisioningRepository")
            .getter(getter(UpdateEnvironmentRequest::provisioningRepository)).setter(setter(Builder::provisioningRepository))
            .constructor(RepositoryBranchInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRepository").build())
            .build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(UpdateEnvironmentRequest::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(UpdateEnvironmentRequest::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(UpdateEnvironmentRequest::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ROLE_ARN_FIELD,
            DEPLOYMENT_TYPE_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD, NAME_FIELD,
            PROTON_SERVICE_ROLE_ARN_FIELD, PROVISIONING_REPOSITORY_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD,
            TEMPLATE_MINOR_VERSION_FIELD));

    private final String componentRoleArn;

    private final String deploymentType;

    private final String description;

    private final String environmentAccountConnectionId;

    private final String name;

    private final String protonServiceRoleArn;

    private final RepositoryBranchInput provisioningRepository;

    private final String spec;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.componentRoleArn = builder.componentRoleArn;
        this.deploymentType = builder.deploymentType;
        this.description = builder.description;
        this.environmentAccountConnectionId = builder.environmentAccountConnectionId;
        this.name = builder.name;
        this.protonServiceRoleArn = builder.protonServiceRoleArn;
        this.provisioningRepository = builder.provisioningRepository;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
     * components in this environment. It determines the scope of infrastructure that a component can provision.
     * </p>
     * <p>
     * The environment must have a <code>componentRoleArn</code> to allow directly defined components to be associated
     * with the environment.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
     *         defined components in this environment. It determines the scope of infrastructure that a component can
     *         provision.</p>
     *         <p>
     *         The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
     *         associated with the environment.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of
     * the current major version in use, by default. You can also specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor
     * version of the current template, by default. You can also specify a different major version that is higher than
     * the major version in use and a minor version (optional).
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return There are four modes for updating an environment. The <code>deploymentType</code> field defines the
     *         mode.</p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     *         parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     *         <code>deployment-type</code>.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MINOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the published, recommended (latest) minor
     *         version of the current major version in use, by default. You can also specify a different minor version
     *         of the current major version in use.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MAJOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the published, recommended (latest) major and
     *         minor version of the current template, by default. You can also specify a different major version that is
     *         higher than the major version in use and a minor version (optional).
     *         </p>
     *         </dd>
     * @see DeploymentUpdateType
     */
    public final DeploymentUpdateType deploymentType() {
        return DeploymentUpdateType.fromValue(deploymentType);
    }

    /**
     * <p>
     * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of
     * the current major version in use, by default. You can also specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor
     * version of the current template, by default. You can also specify a different major version that is higher than
     * the major version in use and a minor version (optional).
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return There are four modes for updating an environment. The <code>deploymentType</code> field defines the
     *         mode.</p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     *         parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     *         <code>deployment-type</code>.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MINOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the published, recommended (latest) minor
     *         version of the current major version in use, by default. You can also specify a different minor version
     *         of the current major version in use.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MAJOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the environment is deployed and updated with the published, recommended (latest) major and
     *         minor version of the current template, by default. You can also specify a different major version that is
     *         higher than the major version in use and a minor version (optional).
     *         </p>
     *         </dd>
     * @see DeploymentUpdateType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * A description of the environment update.
     * </p>
     * 
     * @return A description of the environment update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the environment account connection.
     * </p>
     * <p>
     * You can only update to a new environment account connection if it was created in the same environment account
     * that the current environment account connection was created in and is associated with the current environment.
     * </p>
     * 
     * @return The ID of the environment account connection.</p>
     *         <p>
     *         You can only update to a new environment account connection if it was created in the same environment
     *         account that the current environment account connection was created in and is associated with the current
     *         environment.
     */
    public final String environmentAccountConnectionId() {
        return environmentAccountConnectionId;
    }

    /**
     * <p>
     * The name of the environment to update.
     * </p>
     * 
     * @return The name of the environment to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services
     * your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other
     *         services your behalf.
     */
    public final String protonServiceRoleArn() {
        return protonServiceRoleArn;
    }

    /**
     * <p>
     * The linked repository that you use to host your rendered infrastructure templates for self-managed provisioning.
     * A linked repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     * 
     * @return The linked repository that you use to host your rendered infrastructure templates for self-managed
     *         provisioning. A linked repository is a repository that has been registered with Proton. For more
     *         information, see <a>CreateRepository</a>.
     */
    public final RepositoryBranchInput provisioningRepository() {
        return provisioningRepository;
    }

    /**
     * <p>
     * The formatted specification that defines the update.
     * </p>
     * 
     * @return The formatted specification that defines the update.
     */
    public final String spec() {
        return spec;
    }

    /**
     * <p>
     * The major version of the environment to update.
     * </p>
     * 
     * @return The major version of the environment to update.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the environment to update.
     * </p>
     * 
     * @return The minor version of the environment to update.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protonServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return Objects.equals(componentRoleArn(), other.componentRoleArn())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(environmentAccountConnectionId(), other.environmentAccountConnectionId())
                && Objects.equals(name(), other.name()) && Objects.equals(protonServiceRoleArn(), other.protonServiceRoleArn())
                && Objects.equals(provisioningRepository(), other.provisioningRepository())
                && Objects.equals(spec(), other.spec()) && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentRequest").add("ComponentRoleArn", componentRoleArn())
                .add("DeploymentType", deploymentTypeAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentAccountConnectionId", environmentAccountConnectionId()).add("Name", name())
                .add("ProtonServiceRoleArn", protonServiceRoleArn()).add("ProvisioningRepository", provisioningRepository())
                .add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentAccountConnectionId":
            return Optional.ofNullable(clazz.cast(environmentAccountConnectionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protonServiceRoleArn":
            return Optional.ofNullable(clazz.cast(protonServiceRoleArn()));
        case "provisioningRepository":
            return Optional.ofNullable(clazz.cast(provisioningRepository()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
         * components in this environment. It determines the scope of infrastructure that a component can provision.
         * </p>
         * <p>
         * The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
         * associated with the environment.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
         *        defined components in this environment. It determines the scope of infrastructure that a component can
         *        provision.</p>
         *        <p>
         *        The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
         *        associated with the environment.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
         * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
         * <code>deployment-type</code>.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MINOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version
         * of the current major version in use, by default. You can also specify a different minor version of the
         * current major version in use.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MAJOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the published, recommended (latest) major and
         * minor version of the current template, by default. You can also specify a different major version that is
         * higher than the major version in use and a minor version (optional).
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        There are four modes for updating an environment. The <code>deploymentType</code> field defines the
         *        mode.</p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the new spec that you provide. Only
         *        requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
         *        this <code>deployment-type</code>.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MINOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the published, recommended (latest) minor
         *        version of the current major version in use, by default. You can also specify a different minor
         *        version of the current major version in use.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MAJOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the published, recommended (latest) major
         *        and minor version of the current template, by default. You can also specify a different major version
         *        that is higher than the major version in use and a minor version (optional).
         *        </p>
         *        </dd>
         * @see DeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentUpdateType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
         * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
         * <code>deployment-type</code>.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MINOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version
         * of the current major version in use, by default. You can also specify a different minor version of the
         * current major version in use.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MAJOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the environment is deployed and updated with the published, recommended (latest) major and
         * minor version of the current template, by default. You can also specify a different major version that is
         * higher than the major version in use and a minor version (optional).
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        There are four modes for updating an environment. The <code>deploymentType</code> field defines the
         *        mode.</p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the new spec that you provide. Only
         *        requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
         *        this <code>deployment-type</code>.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MINOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the published, recommended (latest) minor
         *        version of the current major version in use, by default. You can also specify a different minor
         *        version of the current major version in use.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MAJOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the environment is deployed and updated with the published, recommended (latest) major
         *        and minor version of the current template, by default. You can also specify a different major version
         *        that is higher than the major version in use and a minor version (optional).
         *        </p>
         *        </dd>
         * @see DeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentUpdateType
         */
        Builder deploymentType(DeploymentUpdateType deploymentType);

        /**
         * <p>
         * A description of the environment update.
         * </p>
         * 
         * @param description
         *        A description of the environment update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the environment account connection.
         * </p>
         * <p>
         * You can only update to a new environment account connection if it was created in the same environment account
         * that the current environment account connection was created in and is associated with the current
         * environment.
         * </p>
         * 
         * @param environmentAccountConnectionId
         *        The ID of the environment account connection.</p>
         *        <p>
         *        You can only update to a new environment account connection if it was created in the same environment
         *        account that the current environment account connection was created in and is associated with the
         *        current environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountConnectionId(String environmentAccountConnectionId);

        /**
         * <p>
         * The name of the environment to update.
         * </p>
         * 
         * @param name
         *        The name of the environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other
         * services your behalf.
         * </p>
         * 
         * @param protonServiceRoleArn
         *        The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to
         *        other services your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protonServiceRoleArn(String protonServiceRoleArn);

        /**
         * <p>
         * The linked repository that you use to host your rendered infrastructure templates for self-managed
         * provisioning. A linked repository is a repository that has been registered with Proton. For more information,
         * see <a>CreateRepository</a>.
         * </p>
         * 
         * @param provisioningRepository
         *        The linked repository that you use to host your rendered infrastructure templates for self-managed
         *        provisioning. A linked repository is a repository that has been registered with Proton. For more
         *        information, see <a>CreateRepository</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRepository(RepositoryBranchInput provisioningRepository);

        /**
         * <p>
         * The linked repository that you use to host your rendered infrastructure templates for self-managed
         * provisioning. A linked repository is a repository that has been registered with Proton. For more information,
         * see <a>CreateRepository</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryBranchInput.Builder} avoiding
         * the need to create one manually via {@link RepositoryBranchInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryBranchInput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningRepository(RepositoryBranchInput)}.
         * 
         * @param provisioningRepository
         *        a consumer that will call methods on {@link RepositoryBranchInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningRepository(RepositoryBranchInput)
         */
        default Builder provisioningRepository(Consumer<RepositoryBranchInput.Builder> provisioningRepository) {
            return provisioningRepository(RepositoryBranchInput.builder().applyMutation(provisioningRepository).build());
        }

        /**
         * <p>
         * The formatted specification that defines the update.
         * </p>
         * 
         * @param spec
         *        The formatted specification that defines the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * The major version of the environment to update.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the environment to update.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String componentRoleArn;

        private String deploymentType;

        private String description;

        private String environmentAccountConnectionId;

        private String name;

        private String protonServiceRoleArn;

        private RepositoryBranchInput provisioningRepository;

        private String spec;

        private String templateMajorVersion;

        private String templateMinorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            componentRoleArn(model.componentRoleArn);
            deploymentType(model.deploymentType);
            description(model.description);
            environmentAccountConnectionId(model.environmentAccountConnectionId);
            name(model.name);
            protonServiceRoleArn(model.protonServiceRoleArn);
            provisioningRepository(model.provisioningRepository);
            spec(model.spec);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentUpdateType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentAccountConnectionId() {
            return environmentAccountConnectionId;
        }

        public final void setEnvironmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
        }

        @Override
        public final Builder environmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtonServiceRoleArn() {
            return protonServiceRoleArn;
        }

        public final void setProtonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
        }

        @Override
        public final Builder protonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
            return this;
        }

        public final RepositoryBranchInput.Builder getProvisioningRepository() {
            return provisioningRepository != null ? provisioningRepository.toBuilder() : null;
        }

        public final void setProvisioningRepository(RepositoryBranchInput.BuilderImpl provisioningRepository) {
            this.provisioningRepository = provisioningRepository != null ? provisioningRepository.build() : null;
        }

        @Override
        public final Builder provisioningRepository(RepositoryBranchInput provisioningRepository) {
            this.provisioningRepository = provisioningRepository;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
