/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse;

public class ListEnvironmentTemplatesPublisher
implements SdkPublisher<ListEnvironmentTemplatesResponse> {
    private final ProtonAsyncClient client;
    private final ListEnvironmentTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentTemplatesPublisher(ProtonAsyncClient client, ListEnvironmentTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentTemplatesPublisher(ProtonAsyncClient client, ListEnvironmentTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentTemplateSummary> templates() {
        Function<ListEnvironmentTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentTemplatesResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentTemplatesResponse> {
        private ListEnvironmentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentTemplatesResponse> nextPage(ListEnvironmentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentTemplatesPublisher.this.client.listEnvironmentTemplates(ListEnvironmentTemplatesPublisher.this.firstRequest);
            }
            return ListEnvironmentTemplatesPublisher.this.client.listEnvironmentTemplates((ListEnvironmentTemplatesRequest)((Object)ListEnvironmentTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

