/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateComponentRequest.Builder, CreateComponentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateComponentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CreateComponentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manifest").getter(getter(CreateComponentRequest::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(CreateComponentRequest::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateComponentRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceSpec").getter(getter(CreateComponentRequest::serviceSpec)).setter(setter(Builder::serviceSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateFile").getter(getter(CreateComponentRequest::templateFile))
            .setter(setter(Builder::templateFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ENVIRONMENT_NAME_FIELD, MANIFEST_FIELD, NAME_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD,
            SERVICE_SPEC_FIELD, TAGS_FIELD, TEMPLATE_FILE_FIELD));

    private final String description;

    private final String environmentName;

    private final String manifest;

    private final String name;

    private final String serviceInstanceName;

    private final String serviceName;

    private final String serviceSpec;

    private final List<Tag> tags;

    private final String templateFile;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.environmentName = builder.environmentName;
        this.manifest = builder.manifest;
        this.name = builder.name;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
        this.tags = builder.tags;
        this.templateFile = builder.templateFile;
    }

    /**
     * <p>
     * An optional customer-provided description of the component.
     * </p>
     * 
     * @return An optional customer-provided description of the component.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Proton environment that you want to associate this component with. You must specify this when you
     * don't specify <code>serviceInstanceName</code> and <code>serviceName</code>.
     * </p>
     * 
     * @return The name of the Proton environment that you want to associate this component with. You must specify this
     *         when you don't specify <code>serviceInstanceName</code> and <code>serviceName</code>.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and rendering
     * engine for infrastructure that a custom component provisions.
     * </p>
     * 
     * @return A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and
     *         rendering engine for infrastructure that a custom component provisions.
     */
    public final String manifest() {
        return manifest;
    }

    /**
     * <p>
     * The customer-provided name of the component.
     * </p>
     * 
     * @return The customer-provided name of the component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the service instance that you want to attach this component to. If you don't specify this, the
     * component isn't attached to any service instance. Specify both <code>serviceInstanceName</code> and
     * <code>serviceName</code> or neither of them.
     * </p>
     * 
     * @return The name of the service instance that you want to attach this component to. If you don't specify this,
     *         the component isn't attached to any service instance. Specify both <code>serviceInstanceName</code> and
     *         <code>serviceName</code> or neither of them.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that <code>serviceInstanceName</code> is associated with. If you don't specify this, the
     * component isn't attached to any service instance. Specify both <code>serviceInstanceName</code> and
     * <code>serviceName</code> or neither of them.
     * </p>
     * 
     * @return The name of the service that <code>serviceInstanceName</code> is associated with. If you don't specify
     *         this, the component isn't attached to any service instance. Specify both <code>serviceInstanceName</code>
     *         and <code>serviceName</code> or neither of them.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The service spec that you want the component to use to access service inputs. Set this only when you attach the
     * component to a service instance.
     * </p>
     * 
     * @return The service spec that you want the component to use to access service inputs. Set this only when you
     *         attach the component to a service instance.
     */
    public final String serviceSpec() {
        return serviceSpec;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the Proton component. A tag is a key-value
     *         pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
     *         tagging</a> in the <i>Proton User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
     * </p>
     * <note>
     * <p>
     * Components support a single IaC file, even if you use Terraform as your template language.
     * </p>
     * </note>
     * 
     * @return A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component
     *         provisions.</p> <note>
     *         <p>
     *         Components support a single IaC file, even if you use Terraform as your template language.
     *         </p>
     */
    public final String templateFile() {
        return templateFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(manifest(), other.manifest()) && Objects.equals(name(), other.name())
                && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceSpec(), other.serviceSpec())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateFile(), other.templateFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentName", environmentName())
                .add("Manifest", manifest() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("ServiceInstanceName", serviceInstanceName()).add("ServiceName", serviceName())
                .add("ServiceSpec", serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null)
                .add("TemplateFile", templateFile() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "serviceSpec":
            return Optional.ofNullable(clazz.cast(serviceSpec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateFile":
            return Optional.ofNullable(clazz.cast(templateFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComponentRequest> {
        /**
         * <p>
         * An optional customer-provided description of the component.
         * </p>
         * 
         * @param description
         *        An optional customer-provided description of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Proton environment that you want to associate this component with. You must specify this when
         * you don't specify <code>serviceInstanceName</code> and <code>serviceName</code>.
         * </p>
         * 
         * @param environmentName
         *        The name of the Proton environment that you want to associate this component with. You must specify
         *        this when you don't specify <code>serviceInstanceName</code> and <code>serviceName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and rendering
         * engine for infrastructure that a custom component provisions.
         * </p>
         * 
         * @param manifest
         *        A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and
         *        rendering engine for infrastructure that a custom component provisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(String manifest);

        /**
         * <p>
         * The customer-provided name of the component.
         * </p>
         * 
         * @param name
         *        The customer-provided name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the service instance that you want to attach this component to. If you don't specify this, the
         * component isn't attached to any service instance. Specify both <code>serviceInstanceName</code> and
         * <code>serviceName</code> or neither of them.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that you want to attach this component to. If you don't specify this,
         *        the component isn't attached to any service instance. Specify both <code>serviceInstanceName</code>
         *        and <code>serviceName</code> or neither of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that <code>serviceInstanceName</code> is associated with. If you don't specify this,
         * the component isn't attached to any service instance. Specify both <code>serviceInstanceName</code> and
         * <code>serviceName</code> or neither of them.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that <code>serviceInstanceName</code> is associated with. If you don't specify
         *        this, the component isn't attached to any service instance. Specify both
         *        <code>serviceInstanceName</code> and <code>serviceName</code> or neither of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The service spec that you want the component to use to access service inputs. Set this only when you attach
         * the component to a service instance.
         * </p>
         * 
         * @param serviceSpec
         *        The service spec that you want the component to use to access service inputs. Set this only when you
         *        attach the component to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpec(String serviceSpec);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton component. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton component. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.proton.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.proton.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
         * </p>
         * <note>
         * <p>
         * Components support a single IaC file, even if you use Terraform as your template language.
         * </p>
         * </note>
         * 
         * @param templateFile
         *        A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component
         *        provisions.</p> <note>
         *        <p>
         *        Components support a single IaC file, even if you use Terraform as your template language.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateFile(String templateFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String description;

        private String environmentName;

        private String manifest;

        private String name;

        private String serviceInstanceName;

        private String serviceName;

        private String serviceSpec;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String templateFile;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            description(model.description);
            environmentName(model.environmentName);
            manifest(model.manifest);
            name(model.name);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
            serviceSpec(model.serviceSpec);
            tags(model.tags);
            templateFile(model.templateFile);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getManifest() {
            return manifest;
        }

        public final void setManifest(String manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(String manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateFile() {
            return templateFile;
        }

        public final void setTemplateFile(String templateFile) {
            this.templateFile = templateFile;
        }

        @Override
        public final Builder templateFile(String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
