/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary counts of each Proton resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountsSummary implements SdkPojo, Serializable, ToCopyableBuilder<CountsSummary.Builder, CountsSummary> {
    private static final SdkField<ResourceCountsSummary> COMPONENTS_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("components")
            .getter(getter(CountsSummary::components)).setter(setter(Builder::components))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build()).build();

    private static final SdkField<ResourceCountsSummary> ENVIRONMENT_TEMPLATES_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("environmentTemplates")
            .getter(getter(CountsSummary::environmentTemplates)).setter(setter(Builder::environmentTemplates))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTemplates").build())
            .build();

    private static final SdkField<ResourceCountsSummary> ENVIRONMENTS_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("environments")
            .getter(getter(CountsSummary::environments)).setter(setter(Builder::environments))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build()).build();

    private static final SdkField<ResourceCountsSummary> PIPELINES_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("pipelines")
            .getter(getter(CountsSummary::pipelines)).setter(setter(Builder::pipelines))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelines").build()).build();

    private static final SdkField<ResourceCountsSummary> SERVICE_INSTANCES_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("serviceInstances")
            .getter(getter(CountsSummary::serviceInstances)).setter(setter(Builder::serviceInstances))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstances").build()).build();

    private static final SdkField<ResourceCountsSummary> SERVICE_TEMPLATES_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("serviceTemplates")
            .getter(getter(CountsSummary::serviceTemplates)).setter(setter(Builder::serviceTemplates))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTemplates").build()).build();

    private static final SdkField<ResourceCountsSummary> SERVICES_FIELD = SdkField
            .<ResourceCountsSummary> builder(MarshallingType.SDK_POJO).memberName("services")
            .getter(getter(CountsSummary::services)).setter(setter(Builder::services))
            .constructor(ResourceCountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD,
            ENVIRONMENT_TEMPLATES_FIELD, ENVIRONMENTS_FIELD, PIPELINES_FIELD, SERVICE_INSTANCES_FIELD, SERVICE_TEMPLATES_FIELD,
            SERVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceCountsSummary components;

    private final ResourceCountsSummary environmentTemplates;

    private final ResourceCountsSummary environments;

    private final ResourceCountsSummary pipelines;

    private final ResourceCountsSummary serviceInstances;

    private final ResourceCountsSummary serviceTemplates;

    private final ResourceCountsSummary services;

    private CountsSummary(BuilderImpl builder) {
        this.components = builder.components;
        this.environmentTemplates = builder.environmentTemplates;
        this.environments = builder.environments;
        this.pipelines = builder.pipelines;
        this.serviceInstances = builder.serviceInstances;
        this.serviceTemplates = builder.serviceTemplates;
        this.services = builder.services;
    }

    /**
     * <p>
     * The total number of components in the Amazon Web Services account.
     * </p>
     * <p>
     * The semantics of the <code>components</code> field are different from the semantics of results for other
     * infrastructure-provisioning resources. That's because at this time components don't have associated templates,
     * therefore they don't have the concept of staleness. The <code>components</code> object will only contain
     * <code>total</code> and <code>failed</code> members.
     * </p>
     * 
     * @return The total number of components in the Amazon Web Services account.</p>
     *         <p>
     *         The semantics of the <code>components</code> field are different from the semantics of results for other
     *         infrastructure-provisioning resources. That's because at this time components don't have associated
     *         templates, therefore they don't have the concept of staleness. The <code>components</code> object will
     *         only contain <code>total</code> and <code>failed</code> members.
     */
    public final ResourceCountsSummary components() {
        return components;
    }

    /**
     * <p>
     * The total number of environment templates in the Amazon Web Services account.
     * </p>
     * 
     * @return The total number of environment templates in the Amazon Web Services account.
     */
    public final ResourceCountsSummary environmentTemplates() {
        return environmentTemplates;
    }

    /**
     * <p>
     * The staleness counts for Proton environments in the Amazon Web Services account. The <code>environments</code>
     * object will only contain <code>total</code> members.
     * </p>
     * 
     * @return The staleness counts for Proton environments in the Amazon Web Services account. The
     *         <code>environments</code> object will only contain <code>total</code> members.
     */
    public final ResourceCountsSummary environments() {
        return environments;
    }

    /**
     * <p>
     * The staleness counts for Proton pipelines in the Amazon Web Services account.
     * </p>
     * 
     * @return The staleness counts for Proton pipelines in the Amazon Web Services account.
     */
    public final ResourceCountsSummary pipelines() {
        return pipelines;
    }

    /**
     * <p>
     * The staleness counts for Proton service instances in the Amazon Web Services account.
     * </p>
     * 
     * @return The staleness counts for Proton service instances in the Amazon Web Services account.
     */
    public final ResourceCountsSummary serviceInstances() {
        return serviceInstances;
    }

    /**
     * <p>
     * The total number of service templates in the Amazon Web Services account. The <code>serviceTemplates</code>
     * object will only contain <code>total</code> members.
     * </p>
     * 
     * @return The total number of service templates in the Amazon Web Services account. The
     *         <code>serviceTemplates</code> object will only contain <code>total</code> members.
     */
    public final ResourceCountsSummary serviceTemplates() {
        return serviceTemplates;
    }

    /**
     * <p>
     * The staleness counts for Proton services in the Amazon Web Services account.
     * </p>
     * 
     * @return The staleness counts for Proton services in the Amazon Web Services account.
     */
    public final ResourceCountsSummary services() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(components());
        hashCode = 31 * hashCode + Objects.hashCode(environmentTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(environments());
        hashCode = 31 * hashCode + Objects.hashCode(pipelines());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstances());
        hashCode = 31 * hashCode + Objects.hashCode(serviceTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(services());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountsSummary)) {
            return false;
        }
        CountsSummary other = (CountsSummary) obj;
        return Objects.equals(components(), other.components())
                && Objects.equals(environmentTemplates(), other.environmentTemplates())
                && Objects.equals(environments(), other.environments()) && Objects.equals(pipelines(), other.pipelines())
                && Objects.equals(serviceInstances(), other.serviceInstances())
                && Objects.equals(serviceTemplates(), other.serviceTemplates()) && Objects.equals(services(), other.services());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountsSummary").add("Components", components())
                .add("EnvironmentTemplates", environmentTemplates()).add("Environments", environments())
                .add("Pipelines", pipelines()).add("ServiceInstances", serviceInstances())
                .add("ServiceTemplates", serviceTemplates()).add("Services", services()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "environmentTemplates":
            return Optional.ofNullable(clazz.cast(environmentTemplates()));
        case "environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "pipelines":
            return Optional.ofNullable(clazz.cast(pipelines()));
        case "serviceInstances":
            return Optional.ofNullable(clazz.cast(serviceInstances()));
        case "serviceTemplates":
            return Optional.ofNullable(clazz.cast(serviceTemplates()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CountsSummary, T> g) {
        return obj -> g.apply((CountsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CountsSummary> {
        /**
         * <p>
         * The total number of components in the Amazon Web Services account.
         * </p>
         * <p>
         * The semantics of the <code>components</code> field are different from the semantics of results for other
         * infrastructure-provisioning resources. That's because at this time components don't have associated
         * templates, therefore they don't have the concept of staleness. The <code>components</code> object will only
         * contain <code>total</code> and <code>failed</code> members.
         * </p>
         * 
         * @param components
         *        The total number of components in the Amazon Web Services account.</p>
         *        <p>
         *        The semantics of the <code>components</code> field are different from the semantics of results for
         *        other infrastructure-provisioning resources. That's because at this time components don't have
         *        associated templates, therefore they don't have the concept of staleness. The <code>components</code>
         *        object will only contain <code>total</code> and <code>failed</code> members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ResourceCountsSummary components);

        /**
         * <p>
         * The total number of components in the Amazon Web Services account.
         * </p>
         * <p>
         * The semantics of the <code>components</code> field are different from the semantics of results for other
         * infrastructure-provisioning resources. That's because at this time components don't have associated
         * templates, therefore they don't have the concept of staleness. The <code>components</code> object will only
         * contain <code>total</code> and <code>failed</code> members.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #components(ResourceCountsSummary)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(ResourceCountsSummary)
         */
        default Builder components(Consumer<ResourceCountsSummary.Builder> components) {
            return components(ResourceCountsSummary.builder().applyMutation(components).build());
        }

        /**
         * <p>
         * The total number of environment templates in the Amazon Web Services account.
         * </p>
         * 
         * @param environmentTemplates
         *        The total number of environment templates in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentTemplates(ResourceCountsSummary environmentTemplates);

        /**
         * <p>
         * The total number of environment templates in the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #environmentTemplates(ResourceCountsSummary)}.
         * 
         * @param environmentTemplates
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentTemplates(ResourceCountsSummary)
         */
        default Builder environmentTemplates(Consumer<ResourceCountsSummary.Builder> environmentTemplates) {
            return environmentTemplates(ResourceCountsSummary.builder().applyMutation(environmentTemplates).build());
        }

        /**
         * <p>
         * The staleness counts for Proton environments in the Amazon Web Services account. The
         * <code>environments</code> object will only contain <code>total</code> members.
         * </p>
         * 
         * @param environments
         *        The staleness counts for Proton environments in the Amazon Web Services account. The
         *        <code>environments</code> object will only contain <code>total</code> members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(ResourceCountsSummary environments);

        /**
         * <p>
         * The staleness counts for Proton environments in the Amazon Web Services account. The
         * <code>environments</code> object will only contain <code>total</code> members.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #environments(ResourceCountsSummary)}.
         * 
         * @param environments
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environments(ResourceCountsSummary)
         */
        default Builder environments(Consumer<ResourceCountsSummary.Builder> environments) {
            return environments(ResourceCountsSummary.builder().applyMutation(environments).build());
        }

        /**
         * <p>
         * The staleness counts for Proton pipelines in the Amazon Web Services account.
         * </p>
         * 
         * @param pipelines
         *        The staleness counts for Proton pipelines in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(ResourceCountsSummary pipelines);

        /**
         * <p>
         * The staleness counts for Proton pipelines in the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelines(ResourceCountsSummary)}.
         * 
         * @param pipelines
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelines(ResourceCountsSummary)
         */
        default Builder pipelines(Consumer<ResourceCountsSummary.Builder> pipelines) {
            return pipelines(ResourceCountsSummary.builder().applyMutation(pipelines).build());
        }

        /**
         * <p>
         * The staleness counts for Proton service instances in the Amazon Web Services account.
         * </p>
         * 
         * @param serviceInstances
         *        The staleness counts for Proton service instances in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstances(ResourceCountsSummary serviceInstances);

        /**
         * <p>
         * The staleness counts for Proton service instances in the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceInstances(ResourceCountsSummary)}.
         * 
         * @param serviceInstances
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceInstances(ResourceCountsSummary)
         */
        default Builder serviceInstances(Consumer<ResourceCountsSummary.Builder> serviceInstances) {
            return serviceInstances(ResourceCountsSummary.builder().applyMutation(serviceInstances).build());
        }

        /**
         * <p>
         * The total number of service templates in the Amazon Web Services account. The <code>serviceTemplates</code>
         * object will only contain <code>total</code> members.
         * </p>
         * 
         * @param serviceTemplates
         *        The total number of service templates in the Amazon Web Services account. The
         *        <code>serviceTemplates</code> object will only contain <code>total</code> members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTemplates(ResourceCountsSummary serviceTemplates);

        /**
         * <p>
         * The total number of service templates in the Amazon Web Services account. The <code>serviceTemplates</code>
         * object will only contain <code>total</code> members.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceTemplates(ResourceCountsSummary)}.
         * 
         * @param serviceTemplates
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceTemplates(ResourceCountsSummary)
         */
        default Builder serviceTemplates(Consumer<ResourceCountsSummary.Builder> serviceTemplates) {
            return serviceTemplates(ResourceCountsSummary.builder().applyMutation(serviceTemplates).build());
        }

        /**
         * <p>
         * The staleness counts for Proton services in the Amazon Web Services account.
         * </p>
         * 
         * @param services
         *        The staleness counts for Proton services in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(ResourceCountsSummary services);

        /**
         * <p>
         * The staleness counts for Proton services in the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCountsSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceCountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCountsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #services(ResourceCountsSummary)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link ResourceCountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(ResourceCountsSummary)
         */
        default Builder services(Consumer<ResourceCountsSummary.Builder> services) {
            return services(ResourceCountsSummary.builder().applyMutation(services).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceCountsSummary components;

        private ResourceCountsSummary environmentTemplates;

        private ResourceCountsSummary environments;

        private ResourceCountsSummary pipelines;

        private ResourceCountsSummary serviceInstances;

        private ResourceCountsSummary serviceTemplates;

        private ResourceCountsSummary services;

        private BuilderImpl() {
        }

        private BuilderImpl(CountsSummary model) {
            components(model.components);
            environmentTemplates(model.environmentTemplates);
            environments(model.environments);
            pipelines(model.pipelines);
            serviceInstances(model.serviceInstances);
            serviceTemplates(model.serviceTemplates);
            services(model.services);
        }

        public final ResourceCountsSummary.Builder getComponents() {
            return components != null ? components.toBuilder() : null;
        }

        public final void setComponents(ResourceCountsSummary.BuilderImpl components) {
            this.components = components != null ? components.build() : null;
        }

        @Override
        public final Builder components(ResourceCountsSummary components) {
            this.components = components;
            return this;
        }

        public final ResourceCountsSummary.Builder getEnvironmentTemplates() {
            return environmentTemplates != null ? environmentTemplates.toBuilder() : null;
        }

        public final void setEnvironmentTemplates(ResourceCountsSummary.BuilderImpl environmentTemplates) {
            this.environmentTemplates = environmentTemplates != null ? environmentTemplates.build() : null;
        }

        @Override
        public final Builder environmentTemplates(ResourceCountsSummary environmentTemplates) {
            this.environmentTemplates = environmentTemplates;
            return this;
        }

        public final ResourceCountsSummary.Builder getEnvironments() {
            return environments != null ? environments.toBuilder() : null;
        }

        public final void setEnvironments(ResourceCountsSummary.BuilderImpl environments) {
            this.environments = environments != null ? environments.build() : null;
        }

        @Override
        public final Builder environments(ResourceCountsSummary environments) {
            this.environments = environments;
            return this;
        }

        public final ResourceCountsSummary.Builder getPipelines() {
            return pipelines != null ? pipelines.toBuilder() : null;
        }

        public final void setPipelines(ResourceCountsSummary.BuilderImpl pipelines) {
            this.pipelines = pipelines != null ? pipelines.build() : null;
        }

        @Override
        public final Builder pipelines(ResourceCountsSummary pipelines) {
            this.pipelines = pipelines;
            return this;
        }

        public final ResourceCountsSummary.Builder getServiceInstances() {
            return serviceInstances != null ? serviceInstances.toBuilder() : null;
        }

        public final void setServiceInstances(ResourceCountsSummary.BuilderImpl serviceInstances) {
            this.serviceInstances = serviceInstances != null ? serviceInstances.build() : null;
        }

        @Override
        public final Builder serviceInstances(ResourceCountsSummary serviceInstances) {
            this.serviceInstances = serviceInstances;
            return this;
        }

        public final ResourceCountsSummary.Builder getServiceTemplates() {
            return serviceTemplates != null ? serviceTemplates.toBuilder() : null;
        }

        public final void setServiceTemplates(ResourceCountsSummary.BuilderImpl serviceTemplates) {
            this.serviceTemplates = serviceTemplates != null ? serviceTemplates.build() : null;
        }

        @Override
        public final Builder serviceTemplates(ResourceCountsSummary serviceTemplates) {
            this.serviceTemplates = serviceTemplates;
            return this;
        }

        public final ResourceCountsSummary.Builder getServices() {
            return services != null ? services.toBuilder() : null;
        }

        public final void setServices(ResourceCountsSummary.BuilderImpl services) {
            this.services = services != null ? services.build() : null;
        }

        @Override
        public final Builder services(ResourceCountsSummary services) {
            this.services = services;
            return this;
        }

        @Override
        public CountsSummary build() {
            return new CountsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
