/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateComponentRequest.Builder, UpdateComponentRequest> {
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(UpdateComponentRequest::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateComponentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(UpdateComponentRequest::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(UpdateComponentRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceSpec").getter(getter(UpdateComponentRequest::serviceSpec)).setter(setter(Builder::serviceSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()).build();

    private static final SdkField<String> TEMPLATE_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateFile").getter(getter(UpdateComponentRequest::templateFile))
            .setter(setter(Builder::templateFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TYPE_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, SERVICE_SPEC_FIELD,
            TEMPLATE_FILE_FIELD));

    private final String deploymentType;

    private final String description;

    private final String name;

    private final String serviceInstanceName;

    private final String serviceName;

    private final String serviceSpec;

    private final String templateFile;

    private UpdateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentType = builder.deploymentType;
        this.description = builder.description;
        this.name = builder.name;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
        this.templateFile = builder.templateFile;
    }

    /**
     * <p>
     * The deployment type. It defines the mode for updating a component, as follows:
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You can only
     * specify <code>description</code> in this mode.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
     * <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are updated.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link ComponentDeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type. It defines the mode for updating a component, as follows:</p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You
     *         can only specify <code>description</code> in this mode.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
     *         <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
     *         updated.
     *         </p>
     *         </dd>
     * @see ComponentDeploymentUpdateType
     */
    public final ComponentDeploymentUpdateType deploymentType() {
        return ComponentDeploymentUpdateType.fromValue(deploymentType);
    }

    /**
     * <p>
     * The deployment type. It defines the mode for updating a component, as follows:
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You can only
     * specify <code>description</code> in this mode.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
     * <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are updated.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link ComponentDeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type. It defines the mode for updating a component, as follows:</p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You
     *         can only specify <code>description</code> in this mode.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
     *         <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
     *         updated.
     *         </p>
     *         </dd>
     * @see ComponentDeploymentUpdateType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * An optional customer-provided description of the component.
     * </p>
     * 
     * @return An optional customer-provided description of the component.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the component to update.
     * </p>
     * 
     * @return The name of the component to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the service instance that you want to attach this component to. Don't specify to keep the component's
     * current service instance attachment. Specify an empty string to detach the component from the service instance
     * it's attached to. Specify non-empty values for both <code>serviceInstanceName</code> and <code>serviceName</code>
     * or for neither of them.
     * </p>
     * 
     * @return The name of the service instance that you want to attach this component to. Don't specify to keep the
     *         component's current service instance attachment. Specify an empty string to detach the component from the
     *         service instance it's attached to. Specify non-empty values for both <code>serviceInstanceName</code> and
     *         <code>serviceName</code> or for neither of them.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that <code>serviceInstanceName</code> is associated with. Don't specify to keep the
     * component's current service instance attachment. Specify an empty string to detach the component from the service
     * instance it's attached to. Specify non-empty values for both <code>serviceInstanceName</code> and
     * <code>serviceName</code> or for neither of them.
     * </p>
     * 
     * @return The name of the service that <code>serviceInstanceName</code> is associated with. Don't specify to keep
     *         the component's current service instance attachment. Specify an empty string to detach the component from
     *         the service instance it's attached to. Specify non-empty values for both <code>serviceInstanceName</code>
     *         and <code>serviceName</code> or for neither of them.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The service spec that you want the component to use to access service inputs. Set this only when the component is
     * attached to a service instance.
     * </p>
     * 
     * @return The service spec that you want the component to use to access service inputs. Set this only when the
     *         component is attached to a service instance.
     */
    public final String serviceSpec() {
        return serviceSpec;
    }

    /**
     * <p>
     * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
     * </p>
     * <note>
     * <p>
     * Components support a single IaC file, even if you use Terraform as your template language.
     * </p>
     * </note>
     * 
     * @return A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component
     *         provisions.</p> <note>
     *         <p>
     *         Components support a single IaC file, even if you use Terraform as your template language.
     *         </p>
     */
    public final String templateFile() {
        return templateFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(templateFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentRequest)) {
            return false;
        }
        UpdateComponentRequest other = (UpdateComponentRequest) obj;
        return Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceSpec(), other.serviceSpec())
                && Objects.equals(templateFile(), other.templateFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentRequest").add("DeploymentType", deploymentTypeAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("ServiceInstanceName", serviceInstanceName()).add("ServiceName", serviceName())
                .add("ServiceSpec", serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateFile", templateFile() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "serviceSpec":
            return Optional.ofNullable(clazz.cast(serviceSpec()));
        case "templateFile":
            return Optional.ofNullable(clazz.cast(templateFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentRequest, T> g) {
        return obj -> g.apply((UpdateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComponentRequest> {
        /**
         * <p>
         * The deployment type. It defines the mode for updating a component, as follows:
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You can
         * only specify <code>description</code> in this mode.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
         * <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
         * updated.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        The deployment type. It defines the mode for updating a component, as follows:</p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        You can only specify <code>description</code> in this mode.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
         *        <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
         *        updated.
         *        </p>
         *        </dd>
         * @see ComponentDeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentDeploymentUpdateType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * The deployment type. It defines the mode for updating a component, as follows:
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated. You can
         * only specify <code>description</code> in this mode.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
         * <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
         * updated.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        The deployment type. It defines the mode for updating a component, as follows:</p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        You can only specify <code>description</code> in this mode.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the component is deployed and updated with the new <code>serviceSpec</code>,
         *        <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are
         *        updated.
         *        </p>
         *        </dd>
         * @see ComponentDeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentDeploymentUpdateType
         */
        Builder deploymentType(ComponentDeploymentUpdateType deploymentType);

        /**
         * <p>
         * An optional customer-provided description of the component.
         * </p>
         * 
         * @param description
         *        An optional customer-provided description of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the component to update.
         * </p>
         * 
         * @param name
         *        The name of the component to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the service instance that you want to attach this component to. Don't specify to keep the
         * component's current service instance attachment. Specify an empty string to detach the component from the
         * service instance it's attached to. Specify non-empty values for both <code>serviceInstanceName</code> and
         * <code>serviceName</code> or for neither of them.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that you want to attach this component to. Don't specify to keep the
         *        component's current service instance attachment. Specify an empty string to detach the component from
         *        the service instance it's attached to. Specify non-empty values for both
         *        <code>serviceInstanceName</code> and <code>serviceName</code> or for neither of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that <code>serviceInstanceName</code> is associated with. Don't specify to keep the
         * component's current service instance attachment. Specify an empty string to detach the component from the
         * service instance it's attached to. Specify non-empty values for both <code>serviceInstanceName</code> and
         * <code>serviceName</code> or for neither of them.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that <code>serviceInstanceName</code> is associated with. Don't specify to
         *        keep the component's current service instance attachment. Specify an empty string to detach the
         *        component from the service instance it's attached to. Specify non-empty values for both
         *        <code>serviceInstanceName</code> and <code>serviceName</code> or for neither of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The service spec that you want the component to use to access service inputs. Set this only when the
         * component is attached to a service instance.
         * </p>
         * 
         * @param serviceSpec
         *        The service spec that you want the component to use to access service inputs. Set this only when the
         *        component is attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpec(String serviceSpec);

        /**
         * <p>
         * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
         * </p>
         * <note>
         * <p>
         * Components support a single IaC file, even if you use Terraform as your template language.
         * </p>
         * </note>
         * 
         * @param templateFile
         *        A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component
         *        provisions.</p> <note>
         *        <p>
         *        Components support a single IaC file, even if you use Terraform as your template language.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateFile(String templateFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String deploymentType;

        private String description;

        private String name;

        private String serviceInstanceName;

        private String serviceName;

        private String serviceSpec;

        private String templateFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentRequest model) {
            super(model);
            deploymentType(model.deploymentType);
            description(model.description);
            name(model.name);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
            serviceSpec(model.serviceSpec);
            templateFile(model.templateFile);
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(ComponentDeploymentUpdateType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public final String getTemplateFile() {
            return templateFile;
        }

        public final void setTemplateFile(String templateFile) {
            this.templateFile = templateFile;
        }

        @Override
        public final Builder templateFile(String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentRequest build() {
            return new UpdateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
