/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.proton.DefaultProtonAsyncClient;
import software.amazon.awssdk.services.proton.DefaultProtonBaseClientBuilder;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.ProtonAsyncClientBuilder;
import software.amazon.awssdk.services.proton.ProtonServiceClientConfiguration;
import software.amazon.awssdk.services.proton.endpoints.ProtonEndpointProvider;

@SdkInternalApi
final class DefaultProtonAsyncClientBuilder
extends DefaultProtonBaseClientBuilder<ProtonAsyncClientBuilder, ProtonAsyncClient>
implements ProtonAsyncClientBuilder {
    DefaultProtonAsyncClientBuilder() {
    }

    @Override
    public DefaultProtonAsyncClientBuilder endpointProvider(ProtonEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ProtonAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultProtonAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ProtonServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultProtonAsyncClient client = new DefaultProtonAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ProtonServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ProtonServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

