/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.DeploymentState;
import software.amazon.awssdk.services.proton.model.DeploymentStatus;
import software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Deployment.getter(Deployment::arn)).setter(Deployment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(Deployment.getter(Deployment::completedAt)).setter(Deployment.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(Deployment.getter(Deployment::componentName)).setter(Deployment.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Deployment.getter(Deployment::createdAt)).setter(Deployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(Deployment.getter(Deployment::deploymentStatusAsString)).setter(Deployment.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatusMessage").getter(Deployment.getter(Deployment::deploymentStatusMessage)).setter(Deployment.setter(Builder::deploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(Deployment.getter(Deployment::environmentName)).setter(Deployment.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Deployment.getter(Deployment::id)).setter(Deployment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<DeploymentState> INITIAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("initialState").getter(Deployment.getter(Deployment::initialState)).setter(Deployment.setter(Builder::initialState)).constructor(DeploymentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialState").build()}).build();
    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastAttemptedDeploymentId").getter(Deployment.getter(Deployment::lastAttemptedDeploymentId)).setter(Deployment.setter(Builder::lastAttemptedDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(Deployment.getter(Deployment::lastModifiedAt)).setter(Deployment.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSucceededDeploymentId").getter(Deployment.getter(Deployment::lastSucceededDeploymentId)).setter(Deployment.setter(Builder::lastSucceededDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(Deployment.getter(Deployment::serviceInstanceName)).setter(Deployment.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(Deployment.getter(Deployment::serviceName)).setter(Deployment.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(Deployment.getter(Deployment::targetArn)).setter(Deployment.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<Instant> TARGET_RESOURCE_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("targetResourceCreatedAt").getter(Deployment.getter(Deployment::targetResourceCreatedAt)).setter(Deployment.setter(Builder::targetResourceCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceCreatedAt").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceType").getter(Deployment.getter(Deployment::targetResourceTypeAsString)).setter(Deployment.setter(Builder::targetResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build()}).build();
    private static final SdkField<DeploymentState> TARGET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetState").getter(Deployment.getter(Deployment::targetState)).setter(Deployment.setter(Builder::targetState)).constructor(DeploymentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPLETED_AT_FIELD, COMPONENT_NAME_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, INITIAL_STATE_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_MODIFIED_AT_FIELD, LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, TARGET_ARN_FIELD, TARGET_RESOURCE_CREATED_AT_FIELD, TARGET_RESOURCE_TYPE_FIELD, TARGET_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant completedAt;
    private final String componentName;
    private final Instant createdAt;
    private final String deploymentStatus;
    private final String deploymentStatusMessage;
    private final String environmentName;
    private final String id;
    private final DeploymentState initialState;
    private final String lastAttemptedDeploymentId;
    private final Instant lastModifiedAt;
    private final String lastSucceededDeploymentId;
    private final String serviceInstanceName;
    private final String serviceName;
    private final String targetArn;
    private final Instant targetResourceCreatedAt;
    private final String targetResourceType;
    private final DeploymentState targetState;

    private Deployment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.completedAt = builder.completedAt;
        this.componentName = builder.componentName;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.initialState = builder.initialState;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.targetArn = builder.targetArn;
        this.targetResourceCreatedAt = builder.targetResourceCreatedAt;
        this.targetResourceType = builder.targetResourceType;
        this.targetState = builder.targetState;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String deploymentStatusMessage() {
        return this.deploymentStatusMessage;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final DeploymentState initialState() {
        return this.initialState;
    }

    public final String lastAttemptedDeploymentId() {
        return this.lastAttemptedDeploymentId;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String lastSucceededDeploymentId() {
        return this.lastSucceededDeploymentId;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final Instant targetResourceCreatedAt() {
        return this.targetResourceCreatedAt;
    }

    public final DeploymentTargetResourceType targetResourceType() {
        return DeploymentTargetResourceType.fromValue(this.targetResourceType);
    }

    public final String targetResourceTypeAsString() {
        return this.targetResourceType;
    }

    public final DeploymentState targetState() {
        return this.targetState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialState());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentStatusMessage(), other.deploymentStatusMessage()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.initialState(), other.initialState()) && Objects.equals(this.lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.lastSucceededDeploymentId(), other.lastSucceededDeploymentId()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.targetResourceCreatedAt(), other.targetResourceCreatedAt()) && Objects.equals(this.targetResourceTypeAsString(), other.targetResourceTypeAsString()) && Objects.equals(this.targetState(), other.targetState());
    }

    public final String toString() {
        return ToString.builder((String)"Deployment").add("Arn", (Object)this.arn()).add("CompletedAt", (Object)this.completedAt()).add("ComponentName", (Object)this.componentName()).add("CreatedAt", (Object)this.createdAt()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentStatusMessage", (Object)(this.deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("InitialState", (Object)this.initialState()).add("LastAttemptedDeploymentId", (Object)this.lastAttemptedDeploymentId()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("LastSucceededDeploymentId", (Object)this.lastSucceededDeploymentId()).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).add("TargetArn", (Object)this.targetArn()).add("TargetResourceCreatedAt", (Object)this.targetResourceCreatedAt()).add("TargetResourceType", (Object)this.targetResourceTypeAsString()).add("TargetState", (Object)this.targetState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "deploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessage()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "initialState": {
                return Optional.ofNullable(clazz.cast(this.initialState()));
            }
            case "lastAttemptedDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDeploymentId()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "lastSucceededDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSucceededDeploymentId()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "targetResourceCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.targetResourceCreatedAt()));
            }
            case "targetResourceType": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypeAsString()));
            }
            case "targetState": {
                return Optional.ofNullable(clazz.cast(this.targetState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant completedAt;
        private String componentName;
        private Instant createdAt;
        private String deploymentStatus;
        private String deploymentStatusMessage;
        private String environmentName;
        private String id;
        private DeploymentState initialState;
        private String lastAttemptedDeploymentId;
        private Instant lastModifiedAt;
        private String lastSucceededDeploymentId;
        private String serviceInstanceName;
        private String serviceName;
        private String targetArn;
        private Instant targetResourceCreatedAt;
        private String targetResourceType;
        private DeploymentState targetState;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.arn(model.arn);
            this.completedAt(model.completedAt);
            this.componentName(model.componentName);
            this.createdAt(model.createdAt);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentStatusMessage(model.deploymentStatusMessage);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.initialState(model.initialState);
            this.lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            this.lastModifiedAt(model.lastModifiedAt);
            this.lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
            this.targetArn(model.targetArn);
            this.targetResourceCreatedAt(model.targetResourceCreatedAt);
            this.targetResourceType(model.targetResourceType);
            this.targetState(model.targetState);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return this.deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DeploymentState.Builder getInitialState() {
            return this.initialState != null ? this.initialState.toBuilder() : null;
        }

        public final void setInitialState(DeploymentState.BuilderImpl initialState) {
            this.initialState = initialState != null ? initialState.build() : null;
        }

        @Override
        public final Builder initialState(DeploymentState initialState) {
            this.initialState = initialState;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return this.lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return this.lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getTargetResourceCreatedAt() {
            return this.targetResourceCreatedAt;
        }

        public final void setTargetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
        }

        @Override
        public final Builder targetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
            return this;
        }

        public final String getTargetResourceType() {
            return this.targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(DeploymentTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final DeploymentState.Builder getTargetState() {
            return this.targetState != null ? this.targetState.toBuilder() : null;
        }

        public final void setTargetState(DeploymentState.BuilderImpl targetState) {
            this.targetState = targetState != null ? targetState.build() : null;
        }

        @Override
        public final Builder targetState(DeploymentState targetState) {
            this.targetState = targetState;
            return this;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder arn(String var1);

        public Builder completedAt(Instant var1);

        public Builder componentName(String var1);

        public Builder createdAt(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentStatusMessage(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder initialState(DeploymentState var1);

        default public Builder initialState(Consumer<DeploymentState.Builder> initialState) {
            return this.initialState((DeploymentState)((DeploymentState.Builder)DeploymentState.builder().applyMutation(initialState)).build());
        }

        public Builder lastAttemptedDeploymentId(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder lastSucceededDeploymentId(String var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder targetArn(String var1);

        public Builder targetResourceCreatedAt(Instant var1);

        public Builder targetResourceType(String var1);

        public Builder targetResourceType(DeploymentTargetResourceType var1);

        public Builder targetState(DeploymentState var1);

        default public Builder targetState(Consumer<DeploymentState.Builder> targetState) {
            return this.targetState((DeploymentState)((DeploymentState.Builder)DeploymentState.builder().applyMutation(targetState)).build());
        }
    }
}

