/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceInstanceSyncStatusResponse extends ProtonResponse implements
        ToCopyableBuilder<GetServiceInstanceSyncStatusResponse.Builder, GetServiceInstanceSyncStatusResponse> {
    private static final SdkField<Revision> DESIRED_STATE_FIELD = SdkField.<Revision> builder(MarshallingType.SDK_POJO)
            .memberName("desiredState").getter(getter(GetServiceInstanceSyncStatusResponse::desiredState))
            .setter(setter(Builder::desiredState)).constructor(Revision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredState").build()).build();

    private static final SdkField<ResourceSyncAttempt> LATEST_SUCCESSFUL_SYNC_FIELD = SdkField
            .<ResourceSyncAttempt> builder(MarshallingType.SDK_POJO).memberName("latestSuccessfulSync")
            .getter(getter(GetServiceInstanceSyncStatusResponse::latestSuccessfulSync))
            .setter(setter(Builder::latestSuccessfulSync)).constructor(ResourceSyncAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSuccessfulSync").build())
            .build();

    private static final SdkField<ResourceSyncAttempt> LATEST_SYNC_FIELD = SdkField
            .<ResourceSyncAttempt> builder(MarshallingType.SDK_POJO).memberName("latestSync")
            .getter(getter(GetServiceInstanceSyncStatusResponse::latestSync)).setter(setter(Builder::latestSync))
            .constructor(ResourceSyncAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSync").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            LATEST_SUCCESSFUL_SYNC_FIELD, LATEST_SYNC_FIELD));

    private final Revision desiredState;

    private final ResourceSyncAttempt latestSuccessfulSync;

    private final ResourceSyncAttempt latestSync;

    private GetServiceInstanceSyncStatusResponse(BuilderImpl builder) {
        super(builder);
        this.desiredState = builder.desiredState;
        this.latestSuccessfulSync = builder.latestSuccessfulSync;
        this.latestSync = builder.latestSync;
    }

    /**
     * <p>
     * The service instance sync desired state that's returned by Proton
     * </p>
     * 
     * @return The service instance sync desired state that's returned by Proton
     */
    public final Revision desiredState() {
        return desiredState;
    }

    /**
     * <p>
     * The detailed data of the latest successful sync with the service instance.
     * </p>
     * 
     * @return The detailed data of the latest successful sync with the service instance.
     */
    public final ResourceSyncAttempt latestSuccessfulSync() {
        return latestSuccessfulSync;
    }

    /**
     * <p>
     * The detailed data of the latest sync with the service instance.
     * </p>
     * 
     * @return The detailed data of the latest sync with the service instance.
     */
    public final ResourceSyncAttempt latestSync() {
        return latestSync;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(desiredState());
        hashCode = 31 * hashCode + Objects.hashCode(latestSuccessfulSync());
        hashCode = 31 * hashCode + Objects.hashCode(latestSync());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceInstanceSyncStatusResponse)) {
            return false;
        }
        GetServiceInstanceSyncStatusResponse other = (GetServiceInstanceSyncStatusResponse) obj;
        return Objects.equals(desiredState(), other.desiredState())
                && Objects.equals(latestSuccessfulSync(), other.latestSuccessfulSync())
                && Objects.equals(latestSync(), other.latestSync());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceInstanceSyncStatusResponse").add("DesiredState", desiredState())
                .add("LatestSuccessfulSync", latestSuccessfulSync()).add("LatestSync", latestSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredState":
            return Optional.ofNullable(clazz.cast(desiredState()));
        case "latestSuccessfulSync":
            return Optional.ofNullable(clazz.cast(latestSuccessfulSync()));
        case "latestSync":
            return Optional.ofNullable(clazz.cast(latestSync()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceInstanceSyncStatusResponse, T> g) {
        return obj -> g.apply((GetServiceInstanceSyncStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceInstanceSyncStatusResponse> {
        /**
         * <p>
         * The service instance sync desired state that's returned by Proton
         * </p>
         * 
         * @param desiredState
         *        The service instance sync desired state that's returned by Proton
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredState(Revision desiredState);

        /**
         * <p>
         * The service instance sync desired state that's returned by Proton
         * </p>
         * This is a convenience method that creates an instance of the {@link Revision.Builder} avoiding the need to
         * create one manually via {@link Revision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Revision.Builder#build()} is called immediately and its result is
         * passed to {@link #desiredState(Revision)}.
         * 
         * @param desiredState
         *        a consumer that will call methods on {@link Revision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredState(Revision)
         */
        default Builder desiredState(Consumer<Revision.Builder> desiredState) {
            return desiredState(Revision.builder().applyMutation(desiredState).build());
        }

        /**
         * <p>
         * The detailed data of the latest successful sync with the service instance.
         * </p>
         * 
         * @param latestSuccessfulSync
         *        The detailed data of the latest successful sync with the service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSuccessfulSync(ResourceSyncAttempt latestSuccessfulSync);

        /**
         * <p>
         * The detailed data of the latest successful sync with the service instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSyncAttempt.Builder} avoiding the
         * need to create one manually via {@link ResourceSyncAttempt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSyncAttempt.Builder#build()} is called immediately and
         * its result is passed to {@link #latestSuccessfulSync(ResourceSyncAttempt)}.
         * 
         * @param latestSuccessfulSync
         *        a consumer that will call methods on {@link ResourceSyncAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestSuccessfulSync(ResourceSyncAttempt)
         */
        default Builder latestSuccessfulSync(Consumer<ResourceSyncAttempt.Builder> latestSuccessfulSync) {
            return latestSuccessfulSync(ResourceSyncAttempt.builder().applyMutation(latestSuccessfulSync).build());
        }

        /**
         * <p>
         * The detailed data of the latest sync with the service instance.
         * </p>
         * 
         * @param latestSync
         *        The detailed data of the latest sync with the service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSync(ResourceSyncAttempt latestSync);

        /**
         * <p>
         * The detailed data of the latest sync with the service instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSyncAttempt.Builder} avoiding the
         * need to create one manually via {@link ResourceSyncAttempt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSyncAttempt.Builder#build()} is called immediately and
         * its result is passed to {@link #latestSync(ResourceSyncAttempt)}.
         * 
         * @param latestSync
         *        a consumer that will call methods on {@link ResourceSyncAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestSync(ResourceSyncAttempt)
         */
        default Builder latestSync(Consumer<ResourceSyncAttempt.Builder> latestSync) {
            return latestSync(ResourceSyncAttempt.builder().applyMutation(latestSync).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private Revision desiredState;

        private ResourceSyncAttempt latestSuccessfulSync;

        private ResourceSyncAttempt latestSync;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceInstanceSyncStatusResponse model) {
            super(model);
            desiredState(model.desiredState);
            latestSuccessfulSync(model.latestSuccessfulSync);
            latestSync(model.latestSync);
        }

        public final Revision.Builder getDesiredState() {
            return desiredState != null ? desiredState.toBuilder() : null;
        }

        public final void setDesiredState(Revision.BuilderImpl desiredState) {
            this.desiredState = desiredState != null ? desiredState.build() : null;
        }

        @Override
        public final Builder desiredState(Revision desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        public final ResourceSyncAttempt.Builder getLatestSuccessfulSync() {
            return latestSuccessfulSync != null ? latestSuccessfulSync.toBuilder() : null;
        }

        public final void setLatestSuccessfulSync(ResourceSyncAttempt.BuilderImpl latestSuccessfulSync) {
            this.latestSuccessfulSync = latestSuccessfulSync != null ? latestSuccessfulSync.build() : null;
        }

        @Override
        public final Builder latestSuccessfulSync(ResourceSyncAttempt latestSuccessfulSync) {
            this.latestSuccessfulSync = latestSuccessfulSync;
            return this;
        }

        public final ResourceSyncAttempt.Builder getLatestSync() {
            return latestSync != null ? latestSync.toBuilder() : null;
        }

        public final void setLatestSync(ResourceSyncAttempt.BuilderImpl latestSync) {
            this.latestSync = latestSync != null ? latestSync.build() : null;
        }

        @Override
        public final Builder latestSync(ResourceSyncAttempt latestSync) {
            this.latestSync = latestSync;
            return this;
        }

        @Override
        public GetServiceInstanceSyncStatusResponse build() {
            return new GetServiceInstanceSyncStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
