/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListComponentOutputsPublisher
implements SdkPublisher<ListComponentOutputsResponse> {
    private final ProtonAsyncClient client;
    private final ListComponentOutputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentOutputsPublisher(ProtonAsyncClient client, ListComponentOutputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentOutputsPublisher(ProtonAsyncClient client, ListComponentOutputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentOutputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentOutputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Output> outputs() {
        Function<ListComponentOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComponentOutputsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComponentOutputsResponseFetcher
    implements AsyncPageFetcher<ListComponentOutputsResponse> {
        private ListComponentOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentOutputsResponse> nextPage(ListComponentOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentOutputsPublisher.this.client.listComponentOutputs(ListComponentOutputsPublisher.this.firstRequest);
            }
            return ListComponentOutputsPublisher.this.client.listComponentOutputs((ListComponentOutputsRequest)((Object)ListComponentOutputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

