/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComponentRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, UpdateComponentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateComponentRequest.getter(UpdateComponentRequest::clientToken)).setter(UpdateComponentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(UpdateComponentRequest.getter(UpdateComponentRequest::deploymentTypeAsString)).setter(UpdateComponentRequest.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateComponentRequest.getter(UpdateComponentRequest::description)).setter(UpdateComponentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateComponentRequest.getter(UpdateComponentRequest::name)).setter(UpdateComponentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(UpdateComponentRequest.getter(UpdateComponentRequest::serviceInstanceName)).setter(UpdateComponentRequest.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(UpdateComponentRequest.getter(UpdateComponentRequest::serviceName)).setter(UpdateComponentRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceSpec").getter(UpdateComponentRequest.getter(UpdateComponentRequest::serviceSpec)).setter(UpdateComponentRequest.setter(Builder::serviceSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()}).build();
    private static final SdkField<String> TEMPLATE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateFile").getter(UpdateComponentRequest.getter(UpdateComponentRequest::templateFile)).setter(UpdateComponentRequest.setter(Builder::templateFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DEPLOYMENT_TYPE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, SERVICE_SPEC_FIELD, TEMPLATE_FILE_FIELD));
    private final String clientToken;
    private final String deploymentType;
    private final String description;
    private final String name;
    private final String serviceInstanceName;
    private final String serviceName;
    private final String serviceSpec;
    private final String templateFile;

    private UpdateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deploymentType = builder.deploymentType;
        this.description = builder.description;
        this.name = builder.name;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
        this.templateFile = builder.templateFile;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ComponentDeploymentUpdateType deploymentType() {
        return ComponentDeploymentUpdateType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceSpec() {
        return this.serviceSpec;
    }

    public final String templateFile() {
        return this.templateFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentRequest)) {
            return false;
        }
        UpdateComponentRequest other = (UpdateComponentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceSpec(), other.serviceSpec()) && Objects.equals(this.templateFile(), other.templateFile());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComponentRequest").add("ClientToken", (Object)this.clientToken()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).add("ServiceSpec", (Object)(this.serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateFile", (Object)(this.templateFile() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceSpec": {
                return Optional.ofNullable(clazz.cast(this.serviceSpec()));
            }
            case "templateFile": {
                return Optional.ofNullable(clazz.cast(this.templateFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentRequest, T> g) {
        return obj -> g.apply((UpdateComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deploymentType;
        private String description;
        private String name;
        private String serviceInstanceName;
        private String serviceName;
        private String serviceSpec;
        private String templateFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deploymentType(model.deploymentType);
            this.description(model.description);
            this.name(model.name);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
            this.serviceSpec(model.serviceSpec);
            this.templateFile(model.templateFile);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(ComponentDeploymentUpdateType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return this.serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public final String getTemplateFile() {
            return this.templateFile;
        }

        public final void setTemplateFile(String templateFile) {
            this.templateFile = templateFile;
        }

        @Override
        public final Builder templateFile(String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentRequest build() {
            return new UpdateComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComponentRequest> {
        public Builder clientToken(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(ComponentDeploymentUpdateType var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder serviceSpec(String var1);

        public Builder templateFile(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

