/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Revision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Revision> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branch").getter(Revision.getter(Revision::branch)).setter(Revision.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<String> DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directory").getter(Revision.getter(Revision::directory)).setter(Revision.setter(Builder::directory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directory").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(Revision.getter(Revision::repositoryName)).setter(Revision.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryProvider").getter(Revision.getter(Revision::repositoryProviderAsString)).setter(Revision.setter(Builder::repositoryProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build()}).build();
    private static final SdkField<String> SHA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sha").getter(Revision.getter(Revision::sha)).setter(Revision.setter(Builder::sha)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SHA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("branch", BRANCH_FIELD);
            this.put("directory", DIRECTORY_FIELD);
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("repositoryProvider", REPOSITORY_PROVIDER_FIELD);
            this.put("sha", SHA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String branch;
    private final String directory;
    private final String repositoryName;
    private final String repositoryProvider;
    private final String sha;

    private Revision(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.sha = builder.sha;
    }

    public final String branch() {
        return this.branch;
    }

    public final String directory() {
        return this.directory;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(this.repositoryProvider);
    }

    public final String repositoryProviderAsString() {
        return this.repositoryProvider;
    }

    public final String sha() {
        return this.sha;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.directory());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.directory(), other.directory()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryProviderAsString(), other.repositoryProviderAsString()) && Objects.equals(this.sha(), other.sha());
    }

    public final String toString() {
        return ToString.builder((String)"Revision").add("Branch", (Object)this.branch()).add("Directory", (Object)this.directory()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryProvider", (Object)this.repositoryProviderAsString()).add("Sha", (Object)this.sha()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "directory": {
                return Optional.ofNullable(clazz.cast(this.directory()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryProvider": {
                return Optional.ofNullable(clazz.cast(this.repositoryProviderAsString()));
            }
            case "sha": {
                return Optional.ofNullable(clazz.cast(this.sha()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Revision, T> g) {
        return obj -> g.apply((Revision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branch;
        private String directory;
        private String repositoryName;
        private String repositoryProvider;
        private String sha;

        private BuilderImpl() {
        }

        private BuilderImpl(Revision model) {
            this.branch(model.branch);
            this.directory(model.directory);
            this.repositoryName(model.repositoryName);
            this.repositoryProvider(model.repositoryProvider);
            this.sha(model.sha);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return this.directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return this.repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getSha() {
            return this.sha;
        }

        public final void setSha(String sha) {
            this.sha = sha;
        }

        @Override
        public final Builder sha(String sha) {
            this.sha = sha;
            return this;
        }

        public Revision build() {
            return new Revision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Revision> {
        public Builder branch(String var1);

        public Builder directory(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryProvider(String var1);

        public Builder repositoryProvider(RepositoryProvider var1);

        public Builder sha(String var1);
    }
}

