/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.TemplateVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentTemplateVersionRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentTemplateVersionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateEnvironmentTemplateVersionRequest.getter(UpdateEnvironmentTemplateVersionRequest::description)).setter(UpdateEnvironmentTemplateVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(UpdateEnvironmentTemplateVersionRequest.getter(UpdateEnvironmentTemplateVersionRequest::majorVersion)).setter(UpdateEnvironmentTemplateVersionRequest.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("minorVersion").getter(UpdateEnvironmentTemplateVersionRequest.getter(UpdateEnvironmentTemplateVersionRequest::minorVersion)).setter(UpdateEnvironmentTemplateVersionRequest.setter(Builder::minorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateEnvironmentTemplateVersionRequest.getter(UpdateEnvironmentTemplateVersionRequest::statusAsString)).setter(UpdateEnvironmentTemplateVersionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(UpdateEnvironmentTemplateVersionRequest.getter(UpdateEnvironmentTemplateVersionRequest::templateName)).setter(UpdateEnvironmentTemplateVersionRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, MAJOR_VERSION_FIELD, MINOR_VERSION_FIELD, STATUS_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("majorVersion", MAJOR_VERSION_FIELD);
            this.put("minorVersion", MINOR_VERSION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("templateName", TEMPLATE_NAME_FIELD);
        }
    });
    private final String description;
    private final String majorVersion;
    private final String minorVersion;
    private final String status;
    private final String templateName;

    private UpdateEnvironmentTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.status = builder.status;
        this.templateName = builder.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final String minorVersion() {
        return this.minorVersion;
    }

    public final TemplateVersionStatus status() {
        return TemplateVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentTemplateVersionRequest)) {
            return false;
        }
        UpdateEnvironmentTemplateVersionRequest other = (UpdateEnvironmentTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentTemplateVersionRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MajorVersion", (Object)this.majorVersion()).add("MinorVersion", (Object)this.minorVersion()).add("Status", (Object)this.statusAsString()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "minorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentTemplateVersionRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String description;
        private String majorVersion;
        private String minorVersion;
        private String status;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentTemplateVersionRequest model) {
            super(model);
            this.description(model.description);
            this.majorVersion(model.majorVersion);
            this.minorVersion(model.minorVersion);
            this.status(model.status);
            this.templateName(model.templateName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentTemplateVersionRequest build() {
            return new UpdateEnvironmentTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentTemplateVersionRequest> {
        public Builder description(String var1);

        public Builder majorVersion(String var1);

        public Builder minorVersion(String var1);

        public Builder status(String var1);

        public Builder status(TemplateVersionStatus var1);

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

