/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceTemplateVersionRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateServiceTemplateVersionRequest.Builder, CreateServiceTemplateVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateServiceTemplateVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<CompatibleEnvironmentTemplateInput>> COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD = SdkField
            .<List<CompatibleEnvironmentTemplateInput>> builder(MarshallingType.LIST)
            .memberName("compatibleEnvironmentTemplates")
            .getter(getter(CreateServiceTemplateVersionRequest::compatibleEnvironmentTemplates))
            .setter(setter(Builder::compatibleEnvironmentTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleEnvironmentTemplates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompatibleEnvironmentTemplateInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompatibleEnvironmentTemplateInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateServiceTemplateVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("majorVersion").getter(getter(CreateServiceTemplateVersionRequest::majorVersion))
            .setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()).build();

    private static final SdkField<TemplateVersionSourceInput> SOURCE_FIELD = SdkField
            .<TemplateVersionSourceInput> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(CreateServiceTemplateVersionRequest::source)).setter(setter(Builder::source))
            .constructor(TemplateVersionSourceInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<String>> SUPPORTED_COMPONENT_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedComponentSources")
            .getter(getter(CreateServiceTemplateVersionRequest::supportedComponentSourcesAsStrings))
            .setter(setter(Builder::supportedComponentSourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedComponentSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateServiceTemplateVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(CreateServiceTemplateVersionRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD, DESCRIPTION_FIELD, MAJOR_VERSION_FIELD, SOURCE_FIELD,
            SUPPORTED_COMPONENT_SOURCES_FIELD, TAGS_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates;

    private final String description;

    private final String majorVersion;

    private final TemplateVersionSourceInput source;

    private final List<String> supportedComponentSources;

    private final List<Tag> tags;

    private final String templateName;

    private CreateServiceTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.compatibleEnvironmentTemplates = builder.compatibleEnvironmentTemplates;
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.source = builder.source;
        this.supportedComponentSources = builder.supportedComponentSources;
        this.tags = builder.tags;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * When included, if two identical requests are made with the same client token, Proton returns the service template
     * version that the first request created.
     * </p>
     * 
     * @return When included, if two identical requests are made with the same client token, Proton returns the service
     *         template version that the first request created.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleEnvironmentTemplates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompatibleEnvironmentTemplates() {
        return compatibleEnvironmentTemplates != null && !(compatibleEnvironmentTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of environment template objects that are compatible with the new service template version. A service
     * instance based on this service template version can run in environments based on compatible templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleEnvironmentTemplates} method.
     * </p>
     * 
     * @return An array of environment template objects that are compatible with the new service template version. A
     *         service instance based on this service template version can run in environments based on compatible
     *         templates.
     */
    public final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates() {
        return compatibleEnvironmentTemplates;
    }

    /**
     * <p>
     * A description of the new version of a service template.
     * </p>
     * 
     * @return A description of the new version of a service template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * To create a new minor version of the service template, include a <code>major Version</code>.
     * </p>
     * <p>
     * To create a new major and minor version of the service template, <i>exclude</i> <code>major Version</code>.
     * </p>
     * 
     * @return To create a new minor version of the service template, include a <code>major Version</code>.</p>
     *         <p>
     *         To create a new major and minor version of the service template, <i>exclude</i>
     *         <code>major Version</code>.
     */
    public final String majorVersion() {
        return majorVersion;
    }

    /**
     * <p>
     * An object that includes the template bundle S3 bucket path and name for the new version of a service template.
     * </p>
     * 
     * @return An object that includes the template bundle S3 bucket path and name for the new version of a service
     *         template.
     */
    public final TemplateVersionSourceInput source() {
        return source;
    }

    /**
     * <p>
     * An array of supported component sources. Components with supported sources can be attached to service instances
     * based on this service template version.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComponentSources} method.
     * </p>
     * 
     * @return An array of supported component sources. Components with supported sources can be attached to service
     *         instances based on this service template version.</p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final List<ServiceTemplateSupportedComponentSourceType> supportedComponentSources() {
        return ServiceTemplateSupportedComponentSourceInputListCopier.copyStringToEnum(supportedComponentSources);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedComponentSources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedComponentSources() {
        return supportedComponentSources != null && !(supportedComponentSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of supported component sources. Components with supported sources can be attached to service instances
     * based on this service template version.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComponentSources} method.
     * </p>
     * 
     * @return An array of supported component sources. Components with supported sources can be attached to service
     *         instances based on this service template version.</p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final List<String> supportedComponentSourcesAsStrings() {
        return supportedComponentSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the Proton service template version. A tag is a
     * key-value pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the Proton service template version. A tag
     *         is a key-value pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
     *         tagging</a> in the <i>Proton User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the service template.
     * </p>
     * 
     * @return The name of the service template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCompatibleEnvironmentTemplates() ? compatibleEnvironmentTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedComponentSources() ? supportedComponentSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceTemplateVersionRequest)) {
            return false;
        }
        CreateServiceTemplateVersionRequest other = (CreateServiceTemplateVersionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && hasCompatibleEnvironmentTemplates() == other.hasCompatibleEnvironmentTemplates()
                && Objects.equals(compatibleEnvironmentTemplates(), other.compatibleEnvironmentTemplates())
                && Objects.equals(description(), other.description()) && Objects.equals(majorVersion(), other.majorVersion())
                && Objects.equals(source(), other.source())
                && hasSupportedComponentSources() == other.hasSupportedComponentSources()
                && Objects.equals(supportedComponentSourcesAsStrings(), other.supportedComponentSourcesAsStrings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateServiceTemplateVersionRequest")
                .add("ClientToken", clientToken())
                .add("CompatibleEnvironmentTemplates",
                        hasCompatibleEnvironmentTemplates() ? compatibleEnvironmentTemplates() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MajorVersion", majorVersion()).add("Source", source())
                .add("SupportedComponentSources", hasSupportedComponentSources() ? supportedComponentSourcesAsStrings() : null)
                .add("Tags", hasTags() ? tags() : null).add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "compatibleEnvironmentTemplates":
            return Optional.ofNullable(clazz.cast(compatibleEnvironmentTemplates()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "majorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "supportedComponentSources":
            return Optional.ofNullable(clazz.cast(supportedComponentSourcesAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("compatibleEnvironmentTemplates", COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("majorVersion", MAJOR_VERSION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("supportedComponentSources", SUPPORTED_COMPONENT_SOURCES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceTemplateVersionRequest, T> g) {
        return obj -> g.apply((CreateServiceTemplateVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceTemplateVersionRequest> {
        /**
         * <p>
         * When included, if two identical requests are made with the same client token, Proton returns the service
         * template version that the first request created.
         * </p>
         * 
         * @param clientToken
         *        When included, if two identical requests are made with the same client token, Proton returns the
         *        service template version that the first request created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An array of environment template objects that are compatible with the new service template version. A service
         * instance based on this service template version can run in environments based on compatible templates.
         * </p>
         * 
         * @param compatibleEnvironmentTemplates
         *        An array of environment template objects that are compatible with the new service template version. A
         *        service instance based on this service template version can run in environments based on compatible
         *        templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates);

        /**
         * <p>
         * An array of environment template objects that are compatible with the new service template version. A service
         * instance based on this service template version can run in environments based on compatible templates.
         * </p>
         * 
         * @param compatibleEnvironmentTemplates
         *        An array of environment template objects that are compatible with the new service template version. A
         *        service instance based on this service template version can run in environments based on compatible
         *        templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput... compatibleEnvironmentTemplates);

        /**
         * <p>
         * An array of environment template objects that are compatible with the new service template version. A service
         * instance based on this service template version can run in environments based on compatible templates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #compatibleEnvironmentTemplates(List<CompatibleEnvironmentTemplateInput>)}.
         * 
         * @param compatibleEnvironmentTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleEnvironmentTemplates(java.util.Collection<CompatibleEnvironmentTemplateInput>)
         */
        Builder compatibleEnvironmentTemplates(
                Consumer<CompatibleEnvironmentTemplateInput.Builder>... compatibleEnvironmentTemplates);

        /**
         * <p>
         * A description of the new version of a service template.
         * </p>
         * 
         * @param description
         *        A description of the new version of a service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * To create a new minor version of the service template, include a <code>major Version</code>.
         * </p>
         * <p>
         * To create a new major and minor version of the service template, <i>exclude</i> <code>major Version</code>.
         * </p>
         * 
         * @param majorVersion
         *        To create a new minor version of the service template, include a <code>major Version</code>.</p>
         *        <p>
         *        To create a new major and minor version of the service template, <i>exclude</i>
         *        <code>major Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(String majorVersion);

        /**
         * <p>
         * An object that includes the template bundle S3 bucket path and name for the new version of a service
         * template.
         * </p>
         * 
         * @param source
         *        An object that includes the template bundle S3 bucket path and name for the new version of a service
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TemplateVersionSourceInput source);

        /**
         * <p>
         * An object that includes the template bundle S3 bucket path and name for the new version of a service
         * template.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateVersionSourceInput.Builder}
         * avoiding the need to create one manually via {@link TemplateVersionSourceInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateVersionSourceInput.Builder#build()} is called immediately
         * and its result is passed to {@link #source(TemplateVersionSourceInput)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TemplateVersionSourceInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TemplateVersionSourceInput)
         */
        default Builder source(Consumer<TemplateVersionSourceInput.Builder> source) {
            return source(TemplateVersionSourceInput.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * An array of supported component sources. Components with supported sources can be attached to service
         * instances based on this service template version.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param supportedComponentSources
         *        An array of supported component sources. Components with supported sources can be attached to service
         *        instances based on this service template version.</p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComponentSourcesWithStrings(Collection<String> supportedComponentSources);

        /**
         * <p>
         * An array of supported component sources. Components with supported sources can be attached to service
         * instances based on this service template version.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param supportedComponentSources
         *        An array of supported component sources. Components with supported sources can be attached to service
         *        instances based on this service template version.</p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComponentSourcesWithStrings(String... supportedComponentSources);

        /**
         * <p>
         * An array of supported component sources. Components with supported sources can be attached to service
         * instances based on this service template version.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param supportedComponentSources
         *        An array of supported component sources. Components with supported sources can be attached to service
         *        instances based on this service template version.</p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComponentSources(Collection<ServiceTemplateSupportedComponentSourceType> supportedComponentSources);

        /**
         * <p>
         * An array of supported component sources. Components with supported sources can be attached to service
         * instances based on this service template version.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param supportedComponentSources
         *        An array of supported component sources. Components with supported sources can be attached to service
         *        instances based on this service template version.</p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComponentSources(ServiceTemplateSupportedComponentSourceType... supportedComponentSources);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service template version. A tag is
         * a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton service template version. A
         *        tag is a key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service template version. A tag is
         * a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton service template version. A
         *        tag is a key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service template version. A tag is
         * a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.proton.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.proton.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the service template.
         * </p>
         * 
         * @param templateName
         *        The name of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String clientToken;

        private List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates = DefaultSdkAutoConstructList
                .getInstance();

        private String description;

        private String majorVersion;

        private TemplateVersionSourceInput source;

        private List<String> supportedComponentSources = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceTemplateVersionRequest model) {
            super(model);
            clientToken(model.clientToken);
            compatibleEnvironmentTemplates(model.compatibleEnvironmentTemplates);
            description(model.description);
            majorVersion(model.majorVersion);
            source(model.source);
            supportedComponentSourcesWithStrings(model.supportedComponentSources);
            tags(model.tags);
            templateName(model.templateName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<CompatibleEnvironmentTemplateInput.Builder> getCompatibleEnvironmentTemplates() {
            List<CompatibleEnvironmentTemplateInput.Builder> result = CompatibleEnvironmentTemplateInputListCopier
                    .copyToBuilder(this.compatibleEnvironmentTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibleEnvironmentTemplates(
                Collection<CompatibleEnvironmentTemplateInput.BuilderImpl> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier
                    .copyFromBuilder(compatibleEnvironmentTemplates);
        }

        @Override
        public final Builder compatibleEnvironmentTemplates(
                Collection<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier
                    .copy(compatibleEnvironmentTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput... compatibleEnvironmentTemplates) {
            compatibleEnvironmentTemplates(Arrays.asList(compatibleEnvironmentTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(
                Consumer<CompatibleEnvironmentTemplateInput.Builder>... compatibleEnvironmentTemplates) {
            compatibleEnvironmentTemplates(Stream.of(compatibleEnvironmentTemplates)
                    .map(c -> CompatibleEnvironmentTemplateInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final TemplateVersionSourceInput.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TemplateVersionSourceInput.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TemplateVersionSourceInput source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getSupportedComponentSources() {
            if (supportedComponentSources instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedComponentSources;
        }

        public final void setSupportedComponentSources(Collection<String> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier
                    .copy(supportedComponentSources);
        }

        @Override
        public final Builder supportedComponentSourcesWithStrings(Collection<String> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier
                    .copy(supportedComponentSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComponentSourcesWithStrings(String... supportedComponentSources) {
            supportedComponentSourcesWithStrings(Arrays.asList(supportedComponentSources));
            return this;
        }

        @Override
        public final Builder supportedComponentSources(
                Collection<ServiceTemplateSupportedComponentSourceType> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier
                    .copyEnumToString(supportedComponentSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComponentSources(ServiceTemplateSupportedComponentSourceType... supportedComponentSources) {
            supportedComponentSources(Arrays.asList(supportedComponentSources));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceTemplateVersionRequest build() {
            return new CreateServiceTemplateVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
