/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary data of an Proton environment resource. An Proton environment is a set of resources shared across Proton
 * services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnvironmentSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(EnvironmentSummary::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EnvironmentSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(EnvironmentSummary::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatusMessage").getter(getter(EnvironmentSummary::deploymentStatusMessage))
            .setter(setter(Builder::deploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountConnectionId")
            .getter(getter(EnvironmentSummary::environmentAccountConnectionId))
            .setter(setter(Builder::environmentAccountConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnectionId")
                    .build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountId").getter(getter(EnvironmentSummary::environmentAccountId))
            .setter(setter(Builder::environmentAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountId").build())
            .build();

    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastAttemptedDeploymentId").getter(getter(EnvironmentSummary::lastAttemptedDeploymentId))
            .setter(setter(Builder::lastAttemptedDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentAttemptedAt")
            .getter(getter(EnvironmentSummary::lastDeploymentAttemptedAt)).setter(setter(Builder::lastDeploymentAttemptedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentAttemptedAt").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentSucceededAt")
            .getter(getter(EnvironmentSummary::lastDeploymentSucceededAt)).setter(setter(Builder::lastDeploymentSucceededAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentSucceededAt").build())
            .build();

    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastSucceededDeploymentId").getter(getter(EnvironmentSummary::lastSucceededDeploymentId))
            .setter(setter(Builder::lastSucceededDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTON_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protonServiceRoleArn").getter(getter(EnvironmentSummary::protonServiceRoleArn))
            .setter(setter(Builder::protonServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protonServiceRoleArn").build())
            .build();

    private static final SdkField<String> PROVISIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioning").getter(getter(EnvironmentSummary::provisioningAsString))
            .setter(setter(Builder::provisioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioning").build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(EnvironmentSummary::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(EnvironmentSummary::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(EnvironmentSummary::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_ROLE_ARN_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD,
            DESCRIPTION_FIELD, ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD, ENVIRONMENT_ACCOUNT_ID_FIELD,
            LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD, LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD,
            LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, NAME_FIELD, PROTON_SERVICE_ROLE_ARN_FIELD, PROVISIONING_FIELD,
            TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String componentRoleArn;

    private final Instant createdAt;

    private final String deploymentStatus;

    private final String deploymentStatusMessage;

    private final String description;

    private final String environmentAccountConnectionId;

    private final String environmentAccountId;

    private final String lastAttemptedDeploymentId;

    private final Instant lastDeploymentAttemptedAt;

    private final Instant lastDeploymentSucceededAt;

    private final String lastSucceededDeploymentId;

    private final String name;

    private final String protonServiceRoleArn;

    private final String provisioning;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private final String templateName;

    private EnvironmentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentRoleArn = builder.componentRoleArn;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.description = builder.description;
        this.environmentAccountConnectionId = builder.environmentAccountConnectionId;
        this.environmentAccountId = builder.environmentAccountId;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastDeploymentAttemptedAt = builder.lastDeploymentAttemptedAt;
        this.lastDeploymentSucceededAt = builder.lastDeploymentSucceededAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.name = builder.name;
        this.protonServiceRoleArn = builder.protonServiceRoleArn;
        this.provisioning = builder.provisioning;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
     * components in this environment. It determines the scope of infrastructure that a component can provision.
     * </p>
     * <p>
     * The environment must have a <code>componentRoleArn</code> to allow directly defined components to be associated
     * with the environment.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
     *         defined components in this environment. It determines the scope of infrastructure that a component can
     *         provision.</p>
     *         <p>
     *         The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
     *         associated with the environment.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * The time when the environment was created.
     * </p>
     * 
     * @return The time when the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The environment deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The environment deployment status.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The environment deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The environment deployment status.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * An environment deployment status message.
     * </p>
     * 
     * @return An environment deployment status message.
     */
    public final String deploymentStatusMessage() {
        return deploymentStatusMessage;
    }

    /**
     * <p>
     * The description of the environment.
     * </p>
     * 
     * @return The description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the environment account connection that the environment is associated with.
     * </p>
     * 
     * @return The ID of the environment account connection that the environment is associated with.
     */
    public final String environmentAccountConnectionId() {
        return environmentAccountConnectionId;
    }

    /**
     * <p>
     * The ID of the environment account that the environment infrastructure resources are provisioned in.
     * </p>
     * 
     * @return The ID of the environment account that the environment infrastructure resources are provisioned in.
     */
    public final String environmentAccountId() {
        return environmentAccountId;
    }

    /**
     * <p>
     * The ID of the last attempted deployment of this environment.
     * </p>
     * 
     * @return The ID of the last attempted deployment of this environment.
     */
    public final String lastAttemptedDeploymentId() {
        return lastAttemptedDeploymentId;
    }

    /**
     * <p>
     * The time when a deployment of the environment was last attempted.
     * </p>
     * 
     * @return The time when a deployment of the environment was last attempted.
     */
    public final Instant lastDeploymentAttemptedAt() {
        return lastDeploymentAttemptedAt;
    }

    /**
     * <p>
     * The time when the environment was last deployed successfully.
     * </p>
     * 
     * @return The time when the environment was last deployed successfully.
     */
    public final Instant lastDeploymentSucceededAt() {
        return lastDeploymentSucceededAt;
    }

    /**
     * <p>
     * The ID of the last successful deployment of this environment.
     * </p>
     * 
     * @return The ID of the last successful deployment of this environment.
     */
    public final String lastSucceededDeploymentId() {
        return lastSucceededDeploymentId;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on
     * your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other
     *         services on your behalf.
     */
    public final String protonServiceRoleArn() {
        return protonServiceRoleArn;
    }

    /**
     * <p>
     * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioning} will
     * return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #provisioningAsString}.
     * </p>
     * 
     * @return When included, indicates that the environment template is for customer provisioned and managed
     *         infrastructure.
     * @see Provisioning
     */
    public final Provisioning provisioning() {
        return Provisioning.fromValue(provisioning);
    }

    /**
     * <p>
     * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioning} will
     * return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #provisioningAsString}.
     * </p>
     * 
     * @return When included, indicates that the environment template is for customer provisioned and managed
     *         infrastructure.
     * @see Provisioning
     */
    public final String provisioningAsString() {
        return provisioning;
    }

    /**
     * <p>
     * The major version of the environment template.
     * </p>
     * 
     * @return The major version of the environment template.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the environment template.
     * </p>
     * 
     * @return The minor version of the environment template.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    /**
     * <p>
     * The name of the environment template.
     * </p>
     * 
     * @return The name of the environment template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentAttemptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentSucceededAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protonServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentRoleArn(), other.componentRoleArn())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentStatusMessage(), other.deploymentStatusMessage())
                && Objects.equals(description(), other.description())
                && Objects.equals(environmentAccountConnectionId(), other.environmentAccountConnectionId())
                && Objects.equals(environmentAccountId(), other.environmentAccountId())
                && Objects.equals(lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId())
                && Objects.equals(lastDeploymentAttemptedAt(), other.lastDeploymentAttemptedAt())
                && Objects.equals(lastDeploymentSucceededAt(), other.lastDeploymentSucceededAt())
                && Objects.equals(lastSucceededDeploymentId(), other.lastSucceededDeploymentId())
                && Objects.equals(name(), other.name()) && Objects.equals(protonServiceRoleArn(), other.protonServiceRoleArn())
                && Objects.equals(provisioningAsString(), other.provisioningAsString())
                && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("Arn", arn()).add("ComponentRoleArn", componentRoleArn())
                .add("CreatedAt", createdAt()).add("DeploymentStatus", deploymentStatusAsString())
                .add("DeploymentStatusMessage", deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentAccountConnectionId", environmentAccountConnectionId())
                .add("EnvironmentAccountId", environmentAccountId())
                .add("LastAttemptedDeploymentId", lastAttemptedDeploymentId())
                .add("LastDeploymentAttemptedAt", lastDeploymentAttemptedAt())
                .add("LastDeploymentSucceededAt", lastDeploymentSucceededAt())
                .add("LastSucceededDeploymentId", lastSucceededDeploymentId()).add("Name", name())
                .add("ProtonServiceRoleArn", protonServiceRoleArn()).add("Provisioning", provisioningAsString())
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion())
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "deploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessage()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentAccountConnectionId":
            return Optional.ofNullable(clazz.cast(environmentAccountConnectionId()));
        case "environmentAccountId":
            return Optional.ofNullable(clazz.cast(environmentAccountId()));
        case "lastAttemptedDeploymentId":
            return Optional.ofNullable(clazz.cast(lastAttemptedDeploymentId()));
        case "lastDeploymentAttemptedAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentAttemptedAt()));
        case "lastDeploymentSucceededAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentSucceededAt()));
        case "lastSucceededDeploymentId":
            return Optional.ofNullable(clazz.cast(lastSucceededDeploymentId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protonServiceRoleArn":
            return Optional.ofNullable(clazz.cast(protonServiceRoleArn()));
        case "provisioning":
            return Optional.ofNullable(clazz.cast(provisioningAsString()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("componentRoleArn", COMPONENT_ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("deploymentStatusMessage", DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentAccountConnectionId", ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD);
        map.put("environmentAccountId", ENVIRONMENT_ACCOUNT_ID_FIELD);
        map.put("lastAttemptedDeploymentId", LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD);
        map.put("lastDeploymentAttemptedAt", LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD);
        map.put("lastDeploymentSucceededAt", LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD);
        map.put("lastSucceededDeploymentId", LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protonServiceRoleArn", PROTON_SERVICE_ROLE_ARN_FIELD);
        map.put("provisioning", PROVISIONING_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
         * components in this environment. It determines the scope of infrastructure that a component can provision.
         * </p>
         * <p>
         * The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
         * associated with the environment.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
         *        defined components in this environment. It determines the scope of infrastructure that a component can
         *        provision.</p>
         *        <p>
         *        The environment must have a <code>componentRoleArn</code> to allow directly defined components to be
         *        associated with the environment.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * The time when the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The environment deployment status.
         * </p>
         * 
         * @param deploymentStatus
         *        The environment deployment status.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The environment deployment status.
         * </p>
         * 
         * @param deploymentStatus
         *        The environment deployment status.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * An environment deployment status message.
         * </p>
         * 
         * @param deploymentStatusMessage
         *        An environment deployment status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessage(String deploymentStatusMessage);

        /**
         * <p>
         * The description of the environment.
         * </p>
         * 
         * @param description
         *        The description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the environment account connection that the environment is associated with.
         * </p>
         * 
         * @param environmentAccountConnectionId
         *        The ID of the environment account connection that the environment is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountConnectionId(String environmentAccountConnectionId);

        /**
         * <p>
         * The ID of the environment account that the environment infrastructure resources are provisioned in.
         * </p>
         * 
         * @param environmentAccountId
         *        The ID of the environment account that the environment infrastructure resources are provisioned in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountId(String environmentAccountId);

        /**
         * <p>
         * The ID of the last attempted deployment of this environment.
         * </p>
         * 
         * @param lastAttemptedDeploymentId
         *        The ID of the last attempted deployment of this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId);

        /**
         * <p>
         * The time when a deployment of the environment was last attempted.
         * </p>
         * 
         * @param lastDeploymentAttemptedAt
         *        The time when a deployment of the environment was last attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt);

        /**
         * <p>
         * The time when the environment was last deployed successfully.
         * </p>
         * 
         * @param lastDeploymentSucceededAt
         *        The time when the environment was last deployed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt);

        /**
         * <p>
         * The ID of the last successful deployment of this environment.
         * </p>
         * 
         * @param lastSucceededDeploymentId
         *        The ID of the last successful deployment of this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSucceededDeploymentId(String lastSucceededDeploymentId);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services
         * on your behalf.
         * </p>
         * 
         * @param protonServiceRoleArn
         *        The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other
         *        services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protonServiceRoleArn(String protonServiceRoleArn);

        /**
         * <p>
         * When included, indicates that the environment template is for customer provisioned and managed
         * infrastructure.
         * </p>
         * 
         * @param provisioning
         *        When included, indicates that the environment template is for customer provisioned and managed
         *        infrastructure.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder provisioning(String provisioning);

        /**
         * <p>
         * When included, indicates that the environment template is for customer provisioned and managed
         * infrastructure.
         * </p>
         * 
         * @param provisioning
         *        When included, indicates that the environment template is for customer provisioned and managed
         *        infrastructure.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder provisioning(Provisioning provisioning);

        /**
         * <p>
         * The major version of the environment template.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the environment template.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        /**
         * <p>
         * The name of the environment template.
         * </p>
         * 
         * @param templateName
         *        The name of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String componentRoleArn;

        private Instant createdAt;

        private String deploymentStatus;

        private String deploymentStatusMessage;

        private String description;

        private String environmentAccountConnectionId;

        private String environmentAccountId;

        private String lastAttemptedDeploymentId;

        private Instant lastDeploymentAttemptedAt;

        private Instant lastDeploymentSucceededAt;

        private String lastSucceededDeploymentId;

        private String name;

        private String protonServiceRoleArn;

        private String provisioning;

        private String templateMajorVersion;

        private String templateMinorVersion;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            arn(model.arn);
            componentRoleArn(model.componentRoleArn);
            createdAt(model.createdAt);
            deploymentStatus(model.deploymentStatus);
            deploymentStatusMessage(model.deploymentStatusMessage);
            description(model.description);
            environmentAccountConnectionId(model.environmentAccountConnectionId);
            environmentAccountId(model.environmentAccountId);
            lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            lastDeploymentAttemptedAt(model.lastDeploymentAttemptedAt);
            lastDeploymentSucceededAt(model.lastDeploymentSucceededAt);
            lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            name(model.name);
            protonServiceRoleArn(model.protonServiceRoleArn);
            provisioning(model.provisioning);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
            templateName(model.templateName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentAccountConnectionId() {
            return environmentAccountConnectionId;
        }

        public final void setEnvironmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
        }

        @Override
        public final Builder environmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
            return this;
        }

        public final String getEnvironmentAccountId() {
            return environmentAccountId;
        }

        public final void setEnvironmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
        }

        @Override
        public final Builder environmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastDeploymentAttemptedAt() {
            return lastDeploymentAttemptedAt;
        }

        public final void setLastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
        }

        @Override
        public final Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
            return this;
        }

        public final Instant getLastDeploymentSucceededAt() {
            return lastDeploymentSucceededAt;
        }

        public final void setLastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
        }

        @Override
        public final Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtonServiceRoleArn() {
            return protonServiceRoleArn;
        }

        public final void setProtonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
        }

        @Override
        public final Builder protonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
            return this;
        }

        public final String getProvisioning() {
            return provisioning;
        }

        public final void setProvisioning(String provisioning) {
            this.provisioning = provisioning;
        }

        @Override
        public final Builder provisioning(String provisioning) {
            this.provisioning = provisioning;
            return this;
        }

        @Override
        public final Builder provisioning(Provisioning provisioning) {
            this.provisioning(provisioning == null ? null : provisioning.toString());
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
