/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The environment template data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentTemplateSummary.Builder, EnvironmentTemplateSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnvironmentTemplateSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EnvironmentTemplateSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentTemplateSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(EnvironmentTemplateSummary::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(EnvironmentTemplateSummary::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentTemplateSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVISIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioning").getter(getter(EnvironmentTemplateSummary::provisioningAsString))
            .setter(setter(Builder::provisioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioning").build()).build();

    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedVersion").getter(getter(EnvironmentTemplateSummary::recommendedVersion))
            .setter(setter(Builder::recommendedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, PROVISIONING_FIELD,
            RECOMMENDED_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String displayName;

    private final Instant lastModifiedAt;

    private final String name;

    private final String provisioning;

    private final String recommendedVersion;

    private EnvironmentTemplateSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.provisioning = builder.provisioning;
        this.recommendedVersion = builder.recommendedVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the environment template was created.
     * </p>
     * 
     * @return The time when the environment template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the environment template.
     * </p>
     * 
     * @return A description of the environment template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the environment template as displayed in the developer interface.
     * </p>
     * 
     * @return The name of the environment template as displayed in the developer interface.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The time when the environment template was last modified.
     * </p>
     * 
     * @return The time when the environment template was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The name of the environment template.
     * </p>
     * 
     * @return The name of the environment template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioning} will
     * return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #provisioningAsString}.
     * </p>
     * 
     * @return When included, indicates that the environment template is for customer provisioned and managed
     *         infrastructure.
     * @see Provisioning
     */
    public final Provisioning provisioning() {
        return Provisioning.fromValue(provisioning);
    }

    /**
     * <p>
     * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioning} will
     * return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #provisioningAsString}.
     * </p>
     * 
     * @return When included, indicates that the environment template is for customer provisioned and managed
     *         infrastructure.
     * @see Provisioning
     */
    public final String provisioningAsString() {
        return provisioning;
    }

    /**
     * <p>
     * The recommended version of the environment template.
     * </p>
     * 
     * @return The recommended version of the environment template.
     */
    public final String recommendedVersion() {
        return recommendedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentTemplateSummary)) {
            return false;
        }
        EnvironmentTemplateSummary other = (EnvironmentTemplateSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(provisioningAsString(), other.provisioningAsString())
                && Objects.equals(recommendedVersion(), other.recommendedVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentTemplateSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastModifiedAt", lastModifiedAt()).add("Name", name()).add("Provisioning", provisioningAsString())
                .add("RecommendedVersion", recommendedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provisioning":
            return Optional.ofNullable(clazz.cast(provisioningAsString()));
        case "recommendedVersion":
            return Optional.ofNullable(clazz.cast(recommendedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provisioning", PROVISIONING_FIELD);
        map.put("recommendedVersion", RECOMMENDED_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentTemplateSummary, T> g) {
        return obj -> g.apply((EnvironmentTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentTemplateSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the environment template was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the environment template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the environment template.
         * </p>
         * 
         * @param description
         *        A description of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the environment template as displayed in the developer interface.
         * </p>
         * 
         * @param displayName
         *        The name of the environment template as displayed in the developer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The time when the environment template was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the environment template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The name of the environment template.
         * </p>
         * 
         * @param name
         *        The name of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When included, indicates that the environment template is for customer provisioned and managed
         * infrastructure.
         * </p>
         * 
         * @param provisioning
         *        When included, indicates that the environment template is for customer provisioned and managed
         *        infrastructure.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder provisioning(String provisioning);

        /**
         * <p>
         * When included, indicates that the environment template is for customer provisioned and managed
         * infrastructure.
         * </p>
         * 
         * @param provisioning
         *        When included, indicates that the environment template is for customer provisioned and managed
         *        infrastructure.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder provisioning(Provisioning provisioning);

        /**
         * <p>
         * The recommended version of the environment template.
         * </p>
         * 
         * @param recommendedVersion
         *        The recommended version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedVersion(String recommendedVersion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String displayName;

        private Instant lastModifiedAt;

        private String name;

        private String provisioning;

        private String recommendedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentTemplateSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            displayName(model.displayName);
            lastModifiedAt(model.lastModifiedAt);
            name(model.name);
            provisioning(model.provisioning);
            recommendedVersion(model.recommendedVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioning() {
            return provisioning;
        }

        public final void setProvisioning(String provisioning) {
            this.provisioning = provisioning;
        }

        @Override
        public final Builder provisioning(String provisioning) {
            this.provisioning = provisioning;
            return this;
        }

        @Override
        public final Builder provisioning(Provisioning provisioning) {
            this.provisioning(provisioning == null ? null : provisioning.toString());
            return this;
        }

        public final String getRecommendedVersion() {
            return recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        @Override
        public EnvironmentTemplateSummary build() {
            return new EnvironmentTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
