/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentTemplatesResponse extends ProtonResponse implements
        ToCopyableBuilder<ListEnvironmentTemplatesResponse.Builder, ListEnvironmentTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<EnvironmentTemplateSummary>> TEMPLATES_FIELD = SdkField
            .<List<EnvironmentTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("templates")
            .getter(getter(ListEnvironmentTemplatesResponse::templates))
            .setter(setter(Builder::templates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEMPLATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EnvironmentTemplateSummary> templates;

    private ListEnvironmentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templates = builder.templates;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment template in the array of environment templates, after
     * the current requested list of environment templates.
     * </p>
     * 
     * @return A token that indicates the location of the next environment template in the array of environment
     *         templates, after the current requested list of environment templates.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Templates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTemplates() {
        return templates != null && !(templates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of environment templates with detail data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplates} method.
     * </p>
     * 
     * @return An array of environment templates with detail data.
     */
    public final List<EnvironmentTemplateSummary> templates() {
        return templates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplates() ? templates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentTemplatesResponse)) {
            return false;
        }
        ListEnvironmentTemplatesResponse other = (ListEnvironmentTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTemplates() == other.hasTemplates()
                && Objects.equals(templates(), other.templates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentTemplatesResponse").add("NextToken", nextToken())
                .add("Templates", hasTemplates() ? templates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "templates":
            return Optional.ofNullable(clazz.cast(templates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("templates", TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentTemplatesResponse, T> g) {
        return obj -> g.apply((ListEnvironmentTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentTemplatesResponse> {
        /**
         * <p>
         * A token that indicates the location of the next environment template in the array of environment templates,
         * after the current requested list of environment templates.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next environment template in the array of environment
         *        templates, after the current requested list of environment templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of environment templates with detail data.
         * </p>
         * 
         * @param templates
         *        An array of environment templates with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templates(Collection<EnvironmentTemplateSummary> templates);

        /**
         * <p>
         * An array of environment templates with detail data.
         * </p>
         * 
         * @param templates
         *        An array of environment templates with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templates(EnvironmentTemplateSummary... templates);

        /**
         * <p>
         * An array of environment templates with detail data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #templates(List<EnvironmentTemplateSummary>)}.
         * 
         * @param templates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templates(java.util.Collection<EnvironmentTemplateSummary>)
         */
        Builder templates(Consumer<EnvironmentTemplateSummary.Builder>... templates);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EnvironmentTemplateSummary> templates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            templates(model.templates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EnvironmentTemplateSummary.Builder> getTemplates() {
            List<EnvironmentTemplateSummary.Builder> result = EnvironmentTemplateSummaryListCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<EnvironmentTemplateSummary.BuilderImpl> templates) {
            this.templates = EnvironmentTemplateSummaryListCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<EnvironmentTemplateSummary> templates) {
            this.templates = EnvironmentTemplateSummaryListCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(EnvironmentTemplateSummary... templates) {
            templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<EnvironmentTemplateSummary.Builder>... templates) {
            templates(Stream.of(templates).map(c -> EnvironmentTemplateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentTemplatesResponse build() {
            return new ListEnvironmentTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
