/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary counts of each Proton resource types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCountsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCountsSummary.Builder, ResourceCountsSummary> {
    private static final SdkField<Integer> BEHIND_MAJOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("behindMajor").getter(getter(ResourceCountsSummary::behindMajor)).setter(setter(Builder::behindMajor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behindMajor").build()).build();

    private static final SdkField<Integer> BEHIND_MINOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("behindMinor").getter(getter(ResourceCountsSummary::behindMinor)).setter(setter(Builder::behindMinor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behindMinor").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(ResourceCountsSummary::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(ResourceCountsSummary::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Integer> UP_TO_DATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("upToDate").getter(getter(ResourceCountsSummary::upToDate)).setter(setter(Builder::upToDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upToDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHIND_MAJOR_FIELD,
            BEHIND_MINOR_FIELD, FAILED_FIELD, TOTAL_FIELD, UP_TO_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer behindMajor;

    private final Integer behindMinor;

    private final Integer failed;

    private final Integer total;

    private final Integer upToDate;

    private ResourceCountsSummary(BuilderImpl builder) {
        this.behindMajor = builder.behindMajor;
        this.behindMinor = builder.behindMinor;
        this.failed = builder.failed;
        this.total = builder.total;
        this.upToDate = builder.upToDate;
    }

    /**
     * <p>
     * The number of resources of this type in the Amazon Web Services account that need a major template version
     * update.
     * </p>
     * 
     * @return The number of resources of this type in the Amazon Web Services account that need a major template
     *         version update.
     */
    public final Integer behindMajor() {
        return behindMajor;
    }

    /**
     * <p>
     * The number of resources of this type in the Amazon Web Services account that need a minor template version
     * update.
     * </p>
     * 
     * @return The number of resources of this type in the Amazon Web Services account that need a minor template
     *         version update.
     */
    public final Integer behindMinor() {
        return behindMinor;
    }

    /**
     * <p>
     * The number of resources of this type in the Amazon Web Services account that failed to deploy.
     * </p>
     * 
     * @return The number of resources of this type in the Amazon Web Services account that failed to deploy.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The total number of resources of this type in the Amazon Web Services account.
     * </p>
     * 
     * @return The total number of resources of this type in the Amazon Web Services account.
     */
    public final Integer total() {
        return total;
    }

    /**
     * <p>
     * The number of resources of this type in the Amazon Web Services account that are up-to-date with their template.
     * </p>
     * 
     * @return The number of resources of this type in the Amazon Web Services account that are up-to-date with their
     *         template.
     */
    public final Integer upToDate() {
        return upToDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(behindMajor());
        hashCode = 31 * hashCode + Objects.hashCode(behindMinor());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(upToDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCountsSummary)) {
            return false;
        }
        ResourceCountsSummary other = (ResourceCountsSummary) obj;
        return Objects.equals(behindMajor(), other.behindMajor()) && Objects.equals(behindMinor(), other.behindMinor())
                && Objects.equals(failed(), other.failed()) && Objects.equals(total(), other.total())
                && Objects.equals(upToDate(), other.upToDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCountsSummary").add("BehindMajor", behindMajor()).add("BehindMinor", behindMinor())
                .add("Failed", failed()).add("Total", total()).add("UpToDate", upToDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "behindMajor":
            return Optional.ofNullable(clazz.cast(behindMajor()));
        case "behindMinor":
            return Optional.ofNullable(clazz.cast(behindMinor()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "upToDate":
            return Optional.ofNullable(clazz.cast(upToDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("behindMajor", BEHIND_MAJOR_FIELD);
        map.put("behindMinor", BEHIND_MINOR_FIELD);
        map.put("failed", FAILED_FIELD);
        map.put("total", TOTAL_FIELD);
        map.put("upToDate", UP_TO_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceCountsSummary, T> g) {
        return obj -> g.apply((ResourceCountsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCountsSummary> {
        /**
         * <p>
         * The number of resources of this type in the Amazon Web Services account that need a major template version
         * update.
         * </p>
         * 
         * @param behindMajor
         *        The number of resources of this type in the Amazon Web Services account that need a major template
         *        version update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behindMajor(Integer behindMajor);

        /**
         * <p>
         * The number of resources of this type in the Amazon Web Services account that need a minor template version
         * update.
         * </p>
         * 
         * @param behindMinor
         *        The number of resources of this type in the Amazon Web Services account that need a minor template
         *        version update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behindMinor(Integer behindMinor);

        /**
         * <p>
         * The number of resources of this type in the Amazon Web Services account that failed to deploy.
         * </p>
         * 
         * @param failed
         *        The number of resources of this type in the Amazon Web Services account that failed to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The total number of resources of this type in the Amazon Web Services account.
         * </p>
         * 
         * @param total
         *        The total number of resources of this type in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * The number of resources of this type in the Amazon Web Services account that are up-to-date with their
         * template.
         * </p>
         * 
         * @param upToDate
         *        The number of resources of this type in the Amazon Web Services account that are up-to-date with their
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upToDate(Integer upToDate);
    }

    static final class BuilderImpl implements Builder {
        private Integer behindMajor;

        private Integer behindMinor;

        private Integer failed;

        private Integer total;

        private Integer upToDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCountsSummary model) {
            behindMajor(model.behindMajor);
            behindMinor(model.behindMinor);
            failed(model.failed);
            total(model.total);
            upToDate(model.upToDate);
        }

        public final Integer getBehindMajor() {
            return behindMajor;
        }

        public final void setBehindMajor(Integer behindMajor) {
            this.behindMajor = behindMajor;
        }

        @Override
        public final Builder behindMajor(Integer behindMajor) {
            this.behindMajor = behindMajor;
            return this;
        }

        public final Integer getBehindMinor() {
            return behindMinor;
        }

        public final void setBehindMinor(Integer behindMinor) {
            this.behindMinor = behindMinor;
        }

        @Override
        public final Builder behindMinor(Integer behindMinor) {
            this.behindMinor = behindMinor;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getUpToDate() {
            return upToDate;
        }

        public final void setUpToDate(Integer upToDate) {
            this.upToDate = upToDate;
        }

        @Override
        public final Builder upToDate(Integer upToDate) {
            this.upToDate = upToDate;
            return this;
        }

        @Override
        public ResourceCountsSummary build() {
            return new ResourceCountsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
