/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Revision detail data for a commit and push that activates a sync attempt
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Revision implements SdkPojo, Serializable, ToCopyableBuilder<Revision.Builder, Revision> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("branch")
            .getter(getter(Revision::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final SdkField<String> DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directory").getter(getter(Revision::directory)).setter(setter(Builder::directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directory").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(Revision::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryProvider").getter(getter(Revision::repositoryProviderAsString))
            .setter(setter(Builder::repositoryProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build())
            .build();

    private static final SdkField<String> SHA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sha")
            .getter(getter(Revision::sha)).setter(setter(Builder::sha))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD,
            REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SHA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String directory;

    private final String repositoryName;

    private final String repositoryProvider;

    private final String sha;

    private Revision(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.sha = builder.sha;
    }

    /**
     * <p>
     * The repository branch.
     * </p>
     * 
     * @return The repository branch.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The repository directory changed by a commit and push that activated the sync attempt.
     * </p>
     * 
     * @return The repository directory changed by a commit and push that activated the sync attempt.
     */
    public final String directory() {
        return directory;
    }

    /**
     * <p>
     * The repository name.
     * </p>
     * 
     * @return The repository name.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(repositoryProvider);
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final String repositoryProviderAsString() {
        return repositoryProvider;
    }

    /**
     * <p>
     * The secure hash algorithm (SHA) hash for the revision.
     * </p>
     * 
     * @return The secure hash algorithm (SHA) hash for the revision.
     */
    public final String sha() {
        return sha;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(directory());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sha());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(directory(), other.directory())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryProviderAsString(), other.repositoryProviderAsString())
                && Objects.equals(sha(), other.sha());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Revision").add("Branch", branch()).add("Directory", directory())
                .add("RepositoryName", repositoryName()).add("RepositoryProvider", repositoryProviderAsString())
                .add("Sha", sha()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "directory":
            return Optional.ofNullable(clazz.cast(directory()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryProvider":
            return Optional.ofNullable(clazz.cast(repositoryProviderAsString()));
        case "sha":
            return Optional.ofNullable(clazz.cast(sha()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("branch", BRANCH_FIELD);
        map.put("directory", DIRECTORY_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("repositoryProvider", REPOSITORY_PROVIDER_FIELD);
        map.put("sha", SHA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Revision, T> g) {
        return obj -> g.apply((Revision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Revision> {
        /**
         * <p>
         * The repository branch.
         * </p>
         * 
         * @param branch
         *        The repository branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The repository directory changed by a commit and push that activated the sync attempt.
         * </p>
         * 
         * @param directory
         *        The repository directory changed by a commit and push that activated the sync attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directory(String directory);

        /**
         * <p>
         * The repository name.
         * </p>
         * 
         * @param repositoryName
         *        The repository name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(String repositoryProvider);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(RepositoryProvider repositoryProvider);

        /**
         * <p>
         * The secure hash algorithm (SHA) hash for the revision.
         * </p>
         * 
         * @param sha
         *        The secure hash algorithm (SHA) hash for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha(String sha);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String directory;

        private String repositoryName;

        private String repositoryProvider;

        private String sha;

        private BuilderImpl() {
        }

        private BuilderImpl(Revision model) {
            branch(model.branch);
            directory(model.directory);
            repositoryName(model.repositoryName);
            repositoryProvider(model.repositoryProvider);
            sha(model.sha);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getSha() {
            return sha;
        }

        public final void setSha(String sha) {
            this.sha = sha;
        }

        @Override
        public final Builder sha(String sha) {
            this.sha = sha;
            return this;
        }

        @Override
        public Revision build() {
            return new Revision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
