/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If a service instance is manually updated, Proton wants to prevent accidentally overriding a manual change.
 * </p>
 * <p>
 * A blocker is created because of the manual update or deletion of a service instance. The summary describes the
 * blocker as being active or resolved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSyncBlockerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceSyncBlockerSummary.Builder, ServiceSyncBlockerSummary> {
    private static final SdkField<List<SyncBlocker>> LATEST_BLOCKERS_FIELD = SdkField
            .<List<SyncBlocker>> builder(MarshallingType.LIST)
            .memberName("latestBlockers")
            .getter(getter(ServiceSyncBlockerSummary::latestBlockers))
            .setter(setter(Builder::latestBlockers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestBlockers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyncBlocker> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncBlocker::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(ServiceSyncBlockerSummary::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ServiceSyncBlockerSummary::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_BLOCKERS_FIELD,
            SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SyncBlocker> latestBlockers;

    private final String serviceInstanceName;

    private final String serviceName;

    private ServiceSyncBlockerSummary(BuilderImpl builder) {
        this.latestBlockers = builder.latestBlockers;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LatestBlockers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLatestBlockers() {
        return latestBlockers != null && !(latestBlockers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The latest active blockers for the synced service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLatestBlockers} method.
     * </p>
     * 
     * @return The latest active blockers for the synced service.
     */
    public final List<SyncBlocker> latestBlockers() {
        return latestBlockers;
    }

    /**
     * <p>
     * The name of the service instance that you want sync your service configuration with.
     * </p>
     * 
     * @return The name of the service instance that you want sync your service configuration with.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that you want to get the sync blocker summary for. If given a service instance name and a
     * service name, it will return the blockers only applying to the instance that is blocked.
     * </p>
     * <p>
     * If given only a service name, it will return the blockers that apply to all of the instances. In order to get the
     * blockers for a single instance, you will need to make two distinct calls, one to get the sync blocker summary for
     * the service and the other to get the sync blocker for the service instance.
     * </p>
     * 
     * @return The name of the service that you want to get the sync blocker summary for. If given a service instance
     *         name and a service name, it will return the blockers only applying to the instance that is blocked.</p>
     *         <p>
     *         If given only a service name, it will return the blockers that apply to all of the instances. In order to
     *         get the blockers for a single instance, you will need to make two distinct calls, one to get the sync
     *         blocker summary for the service and the other to get the sync blocker for the service instance.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLatestBlockers() ? latestBlockers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSyncBlockerSummary)) {
            return false;
        }
        ServiceSyncBlockerSummary other = (ServiceSyncBlockerSummary) obj;
        return hasLatestBlockers() == other.hasLatestBlockers() && Objects.equals(latestBlockers(), other.latestBlockers())
                && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSyncBlockerSummary").add("LatestBlockers", hasLatestBlockers() ? latestBlockers() : null)
                .add("ServiceInstanceName", serviceInstanceName()).add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestBlockers":
            return Optional.ofNullable(clazz.cast(latestBlockers()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latestBlockers", LATEST_BLOCKERS_FIELD);
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceSyncBlockerSummary, T> g) {
        return obj -> g.apply((ServiceSyncBlockerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSyncBlockerSummary> {
        /**
         * <p>
         * The latest active blockers for the synced service.
         * </p>
         * 
         * @param latestBlockers
         *        The latest active blockers for the synced service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestBlockers(Collection<SyncBlocker> latestBlockers);

        /**
         * <p>
         * The latest active blockers for the synced service.
         * </p>
         * 
         * @param latestBlockers
         *        The latest active blockers for the synced service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestBlockers(SyncBlocker... latestBlockers);

        /**
         * <p>
         * The latest active blockers for the synced service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.SyncBlocker.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.proton.model.SyncBlocker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.SyncBlocker.Builder#build()} is called immediately and
         * its result is passed to {@link #latestBlockers(List<SyncBlocker>)}.
         * 
         * @param latestBlockers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.SyncBlocker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestBlockers(java.util.Collection<SyncBlocker>)
         */
        Builder latestBlockers(Consumer<SyncBlocker.Builder>... latestBlockers);

        /**
         * <p>
         * The name of the service instance that you want sync your service configuration with.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that you want sync your service configuration with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that you want to get the sync blocker summary for. If given a service instance name
         * and a service name, it will return the blockers only applying to the instance that is blocked.
         * </p>
         * <p>
         * If given only a service name, it will return the blockers that apply to all of the instances. In order to get
         * the blockers for a single instance, you will need to make two distinct calls, one to get the sync blocker
         * summary for the service and the other to get the sync blocker for the service instance.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that you want to get the sync blocker summary for. If given a service instance
         *        name and a service name, it will return the blockers only applying to the instance that is
         *        blocked.</p>
         *        <p>
         *        If given only a service name, it will return the blockers that apply to all of the instances. In order
         *        to get the blockers for a single instance, you will need to make two distinct calls, one to get the
         *        sync blocker summary for the service and the other to get the sync blocker for the service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private List<SyncBlocker> latestBlockers = DefaultSdkAutoConstructList.getInstance();

        private String serviceInstanceName;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSyncBlockerSummary model) {
            latestBlockers(model.latestBlockers);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
        }

        public final List<SyncBlocker.Builder> getLatestBlockers() {
            List<SyncBlocker.Builder> result = LatestSyncBlockersCopier.copyToBuilder(this.latestBlockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestBlockers(Collection<SyncBlocker.BuilderImpl> latestBlockers) {
            this.latestBlockers = LatestSyncBlockersCopier.copyFromBuilder(latestBlockers);
        }

        @Override
        public final Builder latestBlockers(Collection<SyncBlocker> latestBlockers) {
            this.latestBlockers = LatestSyncBlockersCopier.copy(latestBlockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(SyncBlocker... latestBlockers) {
            latestBlockers(Arrays.asList(latestBlockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(Consumer<SyncBlocker.Builder>... latestBlockers) {
            latestBlockers(Stream.of(latestBlockers).map(c -> SyncBlocker.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public ServiceSyncBlockerSummary build() {
            return new ServiceSyncBlockerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
