/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed data of the service sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSyncConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceSyncConfig.Builder, ServiceSyncConfig> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("branch")
            .getter(getter(ServiceSyncConfig::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(ServiceSyncConfig::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ServiceSyncConfig::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryProvider").getter(getter(ServiceSyncConfig::repositoryProviderAsString))
            .setter(setter(Builder::repositoryProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ServiceSyncConfig::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, FILE_PATH_FIELD,
            REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String filePath;

    private final String repositoryName;

    private final String repositoryProvider;

    private final String serviceName;

    private ServiceSyncConfig(BuilderImpl builder) {
        this.branch = builder.branch;
        this.filePath = builder.filePath;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The name of the code repository branch that holds the service code Proton will sync with.
     * </p>
     * 
     * @return The name of the code repository branch that holds the service code Proton will sync with.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The file path to the service sync configuration file.
     * </p>
     * 
     * @return The file path to the service sync configuration file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The name of the code repository that holds the service code Proton will sync with.
     * </p>
     * 
     * @return The name of the code repository that holds the service code Proton will sync with.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the repository provider that holds the repository Proton will sync with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The name of the repository provider that holds the repository Proton will sync with.
     * @see RepositoryProvider
     */
    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(repositoryProvider);
    }

    /**
     * <p>
     * The name of the repository provider that holds the repository Proton will sync with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The name of the repository provider that holds the repository Proton will sync with.
     * @see RepositoryProvider
     */
    public final String repositoryProviderAsString() {
        return repositoryProvider;
    }

    /**
     * <p>
     * The name of the service that the service instance is added to.
     * </p>
     * 
     * @return The name of the service that the service instance is added to.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSyncConfig)) {
            return false;
        }
        ServiceSyncConfig other = (ServiceSyncConfig) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(filePath(), other.filePath())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryProviderAsString(), other.repositoryProviderAsString())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSyncConfig").add("Branch", branch()).add("FilePath", filePath())
                .add("RepositoryName", repositoryName()).add("RepositoryProvider", repositoryProviderAsString())
                .add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryProvider":
            return Optional.ofNullable(clazz.cast(repositoryProviderAsString()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("branch", BRANCH_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("repositoryProvider", REPOSITORY_PROVIDER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceSyncConfig, T> g) {
        return obj -> g.apply((ServiceSyncConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSyncConfig> {
        /**
         * <p>
         * The name of the code repository branch that holds the service code Proton will sync with.
         * </p>
         * 
         * @param branch
         *        The name of the code repository branch that holds the service code Proton will sync with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The file path to the service sync configuration file.
         * </p>
         * 
         * @param filePath
         *        The file path to the service sync configuration file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The name of the code repository that holds the service code Proton will sync with.
         * </p>
         * 
         * @param repositoryName
         *        The name of the code repository that holds the service code Proton will sync with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the repository provider that holds the repository Proton will sync with.
         * </p>
         * 
         * @param repositoryProvider
         *        The name of the repository provider that holds the repository Proton will sync with.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(String repositoryProvider);

        /**
         * <p>
         * The name of the repository provider that holds the repository Proton will sync with.
         * </p>
         * 
         * @param repositoryProvider
         *        The name of the repository provider that holds the repository Proton will sync with.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(RepositoryProvider repositoryProvider);

        /**
         * <p>
         * The name of the service that the service instance is added to.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that the service instance is added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String filePath;

        private String repositoryName;

        private String repositoryProvider;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSyncConfig model) {
            branch(model.branch);
            filePath(model.filePath);
            repositoryName(model.repositoryName);
            repositoryProvider(model.repositoryProvider);
            serviceName(model.serviceName);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public ServiceSyncConfig build() {
            return new ServiceSyncConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
