/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServicePipelineRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateServicePipelineRequest.Builder, UpdateServicePipelineRequest> {
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(UpdateServicePipelineRequest::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(UpdateServicePipelineRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(UpdateServicePipelineRequest::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(UpdateServicePipelineRequest::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(UpdateServicePipelineRequest::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TYPE_FIELD,
            SERVICE_NAME_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deploymentType;

    private final String serviceName;

    private final String spec;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private UpdateServicePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentType = builder.deploymentType;
        this.serviceName = builder.serviceName;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
    }

    /**
     * <p>
     * The deployment type.
     * </p>
     * <p>
     * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version
     * of the current major version in use, by default. You can specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
     * minor version of the current template, by default. You can specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type.</p>
     *         <p>
     *         There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the
     *         mode.
     *         </p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only
     *         requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
     *         this <code>deployment-type</code>.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MINOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor
     *         version of the current major version in use, by default. You can specify a different minor version of the
     *         current major version in use.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MAJOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major
     *         and minor version of the current template, by default. You can specify a different major version that's
     *         higher than the major version in use and a minor version.
     *         </p>
     *         </dd>
     * @see DeploymentUpdateType
     */
    public final DeploymentUpdateType deploymentType() {
        return DeploymentUpdateType.fromValue(deploymentType);
    }

    /**
     * <p>
     * The deployment type.
     * </p>
     * <p>
     * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version
     * of the current major version in use, by default. You can specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
     * minor version of the current template, by default. You can specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type.</p>
     *         <p>
     *         There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the
     *         mode.
     *         </p>
     *         <dl>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <p>
     *         In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>CURRENT_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only
     *         requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
     *         this <code>deployment-type</code>.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MINOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor
     *         version of the current major version in use, by default. You can specify a different minor version of the
     *         current major version in use.
     *         </p>
     *         </dd>
     *         <dt/>
     *         <dd>
     *         <p>
     *         <code>MAJOR_VERSION</code>
     *         </p>
     *         <p>
     *         In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major
     *         and minor version of the current template, by default. You can specify a different major version that's
     *         higher than the major version in use and a minor version.
     *         </p>
     *         </dd>
     * @see DeploymentUpdateType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * The name of the service to that the pipeline is associated with.
     * </p>
     * 
     * @return The name of the service to that the pipeline is associated with.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The spec for the service pipeline to update.
     * </p>
     * 
     * @return The spec for the service pipeline to update.
     */
    public final String spec() {
        return spec;
    }

    /**
     * <p>
     * The major version of the service template that was used to create the service that the pipeline is associated
     * with.
     * </p>
     * 
     * @return The major version of the service template that was used to create the service that the pipeline is
     *         associated with.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the service template that was used to create the service that the pipeline is associated
     * with.
     * </p>
     * 
     * @return The minor version of the service template that was used to create the service that the pipeline is
     *         associated with.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServicePipelineRequest)) {
            return false;
        }
        UpdateServicePipelineRequest other = (UpdateServicePipelineRequest) obj;
        return Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(spec(), other.spec())
                && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServicePipelineRequest").add("DeploymentType", deploymentTypeAsString())
                .add("ServiceName", serviceName()).add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServicePipelineRequest, T> g) {
        return obj -> g.apply((UpdateServicePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServicePipelineRequest> {
        /**
         * <p>
         * The deployment type.
         * </p>
         * <p>
         * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
         * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
         * <code>deployment-type</code>.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MINOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor
         * version of the current major version in use, by default. You can specify a different minor version of the
         * current major version in use.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MAJOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
         * minor version of the current template, by default. You can specify a different major version that's higher
         * than the major version in use and a minor version.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        The deployment type.</p>
         *        <p>
         *        There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines
         *        the mode.
         *        </p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only
         *        requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
         *        this <code>deployment-type</code>.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MINOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the published, recommended (latest)
         *        minor version of the current major version in use, by default. You can specify a different minor
         *        version of the current major version in use.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MAJOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the published, recommended (latest)
         *        major and minor version of the current template, by default. You can specify a different major version
         *        that's higher than the major version in use and a minor version.
         *        </p>
         *        </dd>
         * @see DeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentUpdateType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * The deployment type.
         * </p>
         * <p>
         * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
         * </p>
         * <dl>
         * <dt/>
         * <dd>
         * <p>
         * <code>NONE</code>
         * </p>
         * <p>
         * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>CURRENT_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
         * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
         * <code>deployment-type</code>.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MINOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor
         * version of the current major version in use, by default. You can specify a different minor version of the
         * current major version in use.
         * </p>
         * </dd>
         * <dt/>
         * <dd>
         * <p>
         * <code>MAJOR_VERSION</code>
         * </p>
         * <p>
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
         * minor version of the current template, by default. You can specify a different major version that's higher
         * than the major version in use and a minor version.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param deploymentType
         *        The deployment type.</p>
         *        <p>
         *        There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines
         *        the mode.
         *        </p>
         *        <dl>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <p>
         *        In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>CURRENT_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only
         *        requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use
         *        this <code>deployment-type</code>.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MINOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the published, recommended (latest)
         *        minor version of the current major version in use, by default. You can specify a different minor
         *        version of the current major version in use.
         *        </p>
         *        </dd>
         *        <dt/>
         *        <dd>
         *        <p>
         *        <code>MAJOR_VERSION</code>
         *        </p>
         *        <p>
         *        In this mode, the service pipeline is deployed and updated with the published, recommended (latest)
         *        major and minor version of the current template, by default. You can specify a different major version
         *        that's higher than the major version in use and a minor version.
         *        </p>
         *        </dd>
         * @see DeploymentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentUpdateType
         */
        Builder deploymentType(DeploymentUpdateType deploymentType);

        /**
         * <p>
         * The name of the service to that the pipeline is associated with.
         * </p>
         * 
         * @param serviceName
         *        The name of the service to that the pipeline is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The spec for the service pipeline to update.
         * </p>
         * 
         * @param spec
         *        The spec for the service pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * The major version of the service template that was used to create the service that the pipeline is associated
         * with.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the service template that was used to create the service that the pipeline is
         *        associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the service template that was used to create the service that the pipeline is associated
         * with.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the service template that was used to create the service that the pipeline is
         *        associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String deploymentType;

        private String serviceName;

        private String spec;

        private String templateMajorVersion;

        private String templateMinorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServicePipelineRequest model) {
            super(model);
            deploymentType(model.deploymentType);
            serviceName(model.serviceName);
            spec(model.spec);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentUpdateType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServicePipelineRequest build() {
            return new UpdateServicePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
