/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSyncBlockerRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateServiceSyncBlockerRequest.Builder, UpdateServiceSyncBlockerRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateServiceSyncBlockerRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolvedReason").getter(getter(UpdateServiceSyncBlockerRequest::resolvedReason))
            .setter(setter(Builder::resolvedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RESOLVED_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String resolvedReason;

    private UpdateServiceSyncBlockerRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.resolvedReason = builder.resolvedReason;
    }

    /**
     * <p>
     * The ID of the service sync blocker.
     * </p>
     * 
     * @return The ID of the service sync blocker.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The reason the service sync blocker was resolved.
     * </p>
     * 
     * @return The reason the service sync blocker was resolved.
     */
    public final String resolvedReason() {
        return resolvedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSyncBlockerRequest)) {
            return false;
        }
        UpdateServiceSyncBlockerRequest other = (UpdateServiceSyncBlockerRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resolvedReason(), other.resolvedReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSyncBlockerRequest").add("Id", id()).add("ResolvedReason", resolvedReason())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resolvedReason":
            return Optional.ofNullable(clazz.cast(resolvedReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("resolvedReason", RESOLVED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSyncBlockerRequest, T> g) {
        return obj -> g.apply((UpdateServiceSyncBlockerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceSyncBlockerRequest> {
        /**
         * <p>
         * The ID of the service sync blocker.
         * </p>
         * 
         * @param id
         *        The ID of the service sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The reason the service sync blocker was resolved.
         * </p>
         * 
         * @param resolvedReason
         *        The reason the service sync blocker was resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedReason(String resolvedReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String id;

        private String resolvedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSyncBlockerRequest model) {
            super(model);
            id(model.id);
            resolvedReason(model.resolvedReason);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResolvedReason() {
            return resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSyncBlockerRequest build() {
            return new UpdateServiceSyncBlockerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
