/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceTemplateResponse extends ProtonResponse implements
        ToCopyableBuilder<UpdateServiceTemplateResponse.Builder, UpdateServiceTemplateResponse> {
    private static final SdkField<ServiceTemplate> SERVICE_TEMPLATE_FIELD = SdkField
            .<ServiceTemplate> builder(MarshallingType.SDK_POJO).memberName("serviceTemplate")
            .getter(getter(UpdateServiceTemplateResponse::serviceTemplate)).setter(setter(Builder::serviceTemplate))
            .constructor(ServiceTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceTemplate serviceTemplate;

    private UpdateServiceTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceTemplate = builder.serviceTemplate;
    }

    /**
     * <p>
     * The service template detail data that's returned by Proton.
     * </p>
     * 
     * @return The service template detail data that's returned by Proton.
     */
    public final ServiceTemplate serviceTemplate() {
        return serviceTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceTemplateResponse)) {
            return false;
        }
        UpdateServiceTemplateResponse other = (UpdateServiceTemplateResponse) obj;
        return Objects.equals(serviceTemplate(), other.serviceTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceTemplateResponse").add("ServiceTemplate", serviceTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceTemplate":
            return Optional.ofNullable(clazz.cast(serviceTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceTemplate", SERVICE_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceTemplateResponse, T> g) {
        return obj -> g.apply((UpdateServiceTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceTemplateResponse> {
        /**
         * <p>
         * The service template detail data that's returned by Proton.
         * </p>
         * 
         * @param serviceTemplate
         *        The service template detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTemplate(ServiceTemplate serviceTemplate);

        /**
         * <p>
         * The service template detail data that's returned by Proton.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceTemplate.Builder} avoiding the
         * need to create one manually via {@link ServiceTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceTemplate(ServiceTemplate)}.
         * 
         * @param serviceTemplate
         *        a consumer that will call methods on {@link ServiceTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceTemplate(ServiceTemplate)
         */
        default Builder serviceTemplate(Consumer<ServiceTemplate.Builder> serviceTemplate) {
            return serviceTemplate(ServiceTemplate.builder().applyMutation(serviceTemplate).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private ServiceTemplate serviceTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceTemplateResponse model) {
            super(model);
            serviceTemplate(model.serviceTemplate);
        }

        public final ServiceTemplate.Builder getServiceTemplate() {
            return serviceTemplate != null ? serviceTemplate.toBuilder() : null;
        }

        public final void setServiceTemplate(ServiceTemplate.BuilderImpl serviceTemplate) {
            this.serviceTemplate = serviceTemplate != null ? serviceTemplate.build() : null;
        }

        @Override
        public final Builder serviceTemplate(ServiceTemplate serviceTemplate) {
            this.serviceTemplate = serviceTemplate;
            return this;
        }

        @Override
        public UpdateServiceTemplateResponse build() {
            return new UpdateServiceTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
