/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.DeploymentStatus;
import software.amazon.awssdk.services.proton.model.Provisioning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnvironmentSummary.getter(EnvironmentSummary::arn)).setter(EnvironmentSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentRoleArn").getter(EnvironmentSummary.getter(EnvironmentSummary::componentRoleArn)).setter(EnvironmentSummary.setter(Builder::componentRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentSummary.getter(EnvironmentSummary::createdAt)).setter(EnvironmentSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(EnvironmentSummary.getter(EnvironmentSummary::deploymentStatusAsString)).setter(EnvironmentSummary.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatusMessage").getter(EnvironmentSummary.getter(EnvironmentSummary::deploymentStatusMessage)).setter(EnvironmentSummary.setter(Builder::deploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnvironmentSummary.getter(EnvironmentSummary::description)).setter(EnvironmentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentAccountConnectionId").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentAccountConnectionId)).setter(EnvironmentSummary.setter(Builder::environmentAccountConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnectionId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentAccountId").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentAccountId)).setter(EnvironmentSummary.setter(Builder::environmentAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountId").build()}).build();
    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastAttemptedDeploymentId").getter(EnvironmentSummary.getter(EnvironmentSummary::lastAttemptedDeploymentId)).setter(EnvironmentSummary.setter(Builder::lastAttemptedDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentAttemptedAt").getter(EnvironmentSummary.getter(EnvironmentSummary::lastDeploymentAttemptedAt)).setter(EnvironmentSummary.setter(Builder::lastDeploymentAttemptedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentAttemptedAt").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentSucceededAt").getter(EnvironmentSummary.getter(EnvironmentSummary::lastDeploymentSucceededAt)).setter(EnvironmentSummary.setter(Builder::lastDeploymentSucceededAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentSucceededAt").build()}).build();
    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSucceededDeploymentId").getter(EnvironmentSummary.getter(EnvironmentSummary::lastSucceededDeploymentId)).setter(EnvironmentSummary.setter(Builder::lastSucceededDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EnvironmentSummary.getter(EnvironmentSummary::name)).setter(EnvironmentSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTON_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protonServiceRoleArn").getter(EnvironmentSummary.getter(EnvironmentSummary::protonServiceRoleArn)).setter(EnvironmentSummary.setter(Builder::protonServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protonServiceRoleArn").build()}).build();
    private static final SdkField<String> PROVISIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioning").getter(EnvironmentSummary.getter(EnvironmentSummary::provisioningAsString)).setter(EnvironmentSummary.setter(Builder::provisioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioning").build()}).build();
    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMajorVersion").getter(EnvironmentSummary.getter(EnvironmentSummary::templateMajorVersion)).setter(EnvironmentSummary.setter(Builder::templateMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMinorVersion").getter(EnvironmentSummary.getter(EnvironmentSummary::templateMinorVersion)).setter(EnvironmentSummary.setter(Builder::templateMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(EnvironmentSummary.getter(EnvironmentSummary::templateName)).setter(EnvironmentSummary.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_ROLE_ARN_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD, ENVIRONMENT_ACCOUNT_ID_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD, LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD, LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, NAME_FIELD, PROTON_SERVICE_ROLE_ARN_FIELD, PROVISIONING_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String componentRoleArn;
    private final Instant createdAt;
    private final String deploymentStatus;
    private final String deploymentStatusMessage;
    private final String description;
    private final String environmentAccountConnectionId;
    private final String environmentAccountId;
    private final String lastAttemptedDeploymentId;
    private final Instant lastDeploymentAttemptedAt;
    private final Instant lastDeploymentSucceededAt;
    private final String lastSucceededDeploymentId;
    private final String name;
    private final String protonServiceRoleArn;
    private final String provisioning;
    private final String templateMajorVersion;
    private final String templateMinorVersion;
    private final String templateName;

    private EnvironmentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentRoleArn = builder.componentRoleArn;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.description = builder.description;
        this.environmentAccountConnectionId = builder.environmentAccountConnectionId;
        this.environmentAccountId = builder.environmentAccountId;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastDeploymentAttemptedAt = builder.lastDeploymentAttemptedAt;
        this.lastDeploymentSucceededAt = builder.lastDeploymentSucceededAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.name = builder.name;
        this.protonServiceRoleArn = builder.protonServiceRoleArn;
        this.provisioning = builder.provisioning;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentRoleArn() {
        return this.componentRoleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String deploymentStatusMessage() {
        return this.deploymentStatusMessage;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentAccountConnectionId() {
        return this.environmentAccountConnectionId;
    }

    public final String environmentAccountId() {
        return this.environmentAccountId;
    }

    public final String lastAttemptedDeploymentId() {
        return this.lastAttemptedDeploymentId;
    }

    public final Instant lastDeploymentAttemptedAt() {
        return this.lastDeploymentAttemptedAt;
    }

    public final Instant lastDeploymentSucceededAt() {
        return this.lastDeploymentSucceededAt;
    }

    public final String lastSucceededDeploymentId() {
        return this.lastSucceededDeploymentId;
    }

    public final String name() {
        return this.name;
    }

    public final String protonServiceRoleArn() {
        return this.protonServiceRoleArn;
    }

    public final Provisioning provisioning() {
        return Provisioning.fromValue(this.provisioning);
    }

    public final String provisioningAsString() {
        return this.provisioning;
    }

    public final String templateMajorVersion() {
        return this.templateMajorVersion;
    }

    public final String templateMinorVersion() {
        return this.templateMinorVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAccountConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentAttemptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentSucceededAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protonServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentRoleArn(), other.componentRoleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentStatusMessage(), other.deploymentStatusMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentAccountConnectionId(), other.environmentAccountConnectionId()) && Objects.equals(this.environmentAccountId(), other.environmentAccountId()) && Objects.equals(this.lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId()) && Objects.equals(this.lastDeploymentAttemptedAt(), other.lastDeploymentAttemptedAt()) && Objects.equals(this.lastDeploymentSucceededAt(), other.lastDeploymentSucceededAt()) && Objects.equals(this.lastSucceededDeploymentId(), other.lastSucceededDeploymentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protonServiceRoleArn(), other.protonServiceRoleArn()) && Objects.equals(this.provisioningAsString(), other.provisioningAsString()) && Objects.equals(this.templateMajorVersion(), other.templateMajorVersion()) && Objects.equals(this.templateMinorVersion(), other.templateMinorVersion()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentSummary").add("Arn", (Object)this.arn()).add("ComponentRoleArn", (Object)this.componentRoleArn()).add("CreatedAt", (Object)this.createdAt()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentStatusMessage", (Object)(this.deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentAccountConnectionId", (Object)this.environmentAccountConnectionId()).add("EnvironmentAccountId", (Object)this.environmentAccountId()).add("LastAttemptedDeploymentId", (Object)this.lastAttemptedDeploymentId()).add("LastDeploymentAttemptedAt", (Object)this.lastDeploymentAttemptedAt()).add("LastDeploymentSucceededAt", (Object)this.lastDeploymentSucceededAt()).add("LastSucceededDeploymentId", (Object)this.lastSucceededDeploymentId()).add("Name", (Object)this.name()).add("ProtonServiceRoleArn", (Object)this.protonServiceRoleArn()).add("Provisioning", (Object)this.provisioningAsString()).add("TemplateMajorVersion", (Object)this.templateMajorVersion()).add("TemplateMinorVersion", (Object)this.templateMinorVersion()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentRoleArn": {
                return Optional.ofNullable(clazz.cast(this.componentRoleArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "deploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentAccountConnectionId": {
                return Optional.ofNullable(clazz.cast(this.environmentAccountConnectionId()));
            }
            case "environmentAccountId": {
                return Optional.ofNullable(clazz.cast(this.environmentAccountId()));
            }
            case "lastAttemptedDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDeploymentId()));
            }
            case "lastDeploymentAttemptedAt": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentAttemptedAt()));
            }
            case "lastDeploymentSucceededAt": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentSucceededAt()));
            }
            case "lastSucceededDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSucceededDeploymentId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "protonServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.protonServiceRoleArn()));
            }
            case "provisioning": {
                return Optional.ofNullable(clazz.cast(this.provisioningAsString()));
            }
            case "templateMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMajorVersion()));
            }
            case "templateMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMinorVersion()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("componentRoleArn", COMPONENT_ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("deploymentStatusMessage", DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentAccountConnectionId", ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD);
        map.put("environmentAccountId", ENVIRONMENT_ACCOUNT_ID_FIELD);
        map.put("lastAttemptedDeploymentId", LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD);
        map.put("lastDeploymentAttemptedAt", LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD);
        map.put("lastDeploymentSucceededAt", LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD);
        map.put("lastSucceededDeploymentId", LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protonServiceRoleArn", PROTON_SERVICE_ROLE_ARN_FIELD);
        map.put("provisioning", PROVISIONING_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String componentRoleArn;
        private Instant createdAt;
        private String deploymentStatus;
        private String deploymentStatusMessage;
        private String description;
        private String environmentAccountConnectionId;
        private String environmentAccountId;
        private String lastAttemptedDeploymentId;
        private Instant lastDeploymentAttemptedAt;
        private Instant lastDeploymentSucceededAt;
        private String lastSucceededDeploymentId;
        private String name;
        private String protonServiceRoleArn;
        private String provisioning;
        private String templateMajorVersion;
        private String templateMinorVersion;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            this.arn(model.arn);
            this.componentRoleArn(model.componentRoleArn);
            this.createdAt(model.createdAt);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentStatusMessage(model.deploymentStatusMessage);
            this.description(model.description);
            this.environmentAccountConnectionId(model.environmentAccountConnectionId);
            this.environmentAccountId(model.environmentAccountId);
            this.lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            this.lastDeploymentAttemptedAt(model.lastDeploymentAttemptedAt);
            this.lastDeploymentSucceededAt(model.lastDeploymentSucceededAt);
            this.lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            this.name(model.name);
            this.protonServiceRoleArn(model.protonServiceRoleArn);
            this.provisioning(model.provisioning);
            this.templateMajorVersion(model.templateMajorVersion);
            this.templateMinorVersion(model.templateMinorVersion);
            this.templateName(model.templateName);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentRoleArn() {
            return this.componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return this.deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentAccountConnectionId() {
            return this.environmentAccountConnectionId;
        }

        public final void setEnvironmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
        }

        @Override
        public final Builder environmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
            return this;
        }

        public final String getEnvironmentAccountId() {
            return this.environmentAccountId;
        }

        public final void setEnvironmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
        }

        @Override
        public final Builder environmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return this.lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastDeploymentAttemptedAt() {
            return this.lastDeploymentAttemptedAt;
        }

        public final void setLastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
        }

        @Override
        public final Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
            return this;
        }

        public final Instant getLastDeploymentSucceededAt() {
            return this.lastDeploymentSucceededAt;
        }

        public final void setLastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
        }

        @Override
        public final Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return this.lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtonServiceRoleArn() {
            return this.protonServiceRoleArn;
        }

        public final void setProtonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
        }

        @Override
        public final Builder protonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
            return this;
        }

        public final String getProvisioning() {
            return this.provisioning;
        }

        public final void setProvisioning(String provisioning) {
            this.provisioning = provisioning;
        }

        @Override
        public final Builder provisioning(String provisioning) {
            this.provisioning = provisioning;
            return this;
        }

        @Override
        public final Builder provisioning(Provisioning provisioning) {
            this.provisioning(provisioning == null ? null : provisioning.toString());
            return this;
        }

        public final String getTemplateMajorVersion() {
            return this.templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return this.templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentSummary> {
        public Builder arn(String var1);

        public Builder componentRoleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentStatusMessage(String var1);

        public Builder description(String var1);

        public Builder environmentAccountConnectionId(String var1);

        public Builder environmentAccountId(String var1);

        public Builder lastAttemptedDeploymentId(String var1);

        public Builder lastDeploymentAttemptedAt(Instant var1);

        public Builder lastDeploymentSucceededAt(Instant var1);

        public Builder lastSucceededDeploymentId(String var1);

        public Builder name(String var1);

        public Builder protonServiceRoleArn(String var1);

        public Builder provisioning(String var1);

        public Builder provisioning(Provisioning var1);

        public Builder templateMajorVersion(String var1);

        public Builder templateMinorVersion(String var1);

        public Builder templateName(String var1);
    }
}

