/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;
import software.amazon.awssdk.services.proton.model.ProvisionedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentProvisionedResourcesResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListEnvironmentProvisionedResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentProvisionedResourcesResponse.getter(ListEnvironmentProvisionedResourcesResponse::nextToken)).setter(ListEnvironmentProvisionedResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ProvisionedResource>> PROVISIONED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("provisionedResources").getter(ListEnvironmentProvisionedResourcesResponse.getter(ListEnvironmentProvisionedResourcesResponse::provisionedResources)).setter(ListEnvironmentProvisionedResourcesResponse.setter(Builder::provisionedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROVISIONED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentProvisionedResourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ProvisionedResource> provisionedResources;

    private ListEnvironmentProvisionedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.provisionedResources = builder.provisionedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProvisionedResources() {
        return this.provisionedResources != null && !(this.provisionedResources instanceof SdkAutoConstructList);
    }

    public final List<ProvisionedResource> provisionedResources() {
        return this.provisionedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedResources() ? this.provisionedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentProvisionedResourcesResponse)) {
            return false;
        }
        ListEnvironmentProvisionedResourcesResponse other = (ListEnvironmentProvisionedResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProvisionedResources() == other.hasProvisionedResources() && Objects.equals(this.provisionedResources(), other.provisionedResources());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentProvisionedResourcesResponse").add("NextToken", (Object)this.nextToken()).add("ProvisionedResources", this.hasProvisionedResources() ? this.provisionedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "provisionedResources": {
                return Optional.ofNullable(clazz.cast(this.provisionedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("provisionedResources", PROVISIONED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentProvisionedResourcesResponse, T> g) {
        return obj -> g.apply((ListEnvironmentProvisionedResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProvisionedResource> provisionedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentProvisionedResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.provisionedResources(model.provisionedResources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProvisionedResource.Builder> getProvisionedResources() {
            List<ProvisionedResource.Builder> result = ProvisionedResourceListCopier.copyToBuilder(this.provisionedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedResources(Collection<ProvisionedResource.BuilderImpl> provisionedResources) {
            this.provisionedResources = ProvisionedResourceListCopier.copyFromBuilder(provisionedResources);
        }

        @Override
        public final Builder provisionedResources(Collection<ProvisionedResource> provisionedResources) {
            this.provisionedResources = ProvisionedResourceListCopier.copy(provisionedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(ProvisionedResource ... provisionedResources) {
            this.provisionedResources(Arrays.asList(provisionedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Consumer<ProvisionedResource.Builder> ... provisionedResources) {
            this.provisionedResources(Stream.of(provisionedResources).map(c -> (ProvisionedResource)((ProvisionedResource.Builder)ProvisionedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentProvisionedResourcesResponse build() {
            return new ListEnvironmentProvisionedResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentProvisionedResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder provisionedResources(Collection<ProvisionedResource> var1);

        public Builder provisionedResources(ProvisionedResource ... var1);

        public Builder provisionedResources(Consumer<ProvisionedResource.Builder> ... var1);
    }
}

