/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ComponentDeploymentIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceInstanceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceInstanceState> {
    private static final SdkField<List<String>> LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lastSuccessfulComponentDeploymentIds").getter(ServiceInstanceState.getter(ServiceInstanceState::lastSuccessfulComponentDeploymentIds)).setter(ServiceInstanceState.setter(Builder::lastSuccessfulComponentDeploymentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulComponentDeploymentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSuccessfulEnvironmentDeploymentId").getter(ServiceInstanceState.getter(ServiceInstanceState::lastSuccessfulEnvironmentDeploymentId)).setter(ServiceInstanceState.setter(Builder::lastSuccessfulEnvironmentDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulEnvironmentDeploymentId").build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSuccessfulServicePipelineDeploymentId").getter(ServiceInstanceState.getter(ServiceInstanceState::lastSuccessfulServicePipelineDeploymentId)).setter(ServiceInstanceState.setter(Builder::lastSuccessfulServicePipelineDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulServicePipelineDeploymentId").build()}).build();
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spec").getter(ServiceInstanceState.getter(ServiceInstanceState::spec)).setter(ServiceInstanceState.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMajorVersion").getter(ServiceInstanceState.getter(ServiceInstanceState::templateMajorVersion)).setter(ServiceInstanceState.setter(Builder::templateMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMinorVersion").getter(ServiceInstanceState.getter(ServiceInstanceState::templateMinorVersion)).setter(ServiceInstanceState.setter(Builder::templateMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(ServiceInstanceState.getter(ServiceInstanceState::templateName)).setter(ServiceInstanceState.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD, LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD, LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceInstanceState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> lastSuccessfulComponentDeploymentIds;
    private final String lastSuccessfulEnvironmentDeploymentId;
    private final String lastSuccessfulServicePipelineDeploymentId;
    private final String spec;
    private final String templateMajorVersion;
    private final String templateMinorVersion;
    private final String templateName;

    private ServiceInstanceState(BuilderImpl builder) {
        this.lastSuccessfulComponentDeploymentIds = builder.lastSuccessfulComponentDeploymentIds;
        this.lastSuccessfulEnvironmentDeploymentId = builder.lastSuccessfulEnvironmentDeploymentId;
        this.lastSuccessfulServicePipelineDeploymentId = builder.lastSuccessfulServicePipelineDeploymentId;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    public final boolean hasLastSuccessfulComponentDeploymentIds() {
        return this.lastSuccessfulComponentDeploymentIds != null && !(this.lastSuccessfulComponentDeploymentIds instanceof SdkAutoConstructList);
    }

    public final List<String> lastSuccessfulComponentDeploymentIds() {
        return this.lastSuccessfulComponentDeploymentIds;
    }

    public final String lastSuccessfulEnvironmentDeploymentId() {
        return this.lastSuccessfulEnvironmentDeploymentId;
    }

    public final String lastSuccessfulServicePipelineDeploymentId() {
        return this.lastSuccessfulServicePipelineDeploymentId;
    }

    public final String spec() {
        return this.spec;
    }

    public final String templateMajorVersion() {
        return this.templateMajorVersion;
    }

    public final String templateMinorVersion() {
        return this.templateMinorVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastSuccessfulComponentDeploymentIds() ? this.lastSuccessfulComponentDeploymentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulEnvironmentDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulServicePipelineDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInstanceState)) {
            return false;
        }
        ServiceInstanceState other = (ServiceInstanceState)obj;
        return this.hasLastSuccessfulComponentDeploymentIds() == other.hasLastSuccessfulComponentDeploymentIds() && Objects.equals(this.lastSuccessfulComponentDeploymentIds(), other.lastSuccessfulComponentDeploymentIds()) && Objects.equals(this.lastSuccessfulEnvironmentDeploymentId(), other.lastSuccessfulEnvironmentDeploymentId()) && Objects.equals(this.lastSuccessfulServicePipelineDeploymentId(), other.lastSuccessfulServicePipelineDeploymentId()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.templateMajorVersion(), other.templateMajorVersion()) && Objects.equals(this.templateMinorVersion(), other.templateMinorVersion()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceInstanceState").add("LastSuccessfulComponentDeploymentIds", this.hasLastSuccessfulComponentDeploymentIds() ? this.lastSuccessfulComponentDeploymentIds() : null).add("LastSuccessfulEnvironmentDeploymentId", (Object)this.lastSuccessfulEnvironmentDeploymentId()).add("LastSuccessfulServicePipelineDeploymentId", (Object)this.lastSuccessfulServicePipelineDeploymentId()).add("Spec", (Object)(this.spec() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateMajorVersion", (Object)this.templateMajorVersion()).add("TemplateMinorVersion", (Object)this.templateMinorVersion()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastSuccessfulComponentDeploymentIds": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulComponentDeploymentIds()));
            }
            case "lastSuccessfulEnvironmentDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulEnvironmentDeploymentId()));
            }
            case "lastSuccessfulServicePipelineDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulServicePipelineDeploymentId()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "templateMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMajorVersion()));
            }
            case "templateMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMinorVersion()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lastSuccessfulComponentDeploymentIds", LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD);
        map.put("lastSuccessfulEnvironmentDeploymentId", LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD);
        map.put("lastSuccessfulServicePipelineDeploymentId", LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceInstanceState, T> g) {
        return obj -> g.apply((ServiceInstanceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> lastSuccessfulComponentDeploymentIds = DefaultSdkAutoConstructList.getInstance();
        private String lastSuccessfulEnvironmentDeploymentId;
        private String lastSuccessfulServicePipelineDeploymentId;
        private String spec;
        private String templateMajorVersion;
        private String templateMinorVersion;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceInstanceState model) {
            this.lastSuccessfulComponentDeploymentIds(model.lastSuccessfulComponentDeploymentIds);
            this.lastSuccessfulEnvironmentDeploymentId(model.lastSuccessfulEnvironmentDeploymentId);
            this.lastSuccessfulServicePipelineDeploymentId(model.lastSuccessfulServicePipelineDeploymentId);
            this.spec(model.spec);
            this.templateMajorVersion(model.templateMajorVersion);
            this.templateMinorVersion(model.templateMinorVersion);
            this.templateName(model.templateName);
        }

        public final Collection<String> getLastSuccessfulComponentDeploymentIds() {
            if (this.lastSuccessfulComponentDeploymentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lastSuccessfulComponentDeploymentIds;
        }

        public final void setLastSuccessfulComponentDeploymentIds(Collection<String> lastSuccessfulComponentDeploymentIds) {
            this.lastSuccessfulComponentDeploymentIds = ComponentDeploymentIdListCopier.copy(lastSuccessfulComponentDeploymentIds);
        }

        @Override
        public final Builder lastSuccessfulComponentDeploymentIds(Collection<String> lastSuccessfulComponentDeploymentIds) {
            this.lastSuccessfulComponentDeploymentIds = ComponentDeploymentIdListCopier.copy(lastSuccessfulComponentDeploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastSuccessfulComponentDeploymentIds(String ... lastSuccessfulComponentDeploymentIds) {
            this.lastSuccessfulComponentDeploymentIds(Arrays.asList(lastSuccessfulComponentDeploymentIds));
            return this;
        }

        public final String getLastSuccessfulEnvironmentDeploymentId() {
            return this.lastSuccessfulEnvironmentDeploymentId;
        }

        public final void setLastSuccessfulEnvironmentDeploymentId(String lastSuccessfulEnvironmentDeploymentId) {
            this.lastSuccessfulEnvironmentDeploymentId = lastSuccessfulEnvironmentDeploymentId;
        }

        @Override
        public final Builder lastSuccessfulEnvironmentDeploymentId(String lastSuccessfulEnvironmentDeploymentId) {
            this.lastSuccessfulEnvironmentDeploymentId = lastSuccessfulEnvironmentDeploymentId;
            return this;
        }

        public final String getLastSuccessfulServicePipelineDeploymentId() {
            return this.lastSuccessfulServicePipelineDeploymentId;
        }

        public final void setLastSuccessfulServicePipelineDeploymentId(String lastSuccessfulServicePipelineDeploymentId) {
            this.lastSuccessfulServicePipelineDeploymentId = lastSuccessfulServicePipelineDeploymentId;
        }

        @Override
        public final Builder lastSuccessfulServicePipelineDeploymentId(String lastSuccessfulServicePipelineDeploymentId) {
            this.lastSuccessfulServicePipelineDeploymentId = lastSuccessfulServicePipelineDeploymentId;
            return this;
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return this.templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return this.templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public ServiceInstanceState build() {
            return new ServiceInstanceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceInstanceState> {
        public Builder lastSuccessfulComponentDeploymentIds(Collection<String> var1);

        public Builder lastSuccessfulComponentDeploymentIds(String ... var1);

        public Builder lastSuccessfulEnvironmentDeploymentId(String var1);

        public Builder lastSuccessfulServicePipelineDeploymentId(String var1);

        public Builder spec(String var1);

        public Builder templateMajorVersion(String var1);

        public Builder templateMinorVersion(String var1);

        public Builder templateName(String var1);
    }
}

