/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.Provisioning;
import software.amazon.awssdk.services.proton.model.Tag;
import software.amazon.awssdk.services.proton.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentTemplateRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::description)).setter(CreateEnvironmentTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::displayName)).setter(CreateEnvironmentTemplateRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::encryptionKey)).setter(CreateEnvironmentTemplateRequest.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::name)).setter(CreateEnvironmentTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVISIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioning").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::provisioningAsString)).setter(CreateEnvironmentTemplateRequest.setter(Builder::provisioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioning").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateEnvironmentTemplateRequest.getter(CreateEnvironmentTemplateRequest::tags)).setter(CreateEnvironmentTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ENCRYPTION_KEY_FIELD, NAME_FIELD, PROVISIONING_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentTemplateRequest.memberNameToFieldInitializer();
    private final String description;
    private final String displayName;
    private final String encryptionKey;
    private final String name;
    private final String provisioning;
    private final List<Tag> tags;

    private CreateEnvironmentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.encryptionKey = builder.encryptionKey;
        this.name = builder.name;
        this.provisioning = builder.provisioning;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final String name() {
        return this.name;
    }

    public final Provisioning provisioning() {
        return Provisioning.fromValue(this.provisioning);
    }

    public final String provisioningAsString() {
        return this.provisioning;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentTemplateRequest)) {
            return false;
        }
        CreateEnvironmentTemplateRequest other = (CreateEnvironmentTemplateRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningAsString(), other.provisioningAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentTemplateRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionKey", (Object)this.encryptionKey()).add("Name", (Object)this.name()).add("Provisioning", (Object)this.provisioningAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provisioning": {
                return Optional.ofNullable(clazz.cast(this.provisioningAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provisioning", PROVISIONING_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentTemplateRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String description;
        private String displayName;
        private String encryptionKey;
        private String name;
        private String provisioning;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentTemplateRequest model) {
            super(model);
            this.description(model.description);
            this.displayName(model.displayName);
            this.encryptionKey(model.encryptionKey);
            this.name(model.name);
            this.provisioning(model.provisioning);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioning() {
            return this.provisioning;
        }

        public final void setProvisioning(String provisioning) {
            this.provisioning = provisioning;
        }

        @Override
        public final Builder provisioning(String provisioning) {
            this.provisioning = provisioning;
            return this;
        }

        @Override
        public final Builder provisioning(Provisioning provisioning) {
            this.provisioning(provisioning == null ? null : provisioning.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentTemplateRequest build() {
            return new CreateEnvironmentTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentTemplateRequest> {
        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder encryptionKey(String var1);

        public Builder name(String var1);

        public Builder provisioning(String var1);

        public Builder provisioning(Provisioning var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

