/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.ServiceInstanceSummary;
import software.amazon.awssdk.services.proton.model.ServiceInstanceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceInstancesResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListServiceInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServiceInstancesResponse.getter(ListServiceInstancesResponse::nextToken)).setter(ListServiceInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServiceInstanceSummary>> SERVICE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceInstances").getter(ListServiceInstancesResponse.getter(ListServiceInstancesResponse::serviceInstances)).setter(ListServiceInstancesResponse.setter(Builder::serviceInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceInstancesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServiceInstanceSummary> serviceInstances;

    private ListServiceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceInstances = builder.serviceInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServiceInstances() {
        return this.serviceInstances != null && !(this.serviceInstances instanceof SdkAutoConstructList);
    }

    public final List<ServiceInstanceSummary> serviceInstances() {
        return this.serviceInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceInstances() ? this.serviceInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceInstancesResponse)) {
            return false;
        }
        ListServiceInstancesResponse other = (ListServiceInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServiceInstances() == other.hasServiceInstances() && Objects.equals(this.serviceInstances(), other.serviceInstances());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceInstancesResponse").add("NextToken", (Object)this.nextToken()).add("ServiceInstances", this.hasServiceInstances() ? this.serviceInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "serviceInstances": {
                return Optional.ofNullable(clazz.cast(this.serviceInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serviceInstances", SERVICE_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceInstancesResponse, T> g) {
        return obj -> g.apply((ListServiceInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceInstanceSummary> serviceInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceInstances(model.serviceInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceInstanceSummary.Builder> getServiceInstances() {
            List<ServiceInstanceSummary.Builder> result = ServiceInstanceSummaryListCopier.copyToBuilder(this.serviceInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceInstances(Collection<ServiceInstanceSummary.BuilderImpl> serviceInstances) {
            this.serviceInstances = ServiceInstanceSummaryListCopier.copyFromBuilder(serviceInstances);
        }

        @Override
        public final Builder serviceInstances(Collection<ServiceInstanceSummary> serviceInstances) {
            this.serviceInstances = ServiceInstanceSummaryListCopier.copy(serviceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInstances(ServiceInstanceSummary ... serviceInstances) {
            this.serviceInstances(Arrays.asList(serviceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInstances(Consumer<ServiceInstanceSummary.Builder> ... serviceInstances) {
            this.serviceInstances(Stream.of(serviceInstances).map(c -> (ServiceInstanceSummary)((ServiceInstanceSummary.Builder)ServiceInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceInstancesResponse build() {
            return new ListServiceInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder serviceInstances(Collection<ServiceInstanceSummary> var1);

        public Builder serviceInstances(ServiceInstanceSummary ... var1);

        public Builder serviceInstances(Consumer<ServiceInstanceSummary.Builder> ... var1);
    }
}

