/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.ServiceSummary;
import software.amazon.awssdk.services.proton.model.ServiceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServicesResponse.getter(ListServicesResponse::nextToken)).setter(ListServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServiceSummary>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(ListServicesResponse.getter(ListServicesResponse::services)).setter(ListServicesResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServicesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServiceSummary> services;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.services = builder.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<ServiceSummary> services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicesResponse").add("NextToken", (Object)this.nextToken()).add("Services", this.hasServices() ? this.services() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("services", SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceSummary> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.services(model.services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceSummary.Builder> getServices() {
            List<ServiceSummary.Builder> result = ServiceSummaryListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<ServiceSummary.BuilderImpl> services) {
            this.services = ServiceSummaryListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<ServiceSummary> services) {
            this.services = ServiceSummaryListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceSummary ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceSummary.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (ServiceSummary)((ServiceSummary.Builder)ServiceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesResponse> {
        public Builder nextToken(String var1);

        public Builder services(Collection<ServiceSummary> var1);

        public Builder services(ServiceSummary ... var1);

        public Builder services(Consumer<ServiceSummary.Builder> ... var1);
    }
}

