/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ServicePipeline;
import software.amazon.awssdk.services.proton.model.ServiceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Service.getter(Service::arn)).setter(Service.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(Service.getter(Service::branchName)).setter(Service.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Service.getter(Service::createdAt)).setter(Service.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Service.getter(Service::description)).setter(Service.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(Service.getter(Service::lastModifiedAt)).setter(Service.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Service.getter(Service::name)).setter(Service.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ServicePipeline> PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipeline").getter(Service.getter(Service::pipeline)).setter(Service.setter(Builder::pipeline)).constructor(ServicePipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()}).build();
    private static final SdkField<String> REPOSITORY_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryConnectionArn").getter(Service.getter(Service::repositoryConnectionArn)).setter(Service.setter(Builder::repositoryConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryConnectionArn").build()}).build();
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryId").getter(Service.getter(Service::repositoryId)).setter(Service.setter(Builder::repositoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()}).build();
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spec").getter(Service.getter(Service::spec)).setter(Service.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Service.getter(Service::statusAsString)).setter(Service.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(Service.getter(Service::statusMessage)).setter(Service.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(Service.getter(Service::templateName)).setter(Service.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BRANCH_NAME_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, PIPELINE_FIELD, REPOSITORY_CONNECTION_ARN_FIELD, REPOSITORY_ID_FIELD, SPEC_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Service.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String branchName;
    private final Instant createdAt;
    private final String description;
    private final Instant lastModifiedAt;
    private final String name;
    private final ServicePipeline pipeline;
    private final String repositoryConnectionArn;
    private final String repositoryId;
    private final String spec;
    private final String status;
    private final String statusMessage;
    private final String templateName;

    private Service(BuilderImpl builder) {
        this.arn = builder.arn;
        this.branchName = builder.branchName;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.pipeline = builder.pipeline;
        this.repositoryConnectionArn = builder.repositoryConnectionArn;
        this.repositoryId = builder.repositoryId;
        this.spec = builder.spec;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateName = builder.templateName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String name() {
        return this.name;
    }

    public final ServicePipeline pipeline() {
        return this.pipeline;
    }

    public final String repositoryConnectionArn() {
        return this.repositoryConnectionArn;
    }

    public final String repositoryId() {
        return this.repositoryId;
    }

    public final String spec() {
        return this.spec;
    }

    public final ServiceStatus status() {
        return ServiceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipeline(), other.pipeline()) && Objects.equals(this.repositoryConnectionArn(), other.repositoryConnectionArn()) && Objects.equals(this.repositoryId(), other.repositoryId()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("Arn", (Object)this.arn()).add("BranchName", (Object)this.branchName()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Name", (Object)this.name()).add("Pipeline", (Object)this.pipeline()).add("RepositoryConnectionArn", (Object)this.repositoryConnectionArn()).add("RepositoryId", (Object)this.repositoryId()).add("Spec", (Object)(this.spec() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)(this.statusMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pipeline": {
                return Optional.ofNullable(clazz.cast(this.pipeline()));
            }
            case "repositoryConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryConnectionArn()));
            }
            case "repositoryId": {
                return Optional.ofNullable(clazz.cast(this.repositoryId()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pipeline", PIPELINE_FIELD);
        map.put("repositoryConnectionArn", REPOSITORY_CONNECTION_ARN_FIELD);
        map.put("repositoryId", REPOSITORY_ID_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String branchName;
        private Instant createdAt;
        private String description;
        private Instant lastModifiedAt;
        private String name;
        private ServicePipeline pipeline;
        private String repositoryConnectionArn;
        private String repositoryId;
        private String spec;
        private String status;
        private String statusMessage;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.arn(model.arn);
            this.branchName(model.branchName);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastModifiedAt(model.lastModifiedAt);
            this.name(model.name);
            this.pipeline(model.pipeline);
            this.repositoryConnectionArn(model.repositoryConnectionArn);
            this.repositoryId(model.repositoryId);
            this.spec(model.spec);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.templateName(model.templateName);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServicePipeline.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        public final void setPipeline(ServicePipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(ServicePipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final String getRepositoryConnectionArn() {
            return this.repositoryConnectionArn;
        }

        public final void setRepositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
        }

        @Override
        public final Builder repositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
            return this;
        }

        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder arn(String var1);

        public Builder branchName(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder name(String var1);

        public Builder pipeline(ServicePipeline var1);

        default public Builder pipeline(Consumer<ServicePipeline.Builder> pipeline) {
            return this.pipeline((ServicePipeline)((ServicePipeline.Builder)ServicePipeline.builder().applyMutation(pipeline)).build());
        }

        public Builder repositoryConnectionArn(String var1);

        public Builder repositoryId(String var1);

        public Builder spec(String var1);

        public Builder status(String var1);

        public Builder status(ServiceStatus var1);

        public Builder statusMessage(String var1);

        public Builder templateName(String var1);
    }
}

