/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CreateComponentRequest;
import software.amazon.awssdk.services.proton.model.CreateComponentResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.proton.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.DeleteComponentRequest;
import software.amazon.awssdk.services.proton.model.DeleteComponentResponse;
import software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.proton.model.GetComponentRequest;
import software.amazon.awssdk.services.proton.model.GetComponentResponse;
import software.amazon.awssdk.services.proton.model.GetDeploymentRequest;
import software.amazon.awssdk.services.proton.model.GetDeploymentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetRepositoryRequest;
import software.amazon.awssdk.services.proton.model.GetRepositoryResponse;
import software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest;
import software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse;
import software.amazon.awssdk.services.proton.model.GetResourcesSummaryRequest;
import software.amazon.awssdk.services.proton.model.GetResourcesSummaryResponse;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusRequest;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse;
import software.amazon.awssdk.services.proton.model.GetServiceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest;
import software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse;
import software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListComponentsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentsResponse;
import software.amazon.awssdk.services.proton.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.proton.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.proton.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.proton.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ListServicesRequest;
import software.amazon.awssdk.services.proton.model.ListServicesResponse;
import software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest;
import software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeResponse;
import software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.TagResourceRequest;
import software.amazon.awssdk.services.proton.model.TagResourceResponse;
import software.amazon.awssdk.services.proton.model.UntagResourceRequest;
import software.amazon.awssdk.services.proton.model.UntagResourceResponse;
import software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.proton.model.UpdateComponentRequest;
import software.amazon.awssdk.services.proton.model.UpdateComponentResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest;
import software.amazon.awssdk.services.proton.model.UpdateServicePipelineResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.paginators.ListComponentOutputsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListRepositoriesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstancesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListServicesPublisher;
import software.amazon.awssdk.services.proton.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.proton.waiters.ProtonAsyncWaiter;

/**
 * Service client for accessing AWS Proton asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * This is the Proton Service API Reference. It provides descriptions, syntax and usage examples for each of the <a
 * href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Operations.html">actions</a> and <a
 * href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Types.html">data types</a> for the Proton service.
 * </p>
 * <p>
 * The documentation for each action shows the Query API request parameters and the XML response.
 * </p>
 * <p>
 * Alternatively, you can use the Amazon Web Services CLI to access an API. For more information, see the <a
 * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html">Amazon Web Services Command Line
 * Interface User Guide</a>.
 * </p>
 * <p>
 * The Proton service is a two-pronged automation framework. Administrators create service templates to provide
 * standardized infrastructure and deployment tooling for serverless and container based applications. Developers, in
 * turn, select from the available service templates to automate their application or service deployments.
 * </p>
 * <p>
 * Because administrators define the infrastructure and tooling that Proton deploys and manages, they need permissions
 * to use all of the listed API operations.
 * </p>
 * <p>
 * When developers select a specific infrastructure and tooling set, Proton deploys their applications. To monitor their
 * applications that are running on Proton, developers need permissions to the service <i>create</i>, <i>list</i>,
 * <i>update</i> and <i>delete</i> API operations and the service instance <i>list</i> and <i>update</i> API operations.
 * </p>
 * <p>
 * To learn more about Proton, see the <a href="https://docs.aws.amazon.com/proton/latest/userguide/Welcome.html">Proton
 * User Guide</a>.
 * </p>
 * <p>
 * <b>Ensuring Idempotency</b>
 * </p>
 * <p>
 * When you make a mutating API request, the request typically returns a result before the asynchronous workflows of the
 * operation are complete. Operations might also time out or encounter other server issues before they're complete, even
 * if the request already returned a result. This might make it difficult to determine whether the request succeeded.
 * Moreover, you might need to retry the request multiple times to ensure that the operation completes successfully.
 * However, if the original request and the subsequent retries are successful, the operation occurs multiple times. This
 * means that you might create more resources than you intended.
 * </p>
 * <p>
 * <i>Idempotency</i> ensures that an API request action completes no more than one time. With an idempotent request, if
 * the original request action completes successfully, any subsequent retries complete successfully without performing
 * any further actions. However, the result might contain updated information, such as the current creation status.
 * </p>
 * <p>
 * The following lists of APIs are grouped according to methods that ensure idempotency.
 * </p>
 * <p>
 * <b>Idempotent create APIs with a client token</b>
 * </p>
 * <p>
 * The API actions in this list support idempotency with the use of a <i>client token</i>. The corresponding Amazon Web
 * Services CLI commands also support idempotency using a client token. A client token is a unique, case-sensitive
 * string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client
 * token in the request. We recommend that you <i>don't</i> reuse the same client token for other API requests. If you
 * don’t provide a client token for these APIs, a default client token is automatically provided by SDKs.
 * </p>
 * <p>
 * Given a request action that has succeeded:
 * </p>
 * <p>
 * If you retry the request using the same client token and the same parameters, the retry succeeds without performing
 * any further actions other than returning the original resource detail data in the response.
 * </p>
 * <p>
 * If you retry the request using the same client token, but one or more of the parameters are different, the retry
 * throws a <code>ValidationException</code> with an <code>IdempotentParameterMismatch</code> error.
 * </p>
 * <p>
 * Client tokens expire eight hours after a request is made. If you retry the request with the expired token, a new
 * resource is created.
 * </p>
 * <p>
 * If the original resource is deleted and you retry the request, a new resource is created.
 * </p>
 * <p>
 * Idempotent create APIs with a client token:
 * </p>
 * <ul>
 * <li>
 * <p>
 * CreateEnvironmentTemplateVersion
 * </p>
 * </li>
 * <li>
 * <p>
 * CreateServiceTemplateVersion
 * </p>
 * </li>
 * <li>
 * <p>
 * CreateEnvironmentAccountConnection
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Idempotent create APIs</b>
 * </p>
 * <p>
 * Given a request action that has succeeded:
 * </p>
 * <p>
 * If you retry the request with an API from this group, and the original resource <i>hasn't</i> been modified, the
 * retry succeeds without performing any further actions other than returning the original resource detail data in the
 * response.
 * </p>
 * <p>
 * If the original resource has been modified, the retry throws a <code>ConflictException</code>.
 * </p>
 * <p>
 * If you retry with different input parameters, the retry throws a <code>ValidationException</code> with an
 * <code>IdempotentParameterMismatch</code> error.
 * </p>
 * <p>
 * Idempotent create APIs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * CreateEnvironmentTemplate
 * </p>
 * </li>
 * <li>
 * <p>
 * CreateServiceTemplate
 * </p>
 * </li>
 * <li>
 * <p>
 * CreateEnvironment
 * </p>
 * </li>
 * <li>
 * <p>
 * CreateService
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Idempotent delete APIs</b>
 * </p>
 * <p>
 * Given a request action that has succeeded:
 * </p>
 * <p>
 * When you retry the request with an API from this group and the resource was deleted, its metadata is returned in the
 * response.
 * </p>
 * <p>
 * If you retry and the resource doesn't exist, the response is empty.
 * </p>
 * <p>
 * In both cases, the retry succeeds.
 * </p>
 * <p>
 * Idempotent delete APIs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * DeleteEnvironmentTemplate
 * </p>
 * </li>
 * <li>
 * <p>
 * DeleteEnvironmentTemplateVersion
 * </p>
 * </li>
 * <li>
 * <p>
 * DeleteServiceTemplate
 * </p>
 * </li>
 * <li>
 * <p>
 * DeleteServiceTemplateVersion
 * </p>
 * </li>
 * <li>
 * <p>
 * DeleteEnvironmentAccountConnection
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Asynchronous idempotent delete APIs</b>
 * </p>
 * <p>
 * Given a request action that has succeeded:
 * </p>
 * <p>
 * If you retry the request with an API from this group, if the original request delete operation status is
 * <code>DELETE_IN_PROGRESS</code>, the retry returns the resource detail data in the response without performing any
 * further actions.
 * </p>
 * <p>
 * If the original request delete operation is complete, a retry returns an empty response.
 * </p>
 * <p>
 * Asynchronous idempotent delete APIs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * DeleteEnvironment
 * </p>
 * </li>
 * <li>
 * <p>
 * DeleteService
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ProtonAsyncClient extends AwsClient {
    String SERVICE_NAME = "proton";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "proton";

    /**
     * <p>
     * In a management account, an environment account connection request is accepted. When the environment account
     * connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure
     * resources in the associated environment account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param acceptEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the AcceptEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.AcceptEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/AcceptEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptEnvironmentAccountConnectionResponse> acceptEnvironmentAccountConnection(
            AcceptEnvironmentAccountConnectionRequest acceptEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In a management account, an environment account connection request is accepted. When the environment account
     * connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure
     * resources in the associated environment account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param acceptEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.AcceptEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/AcceptEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptEnvironmentAccountConnectionResponse> acceptEnvironmentAccountConnection(
            Consumer<AcceptEnvironmentAccountConnectionRequest.Builder> acceptEnvironmentAccountConnectionRequest) {
        return acceptEnvironmentAccountConnection(AcceptEnvironmentAccountConnectionRequest.builder()
                .applyMutation(acceptEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a component deployment (for a component that is in the <code>IN_PROGRESS</code> deployment
     * status).
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param cancelComponentDeploymentRequest
     * @return A Java Future containing the result of the CancelComponentDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelComponentDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelComponentDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelComponentDeploymentResponse> cancelComponentDeployment(
            CancelComponentDeploymentRequest cancelComponentDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a component deployment (for a component that is in the <code>IN_PROGRESS</code> deployment
     * status).
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelComponentDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link CancelComponentDeploymentRequest#builder()}
     * </p>
     *
     * @param cancelComponentDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelComponentDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelComponentDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelComponentDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelComponentDeploymentResponse> cancelComponentDeployment(
            Consumer<CancelComponentDeploymentRequest.Builder> cancelComponentDeploymentRequest) {
        return cancelComponentDeployment(CancelComponentDeploymentRequest.builder()
                .applyMutation(cancelComponentDeploymentRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel an environment deployment on an <a>UpdateEnvironment</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-update.html">Update an environment</a> in the
     * <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateEnvironment</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelEnvironmentDeploymentRequest
     * @return A Java Future containing the result of the CancelEnvironmentDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelEnvironmentDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelEnvironmentDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelEnvironmentDeploymentResponse> cancelEnvironmentDeployment(
            CancelEnvironmentDeploymentRequest cancelEnvironmentDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel an environment deployment on an <a>UpdateEnvironment</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-update.html">Update an environment</a> in the
     * <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateEnvironment</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelEnvironmentDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link CancelEnvironmentDeploymentRequest#builder()}
     * </p>
     *
     * @param cancelEnvironmentDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CancelEnvironmentDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelEnvironmentDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelEnvironmentDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelEnvironmentDeploymentResponse> cancelEnvironmentDeployment(
            Consumer<CancelEnvironmentDeploymentRequest.Builder> cancelEnvironmentDeploymentRequest) {
        return cancelEnvironmentDeployment(CancelEnvironmentDeploymentRequest.builder()
                .applyMutation(cancelEnvironmentDeploymentRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a service instance deployment on an <a>UpdateServiceInstance</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-instance-update.html">Update a service
     * instance</a> in the <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateServiceInstance</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelServiceInstanceDeploymentRequest
     * @return A Java Future containing the result of the CancelServiceInstanceDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelServiceInstanceDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServiceInstanceDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelServiceInstanceDeploymentResponse> cancelServiceInstanceDeployment(
            CancelServiceInstanceDeploymentRequest cancelServiceInstanceDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a service instance deployment on an <a>UpdateServiceInstance</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-instance-update.html">Update a service
     * instance</a> in the <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateServiceInstance</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelServiceInstanceDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link CancelServiceInstanceDeploymentRequest#builder()}
     * </p>
     *
     * @param cancelServiceInstanceDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelServiceInstanceDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelServiceInstanceDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServiceInstanceDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelServiceInstanceDeploymentResponse> cancelServiceInstanceDeployment(
            Consumer<CancelServiceInstanceDeploymentRequest.Builder> cancelServiceInstanceDeploymentRequest) {
        return cancelServiceInstanceDeployment(CancelServiceInstanceDeploymentRequest.builder()
                .applyMutation(cancelServiceInstanceDeploymentRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a service pipeline deployment on an <a>UpdateServicePipeline</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-pipeline-update.html">Update a service
     * pipeline</a> in the <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateServicePipeline</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelServicePipelineDeploymentRequest
     * @return A Java Future containing the result of the CancelServicePipelineDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelServicePipelineDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServicePipelineDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelServicePipelineDeploymentResponse> cancelServicePipelineDeployment(
            CancelServicePipelineDeploymentRequest cancelServicePipelineDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a service pipeline deployment on an <a>UpdateServicePipeline</a> action, if the deployment is
     * <code>IN_PROGRESS</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-pipeline-update.html">Update a service
     * pipeline</a> in the <i>Proton User guide</i>.
     * </p>
     * <p>
     * The following list includes potential cancellation scenarios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the current <a>UpdateServicePipeline</a> action succeeds before the cancellation attempt starts, the resulting
     * deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelServicePipelineDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link CancelServicePipelineDeploymentRequest#builder()}
     * </p>
     *
     * @param cancelServicePipelineDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelServicePipelineDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CancelServicePipelineDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServicePipelineDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelServicePipelineDeploymentResponse> cancelServicePipelineDeployment(
            Consumer<CancelServicePipelineDeploymentRequest.Builder> cancelServicePipelineDeploymentRequest) {
        return cancelServicePipelineDeployment(CancelServicePipelineDeploymentRequest.builder()
                .applyMutation(cancelServicePipelineDeploymentRequest).build());
    }

    /**
     * <p>
     * Create an Proton component. A component is an infrastructure extension for a service instance.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param createComponentRequest
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequest createComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an Proton component. A component is an infrastructure extension for a service instance.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(
            Consumer<CreateComponentRequest.Builder> createComponentRequest) {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Deploy a new environment. An Proton environment is created from an environment template that defines
     * infrastructure and resources that can be shared across services.
     * </p>
     * <p class="title">
     * <b>You can provision environments using the following methods:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as
     * code (IaC) files that your IaC engine uses to provision resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html">Provisioning methods</a> in
     * the <i>Proton User Guide</i>.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploy a new environment. An Proton environment is created from an environment template that defines
     * infrastructure and resources that can be shared across services.
     * </p>
     * <p class="title">
     * <b>You can provision environments using the following methods:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as
     * code (IaC) files that your IaC engine uses to provision resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html">Provisioning methods</a> in
     * the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Create an environment account connection in an environment account so that environment infrastructure resources
     * can be provisioned in the environment account from a management account.
     * </p>
     * <p>
     * An environment account connection is a secure bi-directional connection between a <i>management account</i> and
     * an <i>environment account</i> that maintains authorization and permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param createEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the CreateEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentAccountConnectionResponse> createEnvironmentAccountConnection(
            CreateEnvironmentAccountConnectionRequest createEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an environment account connection in an environment account so that environment infrastructure resources
     * can be provisioned in the environment account from a management account.
     * </p>
     * <p>
     * An environment account connection is a secure bi-directional connection between a <i>management account</i> and
     * an <i>environment account</i> that maintains authorization and permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param createEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentAccountConnectionResponse> createEnvironmentAccountConnection(
            Consumer<CreateEnvironmentAccountConnectionRequest.Builder> createEnvironmentAccountConnectionRequest) {
        return createEnvironmentAccountConnection(CreateEnvironmentAccountConnectionRequest.builder()
                .applyMutation(createEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * Create an environment template for Proton. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <p>
     * You can create an environment template in one of the two following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Register and publish a <i>standard</i> environment template that instructs Proton to deploy and manage
     * environment infrastructure.
     * </p>
     * </li>
     * <li>
     * <p>
     * Register and publish a <i>customer managed</i> environment template that connects Proton to your existing
     * provisioned infrastructure that you manage. Proton <i>doesn't</i> manage your existing provisioned
     * infrastructure. To create an environment template for customer provisioned and managed infrastructure, include
     * the <code>provisioning</code> parameter and set the value to <code>CUSTOMER_MANAGED</code>. For more information,
     * see <a href="https://docs.aws.amazon.com/proton/latest/userguide/template-create.html">Register and publish an
     * environment template</a> in the <i>Proton User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createEnvironmentTemplateRequest
     * @return A Java Future containing the result of the CreateEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentTemplateResponse> createEnvironmentTemplate(
            CreateEnvironmentTemplateRequest createEnvironmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an environment template for Proton. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <p>
     * You can create an environment template in one of the two following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Register and publish a <i>standard</i> environment template that instructs Proton to deploy and manage
     * environment infrastructure.
     * </p>
     * </li>
     * <li>
     * <p>
     * Register and publish a <i>customer managed</i> environment template that connects Proton to your existing
     * provisioned infrastructure that you manage. Proton <i>doesn't</i> manage your existing provisioned
     * infrastructure. To create an environment template for customer provisioned and managed infrastructure, include
     * the <code>provisioning</code> parameter and set the value to <code>CUSTOMER_MANAGED</code>. For more information,
     * see <a href="https://docs.aws.amazon.com/proton/latest/userguide/template-create.html">Register and publish an
     * environment template</a> in the <i>Proton User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentTemplateRequest#builder()}
     * </p>
     *
     * @param createEnvironmentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentTemplateResponse> createEnvironmentTemplate(
            Consumer<CreateEnvironmentTemplateRequest.Builder> createEnvironmentTemplateRequest) {
        return createEnvironmentTemplate(CreateEnvironmentTemplateRequest.builder()
                .applyMutation(createEnvironmentTemplateRequest).build());
    }

    /**
     * <p>
     * Create a new major or minor version of an environment template. A major version of an environment template is a
     * version that <i>isn't</i> backwards compatible. A minor version of an environment template is a version that's
     * backwards compatible within its major version.
     * </p>
     *
     * @param createEnvironmentTemplateVersionRequest
     * @return A Java Future containing the result of the CreateEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentTemplateVersionResponse> createEnvironmentTemplateVersion(
            CreateEnvironmentTemplateVersionRequest createEnvironmentTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new major or minor version of an environment template. A major version of an environment template is a
     * version that <i>isn't</i> backwards compatible. A minor version of an environment template is a version that's
     * backwards compatible within its major version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEnvironmentTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createEnvironmentTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentTemplateVersionResponse> createEnvironmentTemplateVersion(
            Consumer<CreateEnvironmentTemplateVersionRequest.Builder> createEnvironmentTemplateVersionRequest) {
        return createEnvironmentTemplateVersion(CreateEnvironmentTemplateVersionRequest.builder()
                .applyMutation(createEnvironmentTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Create and register a link to a repository. Proton uses the link to repeatedly access the repository, to either
     * push to it (self-managed provisioning) or pull from it (template sync). You can share a linked repository across
     * multiple resources (like environments using self-managed provisioning, or synced templates). When you create a
     * repository link, Proton creates a <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html">service-linked
     * role</a> for you.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a>, <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles"
     * >Template bundles</a>, and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html">Template sync
     * configurations</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param createRepositoryRequest
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create and register a link to a repository. Proton uses the link to repeatedly access the repository, to either
     * push to it (self-managed provisioning) or pull from it (template sync). You can share a linked repository across
     * multiple resources (like environments using self-managed provisioning, or synced templates). When you create a
     * repository link, Proton creates a <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html">service-linked
     * role</a> for you.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a>, <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles"
     * >Template bundles</a>, and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html">Template sync
     * configurations</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(
            Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Create an Proton service. An Proton service is an instantiation of a service template and often includes several
     * service instances and pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-services.html">Services</a> in the <i>Proton User
     * Guide</i>.
     * </p>
     *
     * @param createServiceRequest
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an Proton service. An Proton service is an instantiation of a service template and often includes several
     * service instances and pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-services.html">Services</a> in the <i>Proton User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServiceRequest#builder()}
     * </p>
     *
     * @param createServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) {
        return createService(CreateServiceRequest.builder().applyMutation(createServiceRequest).build());
    }

    /**
     * <p>
     * Create a service instance.
     * </p>
     *
     * @param createServiceInstanceRequest
     * @return A Java Future containing the result of the CreateServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceInstanceResponse> createServiceInstance(
            CreateServiceInstanceRequest createServiceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a service instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceInstanceRequest#builder()}
     * </p>
     *
     * @param createServiceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceInstanceResponse> createServiceInstance(
            Consumer<CreateServiceInstanceRequest.Builder> createServiceInstanceRequest) {
        return createServiceInstance(CreateServiceInstanceRequest.builder().applyMutation(createServiceInstanceRequest).build());
    }

    /**
     * <p>
     * Create the Proton Ops configuration file.
     * </p>
     *
     * @param createServiceSyncConfigRequest
     * @return A Java Future containing the result of the CreateServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceSyncConfigResponse> createServiceSyncConfig(
            CreateServiceSyncConfigRequest createServiceSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create the Proton Ops configuration file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateServiceSyncConfigRequest#builder()}
     * </p>
     *
     * @param createServiceSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceSyncConfigResponse> createServiceSyncConfig(
            Consumer<CreateServiceSyncConfigRequest.Builder> createServiceSyncConfigRequest) {
        return createServiceSyncConfig(CreateServiceSyncConfigRequest.builder().applyMutation(createServiceSyncConfigRequest)
                .build());
    }

    /**
     * <p>
     * Create a service template. The administrator creates a service template to define standardized infrastructure and
     * an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected
     * service template includes a service pipeline definition, they provide a link to their source code repository.
     * Proton then deploys and manages the infrastructure defined by the selected service template. For more
     * information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Proton
     * templates</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param createServiceTemplateRequest
     * @return A Java Future containing the result of the CreateServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceTemplateResponse> createServiceTemplate(
            CreateServiceTemplateRequest createServiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a service template. The administrator creates a service template to define standardized infrastructure and
     * an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected
     * service template includes a service pipeline definition, they provide a link to their source code repository.
     * Proton then deploys and manages the infrastructure defined by the selected service template. For more
     * information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Proton
     * templates</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceTemplateRequest#builder()}
     * </p>
     *
     * @param createServiceTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceTemplateResponse> createServiceTemplate(
            Consumer<CreateServiceTemplateRequest.Builder> createServiceTemplateRequest) {
        return createServiceTemplate(CreateServiceTemplateRequest.builder().applyMutation(createServiceTemplateRequest).build());
    }

    /**
     * <p>
     * Create a new major or minor version of a service template. A major version of a service template is a version
     * that <i>isn't</i> backward compatible. A minor version of a service template is a version that's backward
     * compatible within its major version.
     * </p>
     *
     * @param createServiceTemplateVersionRequest
     * @return A Java Future containing the result of the CreateServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceTemplateVersionResponse> createServiceTemplateVersion(
            CreateServiceTemplateVersionRequest createServiceTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new major or minor version of a service template. A major version of a service template is a version
     * that <i>isn't</i> backward compatible. A minor version of a service template is a version that's backward
     * compatible within its major version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createServiceTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceTemplateVersionResponse> createServiceTemplateVersion(
            Consumer<CreateServiceTemplateVersionRequest.Builder> createServiceTemplateVersionRequest) {
        return createServiceTemplateVersion(CreateServiceTemplateVersionRequest.builder()
                .applyMutation(createServiceTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Set up a template to create new template versions automatically by tracking a linked repository. A linked
     * repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     * <p>
     * When a commit is pushed to your linked repository, Proton checks for changes to your repository template bundles.
     * If it detects a template bundle change, a new major or minor version of its template is created, if the version
     * doesn’t already exist. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html">Template sync
     * configurations</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param createTemplateSyncConfigRequest
     * @return A Java Future containing the result of the CreateTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTemplateSyncConfigResponse> createTemplateSyncConfig(
            CreateTemplateSyncConfigRequest createTemplateSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set up a template to create new template versions automatically by tracking a linked repository. A linked
     * repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     * <p>
     * When a commit is pushed to your linked repository, Proton checks for changes to your repository template bundles.
     * If it detects a template bundle change, a new major or minor version of its template is created, if the version
     * doesn’t already exist. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html">Template sync
     * configurations</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTemplateSyncConfigRequest#builder()}
     * </p>
     *
     * @param createTemplateSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.CreateTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTemplateSyncConfigResponse> createTemplateSyncConfig(
            Consumer<CreateTemplateSyncConfigRequest.Builder> createTemplateSyncConfigRequest) {
        return createTemplateSyncConfig(CreateTemplateSyncConfigRequest.builder().applyMutation(createTemplateSyncConfigRequest)
                .build());
    }

    /**
     * <p>
     * Delete an Proton component resource.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Proton component resource.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(
            Consumer<DeleteComponentRequest.Builder> deleteComponentRequest) {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Delete the deployment.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(
            Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest) {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Delete an environment.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * In an environment account, delete an environment account connection.
     * </p>
     * <p>
     * After you delete an environment account connection that’s in use by an Proton environment, Proton <i>can’t</i>
     * manage the environment infrastructure resources until a new environment account connection is accepted for the
     * environment account and associated environment. You're responsible for cleaning up provisioned resources that
     * remain without an environment connection.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param deleteEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the DeleteEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentAccountConnectionResponse> deleteEnvironmentAccountConnection(
            DeleteEnvironmentAccountConnectionRequest deleteEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In an environment account, delete an environment account connection.
     * </p>
     * <p>
     * After you delete an environment account connection that’s in use by an Proton environment, Proton <i>can’t</i>
     * manage the environment infrastructure resources until a new environment account connection is accepted for the
     * environment account and associated environment. You're responsible for cleaning up provisioned resources that
     * remain without an environment connection.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentAccountConnectionResponse> deleteEnvironmentAccountConnection(
            Consumer<DeleteEnvironmentAccountConnectionRequest.Builder> deleteEnvironmentAccountConnectionRequest) {
        return deleteEnvironmentAccountConnection(DeleteEnvironmentAccountConnectionRequest.builder()
                .applyMutation(deleteEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * If no other major or minor versions of an environment template exist, delete the environment template.
     * </p>
     *
     * @param deleteEnvironmentTemplateRequest
     * @return A Java Future containing the result of the DeleteEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentTemplateResponse> deleteEnvironmentTemplate(
            DeleteEnvironmentTemplateRequest deleteEnvironmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If no other major or minor versions of an environment template exist, delete the environment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentTemplateResponse> deleteEnvironmentTemplate(
            Consumer<DeleteEnvironmentTemplateRequest.Builder> deleteEnvironmentTemplateRequest) {
        return deleteEnvironmentTemplate(DeleteEnvironmentTemplateRequest.builder()
                .applyMutation(deleteEnvironmentTemplateRequest).build());
    }

    /**
     * <p>
     * If no other minor versions of an environment template exist, delete a major version of the environment template
     * if it's not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the environment
     * template if no other major versions or minor versions of the environment template exist. A major version of an
     * environment template is a version that's not backward compatible.
     * </p>
     * <p>
     * Delete a minor version of an environment template if it <i>isn't</i> the <code>Recommended</code> version. Delete
     * a <code>Recommended</code> minor version of the environment template if no other minor versions of the
     * environment template exist. A minor version of an environment template is a version that's backward compatible.
     * </p>
     *
     * @param deleteEnvironmentTemplateVersionRequest
     * @return A Java Future containing the result of the DeleteEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentTemplateVersionResponse> deleteEnvironmentTemplateVersion(
            DeleteEnvironmentTemplateVersionRequest deleteEnvironmentTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If no other minor versions of an environment template exist, delete a major version of the environment template
     * if it's not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the environment
     * template if no other major versions or minor versions of the environment template exist. A major version of an
     * environment template is a version that's not backward compatible.
     * </p>
     * <p>
     * Delete a minor version of an environment template if it <i>isn't</i> the <code>Recommended</code> version. Delete
     * a <code>Recommended</code> minor version of the environment template if no other minor versions of the
     * environment template exist. A minor version of an environment template is a version that's backward compatible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEnvironmentTemplateVersionRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentTemplateVersionResponse> deleteEnvironmentTemplateVersion(
            Consumer<DeleteEnvironmentTemplateVersionRequest.Builder> deleteEnvironmentTemplateVersionRequest) {
        return deleteEnvironmentTemplateVersion(DeleteEnvironmentTemplateVersionRequest.builder()
                .applyMutation(deleteEnvironmentTemplateVersionRequest).build());
    }

    /**
     * <p>
     * De-register and unlink your repository.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * De-register and unlink your repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(
            Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Delete a service, with its instances and pipeline.
     * </p>
     * <note>
     * <p>
     * You can't delete a service if it has any service instances that have components attached to them.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteServiceRequest
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a service, with its instances and pipeline.
     * </p>
     * <note>
     * <p>
     * You can't delete a service if it has any service instances that have components attached to them.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServiceRequest#builder()}
     * </p>
     *
     * @param deleteServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) {
        return deleteService(DeleteServiceRequest.builder().applyMutation(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Delete the Proton Ops file.
     * </p>
     *
     * @param deleteServiceSyncConfigRequest
     * @return A Java Future containing the result of the DeleteServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceSyncConfigResponse> deleteServiceSyncConfig(
            DeleteServiceSyncConfigRequest deleteServiceSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the Proton Ops file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServiceSyncConfigRequest#builder()}
     * </p>
     *
     * @param deleteServiceSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceSyncConfigResponse> deleteServiceSyncConfig(
            Consumer<DeleteServiceSyncConfigRequest.Builder> deleteServiceSyncConfigRequest) {
        return deleteServiceSyncConfig(DeleteServiceSyncConfigRequest.builder().applyMutation(deleteServiceSyncConfigRequest)
                .build());
    }

    /**
     * <p>
     * If no other major or minor versions of the service template exist, delete the service template.
     * </p>
     *
     * @param deleteServiceTemplateRequest
     * @return A Java Future containing the result of the DeleteServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceTemplateResponse> deleteServiceTemplate(
            DeleteServiceTemplateRequest deleteServiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If no other major or minor versions of the service template exist, delete the service template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceTemplateRequest#builder()}
     * </p>
     *
     * @param deleteServiceTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceTemplateResponse> deleteServiceTemplate(
            Consumer<DeleteServiceTemplateRequest.Builder> deleteServiceTemplateRequest) {
        return deleteServiceTemplate(DeleteServiceTemplateRequest.builder().applyMutation(deleteServiceTemplateRequest).build());
    }

    /**
     * <p>
     * If no other minor versions of a service template exist, delete a major version of the service template if it's
     * not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the service template if
     * no other major versions or minor versions of the service template exist. A major version of a service template is
     * a version that <i>isn't</i> backwards compatible.
     * </p>
     * <p>
     * Delete a minor version of a service template if it's not the <code>Recommended</code> version. Delete a
     * <code>Recommended</code> minor version of the service template if no other minor versions of the service template
     * exist. A minor version of a service template is a version that's backwards compatible.
     * </p>
     *
     * @param deleteServiceTemplateVersionRequest
     * @return A Java Future containing the result of the DeleteServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceTemplateVersionResponse> deleteServiceTemplateVersion(
            DeleteServiceTemplateVersionRequest deleteServiceTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If no other minor versions of a service template exist, delete a major version of the service template if it's
     * not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the service template if
     * no other major versions or minor versions of the service template exist. A major version of a service template is
     * a version that <i>isn't</i> backwards compatible.
     * </p>
     * <p>
     * Delete a minor version of a service template if it's not the <code>Recommended</code> version. Delete a
     * <code>Recommended</code> minor version of the service template if no other minor versions of the service template
     * exist. A minor version of a service template is a version that's backwards compatible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceTemplateVersionRequest#builder()}
     * </p>
     *
     * @param deleteServiceTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceTemplateVersionResponse> deleteServiceTemplateVersion(
            Consumer<DeleteServiceTemplateVersionRequest.Builder> deleteServiceTemplateVersionRequest) {
        return deleteServiceTemplateVersion(DeleteServiceTemplateVersionRequest.builder()
                .applyMutation(deleteServiceTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Delete a template sync configuration.
     * </p>
     *
     * @param deleteTemplateSyncConfigRequest
     * @return A Java Future containing the result of the DeleteTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateSyncConfigResponse> deleteTemplateSyncConfig(
            DeleteTemplateSyncConfigRequest deleteTemplateSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a template sync configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTemplateSyncConfigRequest#builder()}
     * </p>
     *
     * @param deleteTemplateSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.DeleteTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateSyncConfigResponse> deleteTemplateSyncConfig(
            Consumer<DeleteTemplateSyncConfigRequest.Builder> deleteTemplateSyncConfigRequest) {
        return deleteTemplateSyncConfig(DeleteTemplateSyncConfigRequest.builder().applyMutation(deleteTemplateSyncConfigRequest)
                .build());
    }

    /**
     * <p>
     * Get detail data for Proton account-wide settings.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detail data for Proton account-wide settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a component.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a component.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Get detailed data for an environment.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for an environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * In an environment account, get the detailed data for an environment account connection.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param getEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the GetEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentAccountConnectionResponse> getEnvironmentAccountConnection(
            GetEnvironmentAccountConnectionRequest getEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In an environment account, get the detailed data for an environment account connection.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link GetEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param getEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentAccountConnectionResponse> getEnvironmentAccountConnection(
            Consumer<GetEnvironmentAccountConnectionRequest.Builder> getEnvironmentAccountConnectionRequest) {
        return getEnvironmentAccountConnection(GetEnvironmentAccountConnectionRequest.builder()
                .applyMutation(getEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * Get detailed data for an environment template.
     * </p>
     *
     * @param getEnvironmentTemplateRequest
     * @return A Java Future containing the result of the GetEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentTemplateResponse> getEnvironmentTemplate(
            GetEnvironmentTemplateRequest getEnvironmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for an environment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentTemplateRequest#builder()}
     * </p>
     *
     * @param getEnvironmentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentTemplateResponse> getEnvironmentTemplate(
            Consumer<GetEnvironmentTemplateRequest.Builder> getEnvironmentTemplateRequest) {
        return getEnvironmentTemplate(GetEnvironmentTemplateRequest.builder().applyMutation(getEnvironmentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Get detailed data for a major or minor version of an environment template.
     * </p>
     *
     * @param getEnvironmentTemplateVersionRequest
     * @return A Java Future containing the result of the GetEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentTemplateVersionResponse> getEnvironmentTemplateVersion(
            GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a major or minor version of an environment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetEnvironmentTemplateVersionRequest#builder()}
     * </p>
     *
     * @param getEnvironmentTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentTemplateVersionResponse> getEnvironmentTemplateVersion(
            Consumer<GetEnvironmentTemplateVersionRequest.Builder> getEnvironmentTemplateVersionRequest) {
        return getEnvironmentTemplateVersion(GetEnvironmentTemplateVersionRequest.builder()
                .applyMutation(getEnvironmentTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Get detail data for a linked repository.
     * </p>
     *
     * @param getRepositoryRequest
     * @return A Java Future containing the result of the GetRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest getRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detail data for a linked repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetRepositoryRequest#builder()}
     * </p>
     *
     * @param getRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryResponse> getRepository(Consumer<GetRepositoryRequest.Builder> getRepositoryRequest) {
        return getRepository(GetRepositoryRequest.builder().applyMutation(getRepositoryRequest).build());
    }

    /**
     * <p>
     * Get the sync status of a repository used for Proton template sync. For more information about template sync, see
     * .
     * </p>
     * <note>
     * <p>
     * A repository sync status isn't tied to the Proton Repository resource (or any other Proton resource). Therefore,
     * tags on an Proton Repository resource have no effect on this action. Specifically, you can't use these tags to
     * control access to this action using Attribute-based access control (ABAC).
     * </p>
     * <p>
     * For more information about ABAC, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags"
     * >ABAC</a> in the <i>Proton User Guide</i>.
     * </p>
     * </note>
     *
     * @param getRepositorySyncStatusRequest
     * @return A Java Future containing the result of the GetRepositorySyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositorySyncStatusResponse> getRepositorySyncStatus(
            GetRepositorySyncStatusRequest getRepositorySyncStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the sync status of a repository used for Proton template sync. For more information about template sync, see
     * .
     * </p>
     * <note>
     * <p>
     * A repository sync status isn't tied to the Proton Repository resource (or any other Proton resource). Therefore,
     * tags on an Proton Repository resource have no effect on this action. Specifically, you can't use these tags to
     * control access to this action using Attribute-based access control (ABAC).
     * </p>
     * <p>
     * For more information about ABAC, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags"
     * >ABAC</a> in the <i>Proton User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositorySyncStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetRepositorySyncStatusRequest#builder()}
     * </p>
     *
     * @param getRepositorySyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRepositorySyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositorySyncStatusResponse> getRepositorySyncStatus(
            Consumer<GetRepositorySyncStatusRequest.Builder> getRepositorySyncStatusRequest) {
        return getRepositorySyncStatus(GetRepositorySyncStatusRequest.builder().applyMutation(getRepositorySyncStatusRequest)
                .build());
    }

    /**
     * <p>
     * Get counts of Proton resources.
     * </p>
     * <p>
     * For infrastructure-provisioning resources (environments, services, service instances, pipelines), the action
     * returns staleness counts. A resource is stale when it's behind the recommended version of the Proton template
     * that it uses and it needs an update to become current.
     * </p>
     * <p>
     * The action returns staleness counts (counts of resources that are up-to-date, behind a template major version, or
     * behind a template minor version), the total number of resources, and the number of resources that are in a failed
     * state, grouped by resource type. Components, environments, and service templates return less information - see
     * the <code>components</code>, <code>environments</code>, and <code>serviceTemplates</code> field descriptions.
     * </p>
     * <p>
     * For context, the action also returns the total number of each type of Proton template in the Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/monitoring-dashboard.html">Proton dashboard</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param getResourcesSummaryRequest
     * @return A Java Future containing the result of the GetResourcesSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetResourcesSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetResourcesSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcesSummaryResponse> getResourcesSummary(
            GetResourcesSummaryRequest getResourcesSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get counts of Proton resources.
     * </p>
     * <p>
     * For infrastructure-provisioning resources (environments, services, service instances, pipelines), the action
     * returns staleness counts. A resource is stale when it's behind the recommended version of the Proton template
     * that it uses and it needs an update to become current.
     * </p>
     * <p>
     * The action returns staleness counts (counts of resources that are up-to-date, behind a template major version, or
     * behind a template minor version), the total number of resources, and the number of resources that are in a failed
     * state, grouped by resource type. Components, environments, and service templates return less information - see
     * the <code>components</code>, <code>environments</code>, and <code>serviceTemplates</code> field descriptions.
     * </p>
     * <p>
     * For context, the action also returns the total number of each type of Proton template in the Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/monitoring-dashboard.html">Proton dashboard</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcesSummaryRequest#builder()}
     * </p>
     *
     * @param getResourcesSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetResourcesSummaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcesSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetResourcesSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetResourcesSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcesSummaryResponse> getResourcesSummary(
            Consumer<GetResourcesSummaryRequest.Builder> getResourcesSummaryRequest) {
        return getResourcesSummary(GetResourcesSummaryRequest.builder().applyMutation(getResourcesSummaryRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a service.
     * </p>
     *
     * @param getServiceRequest
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(GetServiceRequest getServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceRequest#builder()}
     * </p>
     *
     * @param getServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(Consumer<GetServiceRequest.Builder> getServiceRequest) {
        return getService(GetServiceRequest.builder().applyMutation(getServiceRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a service instance. A service instance is an instantiation of service template and it runs
     * in a specific environment.
     * </p>
     *
     * @param getServiceInstanceRequest
     * @return A Java Future containing the result of the GetServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceInstanceResponse> getServiceInstance(GetServiceInstanceRequest getServiceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a service instance. A service instance is an instantiation of service template and it runs
     * in a specific environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceInstanceRequest#builder()}
     * </p>
     *
     * @param getServiceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceInstanceResponse> getServiceInstance(
            Consumer<GetServiceInstanceRequest.Builder> getServiceInstanceRequest) {
        return getServiceInstance(GetServiceInstanceRequest.builder().applyMutation(getServiceInstanceRequest).build());
    }

    /**
     * <p>
     * Get the status of the synced service instance.
     * </p>
     *
     * @param getServiceInstanceSyncStatusRequest
     * @return A Java Future containing the result of the GetServiceInstanceSyncStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceInstanceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstanceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceInstanceSyncStatusResponse> getServiceInstanceSyncStatus(
            GetServiceInstanceSyncStatusRequest getServiceInstanceSyncStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the status of the synced service instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceInstanceSyncStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceInstanceSyncStatusRequest#builder()}
     * </p>
     *
     * @param getServiceInstanceSyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetServiceInstanceSyncStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceInstanceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstanceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceInstanceSyncStatusResponse> getServiceInstanceSyncStatus(
            Consumer<GetServiceInstanceSyncStatusRequest.Builder> getServiceInstanceSyncStatusRequest) {
        return getServiceInstanceSyncStatus(GetServiceInstanceSyncStatusRequest.builder()
                .applyMutation(getServiceInstanceSyncStatusRequest).build());
    }

    /**
     * <p>
     * Get detailed data for the service sync blocker summary.
     * </p>
     *
     * @param getServiceSyncBlockerSummaryRequest
     * @return A Java Future containing the result of the GetServiceSyncBlockerSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSyncBlockerSummaryResponse> getServiceSyncBlockerSummary(
            GetServiceSyncBlockerSummaryRequest getServiceSyncBlockerSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for the service sync blocker summary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSyncBlockerSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceSyncBlockerSummaryRequest#builder()}
     * </p>
     *
     * @param getServiceSyncBlockerSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetServiceSyncBlockerSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSyncBlockerSummaryResponse> getServiceSyncBlockerSummary(
            Consumer<GetServiceSyncBlockerSummaryRequest.Builder> getServiceSyncBlockerSummaryRequest) {
        return getServiceSyncBlockerSummary(GetServiceSyncBlockerSummaryRequest.builder()
                .applyMutation(getServiceSyncBlockerSummaryRequest).build());
    }

    /**
     * <p>
     * Get detailed information for the service sync configuration.
     * </p>
     *
     * @param getServiceSyncConfigRequest
     * @return A Java Future containing the result of the GetServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceSyncConfigResponse> getServiceSyncConfig(
            GetServiceSyncConfigRequest getServiceSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed information for the service sync configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSyncConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSyncConfigRequest#builder()}
     * </p>
     *
     * @param getServiceSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceSyncConfigResponse> getServiceSyncConfig(
            Consumer<GetServiceSyncConfigRequest.Builder> getServiceSyncConfigRequest) {
        return getServiceSyncConfig(GetServiceSyncConfigRequest.builder().applyMutation(getServiceSyncConfigRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a service template.
     * </p>
     *
     * @param getServiceTemplateRequest
     * @return A Java Future containing the result of the GetServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceTemplateResponse> getServiceTemplate(GetServiceTemplateRequest getServiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a service template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceTemplateRequest#builder()}
     * </p>
     *
     * @param getServiceTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceTemplateResponse> getServiceTemplate(
            Consumer<GetServiceTemplateRequest.Builder> getServiceTemplateRequest) {
        return getServiceTemplate(GetServiceTemplateRequest.builder().applyMutation(getServiceTemplateRequest).build());
    }

    /**
     * <p>
     * Get detailed data for a major or minor version of a service template.
     * </p>
     *
     * @param getServiceTemplateVersionRequest
     * @return A Java Future containing the result of the GetServiceTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceTemplateVersionResponse> getServiceTemplateVersion(
            GetServiceTemplateVersionRequest getServiceTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed data for a major or minor version of a service template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceTemplateVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetServiceTemplateVersionRequest#builder()}
     * </p>
     *
     * @param getServiceTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceTemplateVersionResponse> getServiceTemplateVersion(
            Consumer<GetServiceTemplateVersionRequest.Builder> getServiceTemplateVersionRequest) {
        return getServiceTemplateVersion(GetServiceTemplateVersionRequest.builder()
                .applyMutation(getServiceTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Get detail data for a template sync configuration.
     * </p>
     *
     * @param getTemplateSyncConfigRequest
     * @return A Java Future containing the result of the GetTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateSyncConfigResponse> getTemplateSyncConfig(
            GetTemplateSyncConfigRequest getTemplateSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detail data for a template sync configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateSyncConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSyncConfigRequest#builder()}
     * </p>
     *
     * @param getTemplateSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateSyncConfigResponse> getTemplateSyncConfig(
            Consumer<GetTemplateSyncConfigRequest.Builder> getTemplateSyncConfigRequest) {
        return getTemplateSyncConfig(GetTemplateSyncConfigRequest.builder().applyMutation(getTemplateSyncConfigRequest).build());
    }

    /**
     * <p>
     * Get the status of a template sync.
     * </p>
     *
     * @param getTemplateSyncStatusRequest
     * @return A Java Future containing the result of the GetTemplateSyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetTemplateSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateSyncStatusResponse> getTemplateSyncStatus(
            GetTemplateSyncStatusRequest getTemplateSyncStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the status of a template sync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateSyncStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSyncStatusRequest#builder()}
     * </p>
     *
     * @param getTemplateSyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTemplateSyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.GetTemplateSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateSyncStatusResponse> getTemplateSyncStatus(
            Consumer<GetTemplateSyncStatusRequest.Builder> getTemplateSyncStatusRequest) {
        return getTemplateSyncStatus(GetTemplateSyncStatusRequest.builder().applyMutation(getTemplateSyncStatusRequest).build());
    }

    /**
     * <p>
     * Get a list of component Infrastructure as Code (IaC) outputs.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param listComponentOutputsRequest
     * @return A Java Future containing the result of the ListComponentOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentOutputsResponse> listComponentOutputs(
            ListComponentOutputsRequest listComponentOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of component Infrastructure as Code (IaC) outputs.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentOutputsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentOutputsRequest#builder()}
     * </p>
     *
     * @param listComponentOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComponentOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentOutputsResponse> listComponentOutputs(
            Consumer<ListComponentOutputsRequest.Builder> listComponentOutputsRequest) {
        return listComponentOutputs(ListComponentOutputsRequest.builder().applyMutation(listComponentOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentOutputs(software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentOutputsPublisher publisher = client.listComponentOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentOutputsPublisher publisher = client.listComponentOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentOutputs(software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentOutputsPublisher listComponentOutputsPaginator(ListComponentOutputsRequest listComponentOutputsRequest) {
        return new ListComponentOutputsPublisher(this, listComponentOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentOutputs(software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentOutputsPublisher publisher = client.listComponentOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentOutputsPublisher publisher = client.listComponentOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentOutputs(software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentOutputsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentOutputsRequest#builder()}
     * </p>
     *
     * @param listComponentOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentOutputsPublisher listComponentOutputsPaginator(
            Consumer<ListComponentOutputsRequest.Builder> listComponentOutputsRequest) {
        return listComponentOutputsPaginator(ListComponentOutputsRequest.builder().applyMutation(listComponentOutputsRequest)
                .build());
    }

    /**
     * <p>
     * List provisioned resources for a component with details.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param listComponentProvisionedResourcesRequest
     * @return A Java Future containing the result of the ListComponentProvisionedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentProvisionedResourcesResponse> listComponentProvisionedResources(
            ListComponentProvisionedResourcesRequest listComponentProvisionedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List provisioned resources for a component with details.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentProvisionedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListComponentProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listComponentProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListComponentProvisionedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentProvisionedResourcesResponse> listComponentProvisionedResources(
            Consumer<ListComponentProvisionedResourcesRequest.Builder> listComponentProvisionedResourcesRequest) {
        return listComponentProvisionedResources(ListComponentProvisionedResourcesRequest.builder()
                .applyMutation(listComponentProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentProvisionedResources(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesPublisher publisher = client.listComponentProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesPublisher publisher = client.listComponentProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentProvisionedResources(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentProvisionedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentProvisionedResourcesPublisher listComponentProvisionedResourcesPaginator(
            ListComponentProvisionedResourcesRequest listComponentProvisionedResourcesRequest) {
        return new ListComponentProvisionedResourcesPublisher(this, listComponentProvisionedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentProvisionedResources(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesPublisher publisher = client.listComponentProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesPublisher publisher = client.listComponentProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentProvisionedResources(software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentProvisionedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListComponentProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listComponentProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentProvisionedResourcesPublisher listComponentProvisionedResourcesPaginator(
            Consumer<ListComponentProvisionedResourcesRequest.Builder> listComponentProvisionedResourcesRequest) {
        return listComponentProvisionedResourcesPaginator(ListComponentProvisionedResourcesRequest.builder()
                .applyMutation(listComponentProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * List components with summary data. You can filter the result list by environment, service, or a single service
     * instance.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List components with summary data. You can filter the result list by environment, service, or a single service
     * instance.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listComponents(software.amazon.awssdk.services.proton.model.ListComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.proton.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        return new ListComponentsPublisher(this, listComponentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listComponents(software.amazon.awssdk.services.proton.model.ListComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.proton.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListComponentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * List deployments. You can filter the result list by environment, service, or a single service instance.
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List deployments. You can filter the result list by environment, service, or a single service instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListDeploymentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.proton.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.proton.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        return new ListDeploymentsPublisher(this, listDeploymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.proton.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.proton.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListDeploymentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * View a list of environment account connections.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param listEnvironmentAccountConnectionsRequest
     * @return A Java Future containing the result of the ListEnvironmentAccountConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentAccountConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentAccountConnectionsResponse> listEnvironmentAccountConnections(
            ListEnvironmentAccountConnectionsRequest listEnvironmentAccountConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View a list of environment account connections.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentAccountConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentAccountConnectionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentAccountConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEnvironmentAccountConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentAccountConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentAccountConnectionsResponse> listEnvironmentAccountConnections(
            Consumer<ListEnvironmentAccountConnectionsRequest.Builder> listEnvironmentAccountConnectionsRequest) {
        return listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsRequest.builder()
                .applyMutation(listEnvironmentAccountConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentAccountConnections(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsPublisher publisher = client.listEnvironmentAccountConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsPublisher publisher = client.listEnvironmentAccountConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentAccountConnections(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentAccountConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentAccountConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentAccountConnectionsPublisher listEnvironmentAccountConnectionsPaginator(
            ListEnvironmentAccountConnectionsRequest listEnvironmentAccountConnectionsRequest) {
        return new ListEnvironmentAccountConnectionsPublisher(this, listEnvironmentAccountConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentAccountConnections(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsPublisher publisher = client.listEnvironmentAccountConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsPublisher publisher = client.listEnvironmentAccountConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentAccountConnections(software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentAccountConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentAccountConnectionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentAccountConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentAccountConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentAccountConnectionsPublisher listEnvironmentAccountConnectionsPaginator(
            Consumer<ListEnvironmentAccountConnectionsRequest.Builder> listEnvironmentAccountConnectionsRequest) {
        return listEnvironmentAccountConnectionsPaginator(ListEnvironmentAccountConnectionsRequest.builder()
                .applyMutation(listEnvironmentAccountConnectionsRequest).build());
    }

    /**
     * <p>
     * List the infrastructure as code outputs for your environment.
     * </p>
     *
     * @param listEnvironmentOutputsRequest
     * @return A Java Future containing the result of the ListEnvironmentOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentOutputsResponse> listEnvironmentOutputs(
            ListEnvironmentOutputsRequest listEnvironmentOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the infrastructure as code outputs for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentOutputsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentOutputsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironmentOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentOutputsResponse> listEnvironmentOutputs(
            Consumer<ListEnvironmentOutputsRequest.Builder> listEnvironmentOutputsRequest) {
        return listEnvironmentOutputs(ListEnvironmentOutputsRequest.builder().applyMutation(listEnvironmentOutputsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentOutputs(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsPublisher publisher = client.listEnvironmentOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsPublisher publisher = client.listEnvironmentOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentOutputs(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEnvironmentOutputsPublisher listEnvironmentOutputsPaginator(
            ListEnvironmentOutputsRequest listEnvironmentOutputsRequest) {
        return new ListEnvironmentOutputsPublisher(this, listEnvironmentOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentOutputs(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsPublisher publisher = client.listEnvironmentOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsPublisher publisher = client.listEnvironmentOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentOutputs(software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentOutputsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentOutputsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEnvironmentOutputsPublisher listEnvironmentOutputsPaginator(
            Consumer<ListEnvironmentOutputsRequest.Builder> listEnvironmentOutputsRequest) {
        return listEnvironmentOutputsPaginator(ListEnvironmentOutputsRequest.builder()
                .applyMutation(listEnvironmentOutputsRequest).build());
    }

    /**
     * <p>
     * List the provisioned resources for your environment.
     * </p>
     *
     * @param listEnvironmentProvisionedResourcesRequest
     * @return A Java Future containing the result of the ListEnvironmentProvisionedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProvisionedResourcesResponse> listEnvironmentProvisionedResources(
            ListEnvironmentProvisionedResourcesRequest listEnvironmentProvisionedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the provisioned resources for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProvisionedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEnvironmentProvisionedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProvisionedResourcesResponse> listEnvironmentProvisionedResources(
            Consumer<ListEnvironmentProvisionedResourcesRequest.Builder> listEnvironmentProvisionedResourcesRequest) {
        return listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesRequest.builder()
                .applyMutation(listEnvironmentProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProvisionedResources(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesPublisher publisher = client.listEnvironmentProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesPublisher publisher = client.listEnvironmentProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProvisionedResources(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentProvisionedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProvisionedResourcesPublisher listEnvironmentProvisionedResourcesPaginator(
            ListEnvironmentProvisionedResourcesRequest listEnvironmentProvisionedResourcesRequest) {
        return new ListEnvironmentProvisionedResourcesPublisher(this, listEnvironmentProvisionedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProvisionedResources(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesPublisher publisher = client.listEnvironmentProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesPublisher publisher = client.listEnvironmentProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProvisionedResources(software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProvisionedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProvisionedResourcesPublisher listEnvironmentProvisionedResourcesPaginator(
            Consumer<ListEnvironmentProvisionedResourcesRequest.Builder> listEnvironmentProvisionedResourcesRequest) {
        return listEnvironmentProvisionedResourcesPaginator(ListEnvironmentProvisionedResourcesRequest.builder()
                .applyMutation(listEnvironmentProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * List major or minor versions of an environment template with detail data.
     * </p>
     *
     * @param listEnvironmentTemplateVersionsRequest
     * @return A Java Future containing the result of the ListEnvironmentTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentTemplateVersionsResponse> listEnvironmentTemplateVersions(
            ListEnvironmentTemplateVersionsRequest listEnvironmentTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List major or minor versions of an environment template with detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEnvironmentTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentTemplateVersionsResponse> listEnvironmentTemplateVersions(
            Consumer<ListEnvironmentTemplateVersionsRequest.Builder> listEnvironmentTemplateVersionsRequest) {
        return listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsRequest.builder()
                .applyMutation(listEnvironmentTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentTemplateVersions(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsPublisher publisher = client.listEnvironmentTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsPublisher publisher = client.listEnvironmentTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentTemplateVersions(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentTemplateVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentTemplateVersionsPublisher listEnvironmentTemplateVersionsPaginator(
            ListEnvironmentTemplateVersionsRequest listEnvironmentTemplateVersionsRequest) {
        return new ListEnvironmentTemplateVersionsPublisher(this, listEnvironmentTemplateVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentTemplateVersions(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsPublisher publisher = client.listEnvironmentTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsPublisher publisher = client.listEnvironmentTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentTemplateVersions(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnvironmentTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentTemplateVersionsPublisher listEnvironmentTemplateVersionsPaginator(
            Consumer<ListEnvironmentTemplateVersionsRequest.Builder> listEnvironmentTemplateVersionsRequest) {
        return listEnvironmentTemplateVersionsPaginator(ListEnvironmentTemplateVersionsRequest.builder()
                .applyMutation(listEnvironmentTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * List environment templates.
     * </p>
     *
     * @param listEnvironmentTemplatesRequest
     * @return A Java Future containing the result of the ListEnvironmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentTemplatesResponse> listEnvironmentTemplates(
            ListEnvironmentTemplatesRequest listEnvironmentTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List environment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentTemplatesResponse> listEnvironmentTemplates(
            Consumer<ListEnvironmentTemplatesRequest.Builder> listEnvironmentTemplatesRequest) {
        return listEnvironmentTemplates(ListEnvironmentTemplatesRequest.builder().applyMutation(listEnvironmentTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentTemplates(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesPublisher publisher = client.listEnvironmentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesPublisher publisher = client.listEnvironmentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentTemplates(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentTemplatesPublisher listEnvironmentTemplatesPaginator(
            ListEnvironmentTemplatesRequest listEnvironmentTemplatesRequest) {
        return new ListEnvironmentTemplatesPublisher(this, listEnvironmentTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentTemplates(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesPublisher publisher = client.listEnvironmentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesPublisher publisher = client.listEnvironmentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentTemplates(software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentTemplatesPublisher listEnvironmentTemplatesPaginator(
            Consumer<ListEnvironmentTemplatesRequest.Builder> listEnvironmentTemplatesRequest) {
        return listEnvironmentTemplatesPaginator(ListEnvironmentTemplatesRequest.builder()
                .applyMutation(listEnvironmentTemplatesRequest).build());
    }

    /**
     * <p>
     * List environments with detail data summaries.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List environments with detail data summaries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        return new ListEnvironmentsPublisher(this, listEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * List linked repositories with detail data.
     * </p>
     *
     * @param listRepositoriesRequest
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List linked repositories with detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListRepositoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(
            Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositories(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.proton.model.ListRepositoriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.proton.model.ListRepositoriesRequest)} operation.</b>
     * </p>
     *
     * @param listRepositoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) {
        return new ListRepositoriesPublisher(this, listRepositoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.proton.model.ListRepositoriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.proton.model.ListRepositoriesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListRepositoriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositoriesPaginator(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * List repository sync definitions with detail data.
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     * @return A Java Future containing the result of the ListRepositorySyncDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositorySyncDefinitionsResponse> listRepositorySyncDefinitions(
            ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List repository sync definitions with detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositorySyncDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRepositorySyncDefinitionsRequest#builder()}
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRepositorySyncDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositorySyncDefinitionsResponse> listRepositorySyncDefinitions(
            Consumer<ListRepositorySyncDefinitionsRequest.Builder> listRepositorySyncDefinitionsRequest) {
        return listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest.builder()
                .applyMutation(listRepositorySyncDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositorySyncDefinitions(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsPublisher publisher = client.listRepositorySyncDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsPublisher publisher = client.listRepositorySyncDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositorySyncDefinitions(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositorySyncDefinitionsPublisher listRepositorySyncDefinitionsPaginator(
            ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) {
        return new ListRepositorySyncDefinitionsPublisher(this, listRepositorySyncDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositorySyncDefinitions(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsPublisher publisher = client.listRepositorySyncDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsPublisher publisher = client.listRepositorySyncDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositorySyncDefinitions(software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositorySyncDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRepositorySyncDefinitionsRequest#builder()}
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositorySyncDefinitionsPublisher listRepositorySyncDefinitionsPaginator(
            Consumer<ListRepositorySyncDefinitionsRequest.Builder> listRepositorySyncDefinitionsRequest) {
        return listRepositorySyncDefinitionsPaginator(ListRepositorySyncDefinitionsRequest.builder()
                .applyMutation(listRepositorySyncDefinitionsRequest).build());
    }

    /**
     * <p>
     * Get a list service of instance Infrastructure as Code (IaC) outputs.
     * </p>
     *
     * @param listServiceInstanceOutputsRequest
     * @return A Java Future containing the result of the ListServiceInstanceOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceInstanceOutputsResponse> listServiceInstanceOutputs(
            ListServiceInstanceOutputsRequest listServiceInstanceOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list service of instance Infrastructure as Code (IaC) outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceInstanceOutputsRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceInstanceOutputsRequest#builder()}
     * </p>
     *
     * @param listServiceInstanceOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceInstanceOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceInstanceOutputsResponse> listServiceInstanceOutputs(
            Consumer<ListServiceInstanceOutputsRequest.Builder> listServiceInstanceOutputsRequest) {
        return listServiceInstanceOutputs(ListServiceInstanceOutputsRequest.builder()
                .applyMutation(listServiceInstanceOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstanceOutputs(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsPublisher publisher = client.listServiceInstanceOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsPublisher publisher = client.listServiceInstanceOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstanceOutputs(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceInstanceOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceInstanceOutputsPublisher listServiceInstanceOutputsPaginator(
            ListServiceInstanceOutputsRequest listServiceInstanceOutputsRequest) {
        return new ListServiceInstanceOutputsPublisher(this, listServiceInstanceOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstanceOutputs(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsPublisher publisher = client.listServiceInstanceOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsPublisher publisher = client.listServiceInstanceOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstanceOutputs(software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceInstanceOutputsRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceInstanceOutputsRequest#builder()}
     * </p>
     *
     * @param listServiceInstanceOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceInstanceOutputsPublisher listServiceInstanceOutputsPaginator(
            Consumer<ListServiceInstanceOutputsRequest.Builder> listServiceInstanceOutputsRequest) {
        return listServiceInstanceOutputsPaginator(ListServiceInstanceOutputsRequest.builder()
                .applyMutation(listServiceInstanceOutputsRequest).build());
    }

    /**
     * <p>
     * List provisioned resources for a service instance with details.
     * </p>
     *
     * @param listServiceInstanceProvisionedResourcesRequest
     * @return A Java Future containing the result of the ListServiceInstanceProvisionedResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceInstanceProvisionedResourcesResponse> listServiceInstanceProvisionedResources(
            ListServiceInstanceProvisionedResourcesRequest listServiceInstanceProvisionedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List provisioned resources for a service instance with details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceInstanceProvisionedResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceInstanceProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listServiceInstanceProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceInstanceProvisionedResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceInstanceProvisionedResourcesResponse> listServiceInstanceProvisionedResources(
            Consumer<ListServiceInstanceProvisionedResourcesRequest.Builder> listServiceInstanceProvisionedResourcesRequest) {
        return listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesRequest.builder()
                .applyMutation(listServiceInstanceProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstanceProvisionedResources(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesPublisher publisher = client.listServiceInstanceProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesPublisher publisher = client.listServiceInstanceProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstanceProvisionedResources(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceInstanceProvisionedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceInstanceProvisionedResourcesPublisher listServiceInstanceProvisionedResourcesPaginator(
            ListServiceInstanceProvisionedResourcesRequest listServiceInstanceProvisionedResourcesRequest) {
        return new ListServiceInstanceProvisionedResourcesPublisher(this, listServiceInstanceProvisionedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstanceProvisionedResources(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesPublisher publisher = client.listServiceInstanceProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesPublisher publisher = client.listServiceInstanceProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstanceProvisionedResources(software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceInstanceProvisionedResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceInstanceProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listServiceInstanceProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstanceProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceInstanceProvisionedResourcesPublisher listServiceInstanceProvisionedResourcesPaginator(
            Consumer<ListServiceInstanceProvisionedResourcesRequest.Builder> listServiceInstanceProvisionedResourcesRequest) {
        return listServiceInstanceProvisionedResourcesPaginator(ListServiceInstanceProvisionedResourcesRequest.builder()
                .applyMutation(listServiceInstanceProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * List service instances with summary data. This action lists service instances of all services in the Amazon Web
     * Services account.
     * </p>
     *
     * @param listServiceInstancesRequest
     * @return A Java Future containing the result of the ListServiceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceInstancesResponse> listServiceInstances(
            ListServiceInstancesRequest listServiceInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List service instances with summary data. This action lists service instances of all services in the Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceInstancesRequest#builder()}
     * </p>
     *
     * @param listServiceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceInstancesResponse> listServiceInstances(
            Consumer<ListServiceInstancesRequest.Builder> listServiceInstancesRequest) {
        return listServiceInstances(ListServiceInstancesRequest.builder().applyMutation(listServiceInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstances(software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstancesPublisher publisher = client.listServiceInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstancesPublisher publisher = client.listServiceInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstances(software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceInstancesPublisher listServiceInstancesPaginator(ListServiceInstancesRequest listServiceInstancesRequest) {
        return new ListServiceInstancesPublisher(this, listServiceInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceInstances(software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstancesPublisher publisher = client.listServiceInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceInstancesPublisher publisher = client.listServiceInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceInstances(software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceInstancesRequest#builder()}
     * </p>
     *
     * @param listServiceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceInstancesPublisher listServiceInstancesPaginator(
            Consumer<ListServiceInstancesRequest.Builder> listServiceInstancesRequest) {
        return listServiceInstancesPaginator(ListServiceInstancesRequest.builder().applyMutation(listServiceInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Get a list of service pipeline Infrastructure as Code (IaC) outputs.
     * </p>
     *
     * @param listServicePipelineOutputsRequest
     * @return A Java Future containing the result of the ListServicePipelineOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServicePipelineOutputsResponse> listServicePipelineOutputs(
            ListServicePipelineOutputsRequest listServicePipelineOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of service pipeline Infrastructure as Code (IaC) outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicePipelineOutputsRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicePipelineOutputsRequest#builder()}
     * </p>
     *
     * @param listServicePipelineOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServicePipelineOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServicePipelineOutputsResponse> listServicePipelineOutputs(
            Consumer<ListServicePipelineOutputsRequest.Builder> listServicePipelineOutputsRequest) {
        return listServicePipelineOutputs(ListServicePipelineOutputsRequest.builder()
                .applyMutation(listServicePipelineOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicePipelineOutputs(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsPublisher publisher = client.listServicePipelineOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsPublisher publisher = client.listServicePipelineOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePipelineOutputs(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServicePipelineOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePipelineOutputsPublisher listServicePipelineOutputsPaginator(
            ListServicePipelineOutputsRequest listServicePipelineOutputsRequest) {
        return new ListServicePipelineOutputsPublisher(this, listServicePipelineOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicePipelineOutputs(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsPublisher publisher = client.listServicePipelineOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsPublisher publisher = client.listServicePipelineOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePipelineOutputs(software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicePipelineOutputsRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicePipelineOutputsRequest#builder()}
     * </p>
     *
     * @param listServicePipelineOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePipelineOutputsPublisher listServicePipelineOutputsPaginator(
            Consumer<ListServicePipelineOutputsRequest.Builder> listServicePipelineOutputsRequest) {
        return listServicePipelineOutputsPaginator(ListServicePipelineOutputsRequest.builder()
                .applyMutation(listServicePipelineOutputsRequest).build());
    }

    /**
     * <p>
     * List provisioned resources for a service and pipeline with details.
     * </p>
     *
     * @param listServicePipelineProvisionedResourcesRequest
     * @return A Java Future containing the result of the ListServicePipelineProvisionedResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServicePipelineProvisionedResourcesResponse> listServicePipelineProvisionedResources(
            ListServicePipelineProvisionedResourcesRequest listServicePipelineProvisionedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List provisioned resources for a service and pipeline with details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServicePipelineProvisionedResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListServicePipelineProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listServicePipelineProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServicePipelineProvisionedResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServicePipelineProvisionedResourcesResponse> listServicePipelineProvisionedResources(
            Consumer<ListServicePipelineProvisionedResourcesRequest.Builder> listServicePipelineProvisionedResourcesRequest) {
        return listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesRequest.builder()
                .applyMutation(listServicePipelineProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicePipelineProvisionedResources(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesPublisher publisher = client.listServicePipelineProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesPublisher publisher = client.listServicePipelineProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePipelineProvisionedResources(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServicePipelineProvisionedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePipelineProvisionedResourcesPublisher listServicePipelineProvisionedResourcesPaginator(
            ListServicePipelineProvisionedResourcesRequest listServicePipelineProvisionedResourcesRequest) {
        return new ListServicePipelineProvisionedResourcesPublisher(this, listServicePipelineProvisionedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicePipelineProvisionedResources(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesPublisher publisher = client.listServicePipelineProvisionedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesPublisher publisher = client.listServicePipelineProvisionedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePipelineProvisionedResources(software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServicePipelineProvisionedResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListServicePipelineProvisionedResourcesRequest#builder()}
     * </p>
     *
     * @param listServicePipelineProvisionedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServicePipelineProvisionedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePipelineProvisionedResourcesPublisher listServicePipelineProvisionedResourcesPaginator(
            Consumer<ListServicePipelineProvisionedResourcesRequest.Builder> listServicePipelineProvisionedResourcesRequest) {
        return listServicePipelineProvisionedResourcesPaginator(ListServicePipelineProvisionedResourcesRequest.builder()
                .applyMutation(listServicePipelineProvisionedResourcesRequest).build());
    }

    /**
     * <p>
     * List major or minor versions of a service template with detail data.
     * </p>
     *
     * @param listServiceTemplateVersionsRequest
     * @return A Java Future containing the result of the ListServiceTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceTemplateVersionsResponse> listServiceTemplateVersions(
            ListServiceTemplateVersionsRequest listServiceTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List major or minor versions of a service template with detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listServiceTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListServiceTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceTemplateVersionsResponse> listServiceTemplateVersions(
            Consumer<ListServiceTemplateVersionsRequest.Builder> listServiceTemplateVersionsRequest) {
        return listServiceTemplateVersions(ListServiceTemplateVersionsRequest.builder()
                .applyMutation(listServiceTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceTemplateVersions(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsPublisher publisher = client.listServiceTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsPublisher publisher = client.listServiceTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceTemplateVersions(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceTemplateVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceTemplateVersionsPublisher listServiceTemplateVersionsPaginator(
            ListServiceTemplateVersionsRequest listServiceTemplateVersionsRequest) {
        return new ListServiceTemplateVersionsPublisher(this, listServiceTemplateVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceTemplateVersions(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsPublisher publisher = client.listServiceTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsPublisher publisher = client.listServiceTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceTemplateVersions(software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listServiceTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceTemplateVersionsPublisher listServiceTemplateVersionsPaginator(
            Consumer<ListServiceTemplateVersionsRequest.Builder> listServiceTemplateVersionsRequest) {
        return listServiceTemplateVersionsPaginator(ListServiceTemplateVersionsRequest.builder()
                .applyMutation(listServiceTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * List service templates with detail data.
     * </p>
     *
     * @param listServiceTemplatesRequest
     * @return A Java Future containing the result of the ListServiceTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceTemplatesResponse> listServiceTemplates(
            ListServiceTemplatesRequest listServiceTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List service templates with detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceTemplatesRequest#builder()}
     * </p>
     *
     * @param listServiceTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceTemplatesResponse> listServiceTemplates(
            Consumer<ListServiceTemplatesRequest.Builder> listServiceTemplatesRequest) {
        return listServiceTemplates(ListServiceTemplatesRequest.builder().applyMutation(listServiceTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceTemplates(software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesPublisher publisher = client.listServiceTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesPublisher publisher = client.listServiceTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceTemplates(software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceTemplatesPublisher listServiceTemplatesPaginator(ListServiceTemplatesRequest listServiceTemplatesRequest) {
        return new ListServiceTemplatesPublisher(this, listServiceTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceTemplates(software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesPublisher publisher = client.listServiceTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesPublisher publisher = client.listServiceTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceTemplates(software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceTemplatesRequest#builder()}
     * </p>
     *
     * @param listServiceTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServiceTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceTemplatesPublisher listServiceTemplatesPaginator(
            Consumer<ListServiceTemplatesRequest.Builder> listServiceTemplatesRequest) {
        return listServiceTemplatesPaginator(ListServiceTemplatesRequest.builder().applyMutation(listServiceTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * List services with summaries of detail data.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List services with summaries of detail data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.proton.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.proton.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        return new ListServicesPublisher(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.proton.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.proton.model.ListServicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListServicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * List tags for a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.proton.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param notifyResourceDeploymentStatusChangeRequest
     * @return A Java Future containing the result of the NotifyResourceDeploymentStatusChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.NotifyResourceDeploymentStatusChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/NotifyResourceDeploymentStatusChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyResourceDeploymentStatusChangeResponse> notifyResourceDeploymentStatusChange(
            NotifyResourceDeploymentStatusChangeRequest notifyResourceDeploymentStatusChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self"
     * >Self-managed provisioning</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyResourceDeploymentStatusChangeRequest.Builder} avoiding the need to create one manually via
     * {@link NotifyResourceDeploymentStatusChangeRequest#builder()}
     * </p>
     *
     * @param notifyResourceDeploymentStatusChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the NotifyResourceDeploymentStatusChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.NotifyResourceDeploymentStatusChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/NotifyResourceDeploymentStatusChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyResourceDeploymentStatusChangeResponse> notifyResourceDeploymentStatusChange(
            Consumer<NotifyResourceDeploymentStatusChangeRequest.Builder> notifyResourceDeploymentStatusChangeRequest) {
        return notifyResourceDeploymentStatusChange(NotifyResourceDeploymentStatusChangeRequest.builder()
                .applyMutation(notifyResourceDeploymentStatusChangeRequest).build());
    }

    /**
     * <p>
     * In a management account, reject an environment account connection from another environment account.
     * </p>
     * <p>
     * After you reject an environment account connection request, you <i>can't</i> accept or use the rejected
     * environment account connection.
     * </p>
     * <p>
     * You <i>can’t</i> reject an environment account connection that's connected to an environment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param rejectEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the RejectEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.RejectEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/RejectEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectEnvironmentAccountConnectionResponse> rejectEnvironmentAccountConnection(
            RejectEnvironmentAccountConnectionRequest rejectEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In a management account, reject an environment account connection from another environment account.
     * </p>
     * <p>
     * After you reject an environment account connection request, you <i>can't</i> accept or use the rejected
     * environment account connection.
     * </p>
     * <p>
     * You <i>can’t</i> reject an environment account connection that's connected to an environment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link RejectEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param rejectEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RejectEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.RejectEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/RejectEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectEnvironmentAccountConnectionResponse> rejectEnvironmentAccountConnection(
            Consumer<RejectEnvironmentAccountConnectionRequest.Builder> rejectEnvironmentAccountConnectionRequest) {
        return rejectEnvironmentAccountConnection(RejectEnvironmentAccountConnectionRequest.builder()
                .applyMutation(rejectEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update Proton settings that are used for multiple services in the Amazon Web Services account.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update Proton settings that are used for multiple services in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccountSettingsRequest#builder()}
     * </p>
     *
     * @param updateAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            Consumer<UpdateAccountSettingsRequest.Builder> updateAccountSettingsRequest) {
        return updateAccountSettings(UpdateAccountSettingsRequest.builder().applyMutation(updateAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Update a component.
     * </p>
     * <p>
     * There are a few modes for updating a component. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <note>
     * <p>
     * You can't update a component while its deployment status, or the deployment status of a service instance attached
     * to it, is <code>IN_PROGRESS</code>.
     * </p>
     * </note>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     *
     * @param updateComponentRequest
     * @return A Java Future containing the result of the UpdateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateComponentResponse> updateComponent(UpdateComponentRequest updateComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a component.
     * </p>
     * <p>
     * There are a few modes for updating a component. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <note>
     * <p>
     * You can't update a component while its deployment status, or the deployment status of a service instance attached
     * to it, is <code>IN_PROGRESS</code>.
     * </p>
     * </note>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateComponentRequest#builder()}
     * </p>
     *
     * @param updateComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateComponentResponse> updateComponent(
            Consumer<UpdateComponentRequest.Builder> updateComponentRequest) {
        return updateComponent(UpdateComponentRequest.builder().applyMutation(updateComponentRequest).build());
    }

    /**
     * <p>
     * Update an environment.
     * </p>
     * <p>
     * If the environment is associated with an environment account connection, <i>don't</i> update or include the
     * <code>protonServiceRoleArn</code> and <code>provisioningRepository</code> parameter to update or connect to an
     * environment account connection.
     * </p>
     * <p>
     * You can only update to a new environment account connection if that connection was created in the same
     * environment account that the current environment account connection was created in. The account connection must
     * also be associated with the current environment.
     * </p>
     * <p>
     * If the environment <i>isn't</i> associated with an environment account connection, <i>don't</i> update or include
     * the <code>environmentAccountConnectionId</code> parameter. You <i>can't</i> update or connect the environment to
     * an environment account connection if it <i>isn't</i> already associated with an environment connection.
     * </p>
     * <p>
     * You can update either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code>
     * parameter and value. You can’t update both.
     * </p>
     * <p>
     * If the environment was configured for Amazon Web Services-managed provisioning, omit the
     * <code>provisioningRepository</code> parameter.
     * </p>
     * <p>
     * If the environment was configured for self-managed provisioning, specify the <code>provisioningRepository</code>
     * parameter and omit the <code>protonServiceRoleArn</code> and <code>environmentAccountConnectionId</code>
     * parameters.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html">Provisioning methods</a> in
     * the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include minor or major version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of
     * the current major version in use, by default. You can also specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor
     * version of the current template, by default. You can also specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateEnvironmentRequest
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an environment.
     * </p>
     * <p>
     * If the environment is associated with an environment account connection, <i>don't</i> update or include the
     * <code>protonServiceRoleArn</code> and <code>provisioningRepository</code> parameter to update or connect to an
     * environment account connection.
     * </p>
     * <p>
     * You can only update to a new environment account connection if that connection was created in the same
     * environment account that the current environment account connection was created in. The account connection must
     * also be associated with the current environment.
     * </p>
     * <p>
     * If the environment <i>isn't</i> associated with an environment account connection, <i>don't</i> update or include
     * the <code>environmentAccountConnectionId</code> parameter. You <i>can't</i> update or connect the environment to
     * an environment account connection if it <i>isn't</i> already associated with an environment connection.
     * </p>
     * <p>
     * You can update either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code>
     * parameter and value. You can’t update both.
     * </p>
     * <p>
     * If the environment was configured for Amazon Web Services-managed provisioning, omit the
     * <code>provisioningRepository</code> parameter.
     * </p>
     * <p>
     * If the environment was configured for self-managed provisioning, specify the <code>provisioningRepository</code>
     * parameter and omit the <code>protonServiceRoleArn</code> and <code>environmentAccountConnectionId</code>
     * parameters.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html">Provisioning methods</a> in
     * the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include minor or major version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of
     * the current major version in use, by default. You can also specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor
     * version of the current template, by default. You can also specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * In an environment account, update an environment account connection to use a new IAM role.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     *
     * @param updateEnvironmentAccountConnectionRequest
     * @return A Java Future containing the result of the UpdateEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentAccountConnectionResponse> updateEnvironmentAccountConnection(
            UpdateEnvironmentAccountConnectionRequest updateEnvironmentAccountConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In an environment account, update an environment account connection to use a new IAM role.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentAccountConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEnvironmentAccountConnectionRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentAccountConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEnvironmentAccountConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentAccountConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentAccountConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentAccountConnectionResponse> updateEnvironmentAccountConnection(
            Consumer<UpdateEnvironmentAccountConnectionRequest.Builder> updateEnvironmentAccountConnectionRequest) {
        return updateEnvironmentAccountConnection(UpdateEnvironmentAccountConnectionRequest.builder()
                .applyMutation(updateEnvironmentAccountConnectionRequest).build());
    }

    /**
     * <p>
     * Update an environment template.
     * </p>
     *
     * @param updateEnvironmentTemplateRequest
     * @return A Java Future containing the result of the UpdateEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentTemplateResponse> updateEnvironmentTemplate(
            UpdateEnvironmentTemplateRequest updateEnvironmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an environment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEnvironmentTemplateRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnvironmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentTemplateResponse> updateEnvironmentTemplate(
            Consumer<UpdateEnvironmentTemplateRequest.Builder> updateEnvironmentTemplateRequest) {
        return updateEnvironmentTemplate(UpdateEnvironmentTemplateRequest.builder()
                .applyMutation(updateEnvironmentTemplateRequest).build());
    }

    /**
     * <p>
     * Update a major or minor version of an environment template.
     * </p>
     *
     * @param updateEnvironmentTemplateVersionRequest
     * @return A Java Future containing the result of the UpdateEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentTemplateVersionResponse> updateEnvironmentTemplateVersion(
            UpdateEnvironmentTemplateVersionRequest updateEnvironmentTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a major or minor version of an environment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEnvironmentTemplateVersionRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEnvironmentTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateEnvironmentTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentTemplateVersionResponse> updateEnvironmentTemplateVersion(
            Consumer<UpdateEnvironmentTemplateVersionRequest.Builder> updateEnvironmentTemplateVersionRequest) {
        return updateEnvironmentTemplateVersion(UpdateEnvironmentTemplateVersionRequest.builder()
                .applyMutation(updateEnvironmentTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Edit a service description or use a spec to add and delete service instances.
     * </p>
     * <note>
     * <p>
     * Existing service instances and the service pipeline <i>can't</i> be edited using this API. They can only be
     * deleted.
     * </p>
     * </note>
     * <p>
     * Use the <code>description</code> parameter to modify the description.
     * </p>
     * <p>
     * Edit the <code>spec</code> parameter to add or delete instances.
     * </p>
     * <note>
     * <p>
     * You can't delete a service instance (remove it from the spec) if it has an attached component.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note>
     *
     * @param updateServiceRequest
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Edit a service description or use a spec to add and delete service instances.
     * </p>
     * <note>
     * <p>
     * Existing service instances and the service pipeline <i>can't</i> be edited using this API. They can only be
     * deleted.
     * </p>
     * </note>
     * <p>
     * Use the <code>description</code> parameter to modify the description.
     * </p>
     * <p>
     * Edit the <code>spec</code> parameter to add or delete instances.
     * </p>
     * <note>
     * <p>
     * You can't delete a service instance (remove it from the spec) if it has an attached component.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServiceRequest#builder()}
     * </p>
     *
     * @param updateServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException A quota was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html">Proton Quotas</a> in the
     *         <i>Proton User Guide</i>.</li>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) {
        return updateService(UpdateServiceRequest.builder().applyMutation(updateServiceRequest).build());
    }

    /**
     * <p>
     * Update a service instance.
     * </p>
     * <p>
     * There are a few modes for updating a service instance. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <note>
     * <p>
     * You can't update a service instance while its deployment status, or the deployment status of a component attached
     * to it, is <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note>
     *
     * @param updateServiceInstanceRequest
     * @return A Java Future containing the result of the UpdateServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceInstanceResponse> updateServiceInstance(
            UpdateServiceInstanceRequest updateServiceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a service instance.
     * </p>
     * <p>
     * There are a few modes for updating a service instance. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <note>
     * <p>
     * You can't update a service instance while its deployment status, or the deployment status of a component attached
     * to it, is <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceInstanceRequest#builder()}
     * </p>
     *
     * @param updateServiceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceInstanceResponse> updateServiceInstance(
            Consumer<UpdateServiceInstanceRequest.Builder> updateServiceInstanceRequest) {
        return updateServiceInstance(UpdateServiceInstanceRequest.builder().applyMutation(updateServiceInstanceRequest).build());
    }

    /**
     * <p>
     * Update the service pipeline.
     * </p>
     * <p>
     * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version
     * of the current major version in use, by default. You can specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
     * minor version of the current template by default. You can specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateServicePipelineRequest
     * @return A Java Future containing the result of the UpdateServicePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServicePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServicePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServicePipelineResponse> updateServicePipeline(
            UpdateServicePipelineRequest updateServicePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the service pipeline.
     * </p>
     * <p>
     * There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.
     * </p>
     * <dl>
     * <dt/>
     * <dd>
     * <p>
     * <code>NONE</code>
     * </p>
     * <p>
     * In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>CURRENT_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested
     * parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this
     * <code>deployment-type</code>.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MINOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version
     * of the current major version in use, by default. You can specify a different minor version of the current major
     * version in use.
     * </p>
     * </dd>
     * <dt/>
     * <dd>
     * <p>
     * <code>MAJOR_VERSION</code>
     * </p>
     * <p>
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and
     * minor version of the current template by default. You can specify a different major version that's higher than
     * the major version in use and a minor version.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServicePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServicePipelineRequest#builder()}
     * </p>
     *
     * @param updateServicePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServicePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServicePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServicePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServicePipelineResponse> updateServicePipeline(
            Consumer<UpdateServicePipelineRequest.Builder> updateServicePipelineRequest) {
        return updateServicePipeline(UpdateServicePipelineRequest.builder().applyMutation(updateServicePipelineRequest).build());
    }

    /**
     * <p>
     * Update the service sync blocker by resolving it.
     * </p>
     *
     * @param updateServiceSyncBlockerRequest
     * @return A Java Future containing the result of the UpdateServiceSyncBlocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSyncBlockerResponse> updateServiceSyncBlocker(
            UpdateServiceSyncBlockerRequest updateServiceSyncBlockerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the service sync blocker by resolving it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSyncBlockerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateServiceSyncBlockerRequest#builder()}
     * </p>
     *
     * @param updateServiceSyncBlockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceSyncBlocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSyncBlockerResponse> updateServiceSyncBlocker(
            Consumer<UpdateServiceSyncBlockerRequest.Builder> updateServiceSyncBlockerRequest) {
        return updateServiceSyncBlocker(UpdateServiceSyncBlockerRequest.builder().applyMutation(updateServiceSyncBlockerRequest)
                .build());
    }

    /**
     * <p>
     * Update the Proton Ops config file.
     * </p>
     *
     * @param updateServiceSyncConfigRequest
     * @return A Java Future containing the result of the UpdateServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSyncConfigResponse> updateServiceSyncConfig(
            UpdateServiceSyncConfigRequest updateServiceSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the Proton Ops config file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateServiceSyncConfigRequest#builder()}
     * </p>
     *
     * @param updateServiceSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSyncConfigResponse> updateServiceSyncConfig(
            Consumer<UpdateServiceSyncConfigRequest.Builder> updateServiceSyncConfigRequest) {
        return updateServiceSyncConfig(UpdateServiceSyncConfigRequest.builder().applyMutation(updateServiceSyncConfigRequest)
                .build());
    }

    /**
     * <p>
     * Update a service template.
     * </p>
     *
     * @param updateServiceTemplateRequest
     * @return A Java Future containing the result of the UpdateServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceTemplateResponse> updateServiceTemplate(
            UpdateServiceTemplateRequest updateServiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a service template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceTemplateRequest#builder()}
     * </p>
     *
     * @param updateServiceTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceTemplateResponse> updateServiceTemplate(
            Consumer<UpdateServiceTemplateRequest.Builder> updateServiceTemplateRequest) {
        return updateServiceTemplate(UpdateServiceTemplateRequest.builder().applyMutation(updateServiceTemplateRequest).build());
    }

    /**
     * <p>
     * Update a major or minor version of a service template.
     * </p>
     *
     * @param updateServiceTemplateVersionRequest
     * @return A Java Future containing the result of the UpdateServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceTemplateVersionResponse> updateServiceTemplateVersion(
            UpdateServiceTemplateVersionRequest updateServiceTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a major or minor version of a service template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceTemplateVersionRequest#builder()}
     * </p>
     *
     * @param updateServiceTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateServiceTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateServiceTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceTemplateVersionResponse> updateServiceTemplateVersion(
            Consumer<UpdateServiceTemplateVersionRequest.Builder> updateServiceTemplateVersionRequest) {
        return updateServiceTemplateVersion(UpdateServiceTemplateVersionRequest.builder()
                .applyMutation(updateServiceTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Update template sync configuration parameters, except for the <code>templateName</code> and
     * <code>templateType</code>. Repository details (branch, name, and provider) should be of a linked repository. A
     * linked repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     *
     * @param updateTemplateSyncConfigRequest
     * @return A Java Future containing the result of the UpdateTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateSyncConfigResponse> updateTemplateSyncConfig(
            UpdateTemplateSyncConfigRequest updateTemplateSyncConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update template sync configuration parameters, except for the <code>templateName</code> and
     * <code>templateType</code>. Repository details (branch, name, and provider) should be of a linked repository. A
     * linked repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateSyncConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTemplateSyncConfigRequest#builder()}
     * </p>
     *
     * @param updateTemplateSyncConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTemplateSyncConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input is invalid or an out-of-range value was supplied for the input
     *         parameter.</li>
     *         <li>AccessDeniedException There <i>isn't</i> sufficient access for performing this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException The request <i>couldn't</i> be made due to a conflicting operation or resource.</li>
     *         <li>ResourceNotFoundException The requested resource <i>wasn't</i> found.</li>
     *         <li>InternalServerException The request failed to register with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtonException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ProtonAsyncClient.UpdateTemplateSyncConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateTemplateSyncConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateSyncConfigResponse> updateTemplateSyncConfig(
            Consumer<UpdateTemplateSyncConfigRequest.Builder> updateTemplateSyncConfigRequest) {
        return updateTemplateSyncConfig(UpdateTemplateSyncConfigRequest.builder().applyMutation(updateTemplateSyncConfigRequest)
                .build());
    }

    /**
     * Create an instance of {@link ProtonAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ProtonAsyncWaiter}
     */
    default ProtonAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default ProtonServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ProtonAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtonAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtonAsyncClient}.
     */
    static ProtonAsyncClientBuilder builder() {
        return new DefaultProtonAsyncClientBuilder();
    }
}
