/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed data about the current state of the component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentState implements SdkPojo, Serializable, ToCopyableBuilder<ComponentState.Builder, ComponentState> {
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(ComponentState::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ComponentState::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceSpec").getter(getter(ComponentState::serviceSpec)).setter(setter(Builder::serviceSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()).build();

    private static final SdkField<String> TEMPLATE_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateFile").getter(getter(ComponentState::templateFile)).setter(setter(Builder::templateFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_INSTANCE_NAME_FIELD,
            SERVICE_NAME_FIELD, SERVICE_SPEC_FIELD, TEMPLATE_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceInstanceName;

    private final String serviceName;

    private final String serviceSpec;

    private final String templateFile;

    private ComponentState(BuilderImpl builder) {
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
        this.templateFile = builder.templateFile;
    }

    /**
     * <p>
     * The name of the service instance that this component is attached to. Provided when a component is attached to a
     * service instance.
     * </p>
     * 
     * @return The name of the service instance that this component is attached to. Provided when a component is
     *         attached to a service instance.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component is
     * attached to a service instance.
     * </p>
     * 
     * @return The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a
     *         component is attached to a service instance.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The service spec that the component uses to access service inputs. Provided when a component is attached to a
     * service instance.
     * </p>
     * 
     * @return The service spec that the component uses to access service inputs. Provided when a component is attached
     *         to a service instance.
     */
    public final String serviceSpec() {
        return serviceSpec;
    }

    /**
     * <p>
     * The template file used.
     * </p>
     * 
     * @return The template file used.
     */
    public final String templateFile() {
        return templateFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(templateFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentState)) {
            return false;
        }
        ComponentState other = (ComponentState) obj;
        return Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceSpec(), other.serviceSpec())
                && Objects.equals(templateFile(), other.templateFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentState").add("ServiceInstanceName", serviceInstanceName())
                .add("ServiceName", serviceName())
                .add("ServiceSpec", serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateFile", templateFile() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "serviceSpec":
            return Optional.ofNullable(clazz.cast(serviceSpec()));
        case "templateFile":
            return Optional.ofNullable(clazz.cast(templateFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceSpec", SERVICE_SPEC_FIELD);
        map.put("templateFile", TEMPLATE_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentState, T> g) {
        return obj -> g.apply((ComponentState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentState> {
        /**
         * <p>
         * The name of the service instance that this component is attached to. Provided when a component is attached to
         * a service instance.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that this component is attached to. Provided when a component is
         *        attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component
         * is attached to a service instance.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a
         *        component is attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The service spec that the component uses to access service inputs. Provided when a component is attached to a
         * service instance.
         * </p>
         * 
         * @param serviceSpec
         *        The service spec that the component uses to access service inputs. Provided when a component is
         *        attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpec(String serviceSpec);

        /**
         * <p>
         * The template file used.
         * </p>
         * 
         * @param templateFile
         *        The template file used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateFile(String templateFile);
    }

    static final class BuilderImpl implements Builder {
        private String serviceInstanceName;

        private String serviceName;

        private String serviceSpec;

        private String templateFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentState model) {
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
            serviceSpec(model.serviceSpec);
            templateFile(model.templateFile);
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public final String getTemplateFile() {
            return templateFile;
        }

        public final void setTemplateFile(String templateFile) {
            this.templateFile = templateFile;
        }

        @Override
        public final Builder templateFile(String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        @Override
        public ComponentState build() {
            return new ComponentState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
