/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the version of an environment template detail data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentTemplateVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentTemplateVersionSummary.Builder, EnvironmentTemplateVersionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnvironmentTemplateVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EnvironmentTemplateVersionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentTemplateVersionSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(EnvironmentTemplateVersionSummary::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("majorVersion").getter(getter(EnvironmentTemplateVersionSummary::majorVersion))
            .setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()).build();

    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("minorVersion").getter(getter(EnvironmentTemplateVersionSummary::minorVersion))
            .setter(setter(Builder::minorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()).build();

    private static final SdkField<String> RECOMMENDED_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedMinorVersion").getter(getter(EnvironmentTemplateVersionSummary::recommendedMinorVersion))
            .setter(setter(Builder::recommendedMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedMinorVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnvironmentTemplateVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(EnvironmentTemplateVersionSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(EnvironmentTemplateVersionSummary::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, MAJOR_VERSION_FIELD, MINOR_VERSION_FIELD, RECOMMENDED_MINOR_VERSION_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final Instant lastModifiedAt;

    private final String majorVersion;

    private final String minorVersion;

    private final String recommendedMinorVersion;

    private final String status;

    private final String statusMessage;

    private final String templateName;

    private EnvironmentTemplateVersionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.recommendedMinorVersion = builder.recommendedMinorVersion;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the version of an environment template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the version of an environment template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the version of an environment template was created.
     * </p>
     * 
     * @return The time when the version of an environment template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the version of an environment template.
     * </p>
     * 
     * @return A description of the version of an environment template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time when the version of an environment template was last modified.
     * </p>
     * 
     * @return The time when the version of an environment template was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The latest major version that's associated with the version of an environment template.
     * </p>
     * 
     * @return The latest major version that's associated with the version of an environment template.
     */
    public final String majorVersion() {
        return majorVersion;
    }

    /**
     * <p>
     * The version of an environment template.
     * </p>
     * 
     * @return The version of an environment template.
     */
    public final String minorVersion() {
        return minorVersion;
    }

    /**
     * <p>
     * The recommended minor version of the environment template.
     * </p>
     * 
     * @return The recommended minor version of the environment template.
     */
    public final String recommendedMinorVersion() {
        return recommendedMinorVersion;
    }

    /**
     * <p>
     * The status of the version of an environment template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the version of an environment template.
     * @see TemplateVersionStatus
     */
    public final TemplateVersionStatus status() {
        return TemplateVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the version of an environment template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the version of an environment template.
     * @see TemplateVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the version of an environment template.
     * </p>
     * 
     * @return The status message of the version of an environment template.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the environment template.
     * </p>
     * 
     * @return The name of the environment template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentTemplateVersionSummary)) {
            return false;
        }
        EnvironmentTemplateVersionSummary other = (EnvironmentTemplateVersionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(majorVersion(), other.majorVersion()) && Objects.equals(minorVersion(), other.minorVersion())
                && Objects.equals(recommendedMinorVersion(), other.recommendedMinorVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentTemplateVersionSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastModifiedAt", lastModifiedAt()).add("MajorVersion", majorVersion()).add("MinorVersion", minorVersion())
                .add("RecommendedMinorVersion", recommendedMinorVersion()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "majorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        case "minorVersion":
            return Optional.ofNullable(clazz.cast(minorVersion()));
        case "recommendedMinorVersion":
            return Optional.ofNullable(clazz.cast(recommendedMinorVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("majorVersion", MAJOR_VERSION_FIELD);
        map.put("minorVersion", MINOR_VERSION_FIELD);
        map.put("recommendedMinorVersion", RECOMMENDED_MINOR_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentTemplateVersionSummary, T> g) {
        return obj -> g.apply((EnvironmentTemplateVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentTemplateVersionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the version of an environment template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the version of an environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the version of an environment template was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the version of an environment template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the version of an environment template.
         * </p>
         * 
         * @param description
         *        A description of the version of an environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time when the version of an environment template was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the version of an environment template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The latest major version that's associated with the version of an environment template.
         * </p>
         * 
         * @param majorVersion
         *        The latest major version that's associated with the version of an environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(String majorVersion);

        /**
         * <p>
         * The version of an environment template.
         * </p>
         * 
         * @param minorVersion
         *        The version of an environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minorVersion(String minorVersion);

        /**
         * <p>
         * The recommended minor version of the environment template.
         * </p>
         * 
         * @param recommendedMinorVersion
         *        The recommended minor version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedMinorVersion(String recommendedMinorVersion);

        /**
         * <p>
         * The status of the version of an environment template.
         * </p>
         * 
         * @param status
         *        The status of the version of an environment template.
         * @see TemplateVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the version of an environment template.
         * </p>
         * 
         * @param status
         *        The status of the version of an environment template.
         * @see TemplateVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateVersionStatus
         */
        Builder status(TemplateVersionStatus status);

        /**
         * <p>
         * The status message of the version of an environment template.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the version of an environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the environment template.
         * </p>
         * 
         * @param templateName
         *        The name of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private Instant lastModifiedAt;

        private String majorVersion;

        private String minorVersion;

        private String recommendedMinorVersion;

        private String status;

        private String statusMessage;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentTemplateVersionSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            lastModifiedAt(model.lastModifiedAt);
            majorVersion(model.majorVersion);
            minorVersion(model.minorVersion);
            recommendedMinorVersion(model.recommendedMinorVersion);
            status(model.status);
            statusMessage(model.statusMessage);
            templateName(model.templateName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final String getMinorVersion() {
            return minorVersion;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final String getRecommendedMinorVersion() {
            return recommendedMinorVersion;
        }

        public final void setRecommendedMinorVersion(String recommendedMinorVersion) {
            this.recommendedMinorVersion = recommendedMinorVersion;
        }

        @Override
        public final Builder recommendedMinorVersion(String recommendedMinorVersion) {
            this.recommendedMinorVersion = recommendedMinorVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public EnvironmentTemplateVersionSummary build() {
            return new EnvironmentTemplateVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
