/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed data of the sync blocker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncBlocker implements SdkPojo, Serializable, ToCopyableBuilder<SyncBlocker.Builder, SyncBlocker> {
    private static final SdkField<List<SyncBlockerContext>> CONTEXTS_FIELD = SdkField
            .<List<SyncBlockerContext>> builder(MarshallingType.LIST)
            .memberName("contexts")
            .getter(getter(SyncBlocker::contexts))
            .setter(setter(Builder::contexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyncBlockerContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncBlockerContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SyncBlocker::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdReason").getter(getter(SyncBlocker::createdReason)).setter(setter(Builder::createdReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdReason").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SyncBlocker::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> RESOLVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("resolvedAt").getter(getter(SyncBlocker::resolvedAt)).setter(setter(Builder::resolvedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedAt").build()).build();

    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolvedReason").getter(getter(SyncBlocker::resolvedReason)).setter(setter(Builder::resolvedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedReason").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SyncBlocker::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SyncBlocker::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONTEXTS_FIELD, CREATED_AT_FIELD, CREATED_REASON_FIELD, ID_FIELD, RESOLVED_AT_FIELD,
                    RESOLVED_REASON_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SyncBlockerContext> contexts;

    private final Instant createdAt;

    private final String createdReason;

    private final String id;

    private final Instant resolvedAt;

    private final String resolvedReason;

    private final String status;

    private final String type;

    private SyncBlocker(BuilderImpl builder) {
        this.contexts = builder.contexts;
        this.createdAt = builder.createdAt;
        this.createdReason = builder.createdReason;
        this.id = builder.id;
        this.resolvedAt = builder.resolvedAt;
        this.resolvedReason = builder.resolvedReason;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContexts() {
        return contexts != null && !(contexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contexts for the sync blocker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContexts} method.
     * </p>
     * 
     * @return The contexts for the sync blocker.
     */
    public final List<SyncBlockerContext> contexts() {
        return contexts;
    }

    /**
     * <p>
     * The time when the sync blocker was created.
     * </p>
     * 
     * @return The time when the sync blocker was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The reason why the sync blocker was created.
     * </p>
     * 
     * @return The reason why the sync blocker was created.
     */
    public final String createdReason() {
        return createdReason;
    }

    /**
     * <p>
     * The ID of the sync blocker.
     * </p>
     * 
     * @return The ID of the sync blocker.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time the sync blocker was resolved.
     * </p>
     * 
     * @return The time the sync blocker was resolved.
     */
    public final Instant resolvedAt() {
        return resolvedAt;
    }

    /**
     * <p>
     * The reason the sync blocker was resolved.
     * </p>
     * 
     * @return The reason the sync blocker was resolved.
     */
    public final String resolvedReason() {
        return resolvedReason;
    }

    /**
     * <p>
     * The status of the sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlockerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sync blocker.
     * @see BlockerStatus
     */
    public final BlockerStatus status() {
        return BlockerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlockerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sync blocker.
     * @see BlockerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlockerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the sync blocker.
     * @see BlockerType
     */
    public final BlockerType type() {
        return BlockerType.fromValue(type);
    }

    /**
     * <p>
     * The type of the sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlockerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the sync blocker.
     * @see BlockerType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContexts() ? contexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdReason());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedReason());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlocker)) {
            return false;
        }
        SyncBlocker other = (SyncBlocker) obj;
        return hasContexts() == other.hasContexts() && Objects.equals(contexts(), other.contexts())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdReason(), other.createdReason())
                && Objects.equals(id(), other.id()) && Objects.equals(resolvedAt(), other.resolvedAt())
                && Objects.equals(resolvedReason(), other.resolvedReason())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncBlocker").add("Contexts", hasContexts() ? contexts() : null).add("CreatedAt", createdAt())
                .add("CreatedReason", createdReason()).add("Id", id()).add("ResolvedAt", resolvedAt())
                .add("ResolvedReason", resolvedReason()).add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contexts":
            return Optional.ofNullable(clazz.cast(contexts()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdReason":
            return Optional.ofNullable(clazz.cast(createdReason()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resolvedAt":
            return Optional.ofNullable(clazz.cast(resolvedAt()));
        case "resolvedReason":
            return Optional.ofNullable(clazz.cast(resolvedReason()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contexts", CONTEXTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdReason", CREATED_REASON_FIELD);
        map.put("id", ID_FIELD);
        map.put("resolvedAt", RESOLVED_AT_FIELD);
        map.put("resolvedReason", RESOLVED_REASON_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncBlocker, T> g) {
        return obj -> g.apply((SyncBlocker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncBlocker> {
        /**
         * <p>
         * The contexts for the sync blocker.
         * </p>
         * 
         * @param contexts
         *        The contexts for the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(Collection<SyncBlockerContext> contexts);

        /**
         * <p>
         * The contexts for the sync blocker.
         * </p>
         * 
         * @param contexts
         *        The contexts for the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(SyncBlockerContext... contexts);

        /**
         * <p>
         * The contexts for the sync blocker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.SyncBlockerContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.proton.model.SyncBlockerContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.SyncBlockerContext.Builder#build()} is called immediately
         * and its result is passed to {@link #contexts(List<SyncBlockerContext>)}.
         * 
         * @param contexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.SyncBlockerContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contexts(java.util.Collection<SyncBlockerContext>)
         */
        Builder contexts(Consumer<SyncBlockerContext.Builder>... contexts);

        /**
         * <p>
         * The time when the sync blocker was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the sync blocker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The reason why the sync blocker was created.
         * </p>
         * 
         * @param createdReason
         *        The reason why the sync blocker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdReason(String createdReason);

        /**
         * <p>
         * The ID of the sync blocker.
         * </p>
         * 
         * @param id
         *        The ID of the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time the sync blocker was resolved.
         * </p>
         * 
         * @param resolvedAt
         *        The time the sync blocker was resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedAt(Instant resolvedAt);

        /**
         * <p>
         * The reason the sync blocker was resolved.
         * </p>
         * 
         * @param resolvedReason
         *        The reason the sync blocker was resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedReason(String resolvedReason);

        /**
         * <p>
         * The status of the sync blocker.
         * </p>
         * 
         * @param status
         *        The status of the sync blocker.
         * @see BlockerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the sync blocker.
         * </p>
         * 
         * @param status
         *        The status of the sync blocker.
         * @see BlockerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerStatus
         */
        Builder status(BlockerStatus status);

        /**
         * <p>
         * The type of the sync blocker.
         * </p>
         * 
         * @param type
         *        The type of the sync blocker.
         * @see BlockerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the sync blocker.
         * </p>
         * 
         * @param type
         *        The type of the sync blocker.
         * @see BlockerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerType
         */
        Builder type(BlockerType type);
    }

    static final class BuilderImpl implements Builder {
        private List<SyncBlockerContext> contexts = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String createdReason;

        private String id;

        private Instant resolvedAt;

        private String resolvedReason;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncBlocker model) {
            contexts(model.contexts);
            createdAt(model.createdAt);
            createdReason(model.createdReason);
            id(model.id);
            resolvedAt(model.resolvedAt);
            resolvedReason(model.resolvedReason);
            status(model.status);
            type(model.type);
        }

        public final List<SyncBlockerContext.Builder> getContexts() {
            List<SyncBlockerContext.Builder> result = SyncBlockerContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<SyncBlockerContext.BuilderImpl> contexts) {
            this.contexts = SyncBlockerContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<SyncBlockerContext> contexts) {
            this.contexts = SyncBlockerContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(SyncBlockerContext... contexts) {
            contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<SyncBlockerContext.Builder>... contexts) {
            contexts(Stream.of(contexts).map(c -> SyncBlockerContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedReason() {
            return createdReason;
        }

        public final void setCreatedReason(String createdReason) {
            this.createdReason = createdReason;
        }

        @Override
        public final Builder createdReason(String createdReason) {
            this.createdReason = createdReason;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getResolvedAt() {
            return resolvedAt;
        }

        public final void setResolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
        }

        @Override
        public final Builder resolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
            return this;
        }

        public final String getResolvedReason() {
            return resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BlockerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlockerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public SyncBlocker build() {
            return new SyncBlocker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
