/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceTemplateVersionResponse extends ProtonResponse implements
        ToCopyableBuilder<DeleteServiceTemplateVersionResponse.Builder, DeleteServiceTemplateVersionResponse> {
    private static final SdkField<ServiceTemplateVersion> SERVICE_TEMPLATE_VERSION_FIELD = SdkField
            .<ServiceTemplateVersion> builder(MarshallingType.SDK_POJO).memberName("serviceTemplateVersion")
            .getter(getter(DeleteServiceTemplateVersionResponse::serviceTemplateVersion))
            .setter(setter(Builder::serviceTemplateVersion)).constructor(ServiceTemplateVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTemplateVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_TEMPLATE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceTemplateVersion serviceTemplateVersion;

    private DeleteServiceTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.serviceTemplateVersion = builder.serviceTemplateVersion;
    }

    /**
     * <p>
     * The detailed data of the service template version being deleted.
     * </p>
     * 
     * @return The detailed data of the service template version being deleted.
     */
    public final ServiceTemplateVersion serviceTemplateVersion() {
        return serviceTemplateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTemplateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceTemplateVersionResponse)) {
            return false;
        }
        DeleteServiceTemplateVersionResponse other = (DeleteServiceTemplateVersionResponse) obj;
        return Objects.equals(serviceTemplateVersion(), other.serviceTemplateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteServiceTemplateVersionResponse").add("ServiceTemplateVersion", serviceTemplateVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceTemplateVersion":
            return Optional.ofNullable(clazz.cast(serviceTemplateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceTemplateVersion", SERVICE_TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceTemplateVersionResponse, T> g) {
        return obj -> g.apply((DeleteServiceTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServiceTemplateVersionResponse> {
        /**
         * <p>
         * The detailed data of the service template version being deleted.
         * </p>
         * 
         * @param serviceTemplateVersion
         *        The detailed data of the service template version being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTemplateVersion(ServiceTemplateVersion serviceTemplateVersion);

        /**
         * <p>
         * The detailed data of the service template version being deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceTemplateVersion.Builder} avoiding
         * the need to create one manually via {@link ServiceTemplateVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceTemplateVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceTemplateVersion(ServiceTemplateVersion)}.
         * 
         * @param serviceTemplateVersion
         *        a consumer that will call methods on {@link ServiceTemplateVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceTemplateVersion(ServiceTemplateVersion)
         */
        default Builder serviceTemplateVersion(Consumer<ServiceTemplateVersion.Builder> serviceTemplateVersion) {
            return serviceTemplateVersion(ServiceTemplateVersion.builder().applyMutation(serviceTemplateVersion).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private ServiceTemplateVersion serviceTemplateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceTemplateVersionResponse model) {
            super(model);
            serviceTemplateVersion(model.serviceTemplateVersion);
        }

        public final ServiceTemplateVersion.Builder getServiceTemplateVersion() {
            return serviceTemplateVersion != null ? serviceTemplateVersion.toBuilder() : null;
        }

        public final void setServiceTemplateVersion(ServiceTemplateVersion.BuilderImpl serviceTemplateVersion) {
            this.serviceTemplateVersion = serviceTemplateVersion != null ? serviceTemplateVersion.build() : null;
        }

        @Override
        public final Builder serviceTemplateVersion(ServiceTemplateVersion serviceTemplateVersion) {
            this.serviceTemplateVersion = serviceTemplateVersion;
            return this;
        }

        @Override
        public DeleteServiceTemplateVersionResponse build() {
            return new DeleteServiceTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
