/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A repository sync definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySyncDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySyncDefinition.Builder, RepositorySyncDefinition> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("branch")
            .getter(getter(RepositorySyncDefinition::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final SdkField<String> DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directory").getter(getter(RepositorySyncDefinition::directory)).setter(setter(Builder::directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directory").build()).build();

    private static final SdkField<String> PARENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("parent")
            .getter(getter(RepositorySyncDefinition::parent)).setter(setter(Builder::parent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parent").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(RepositorySyncDefinition::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD,
            PARENT_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String directory;

    private final String parent;

    private final String target;

    private RepositorySyncDefinition(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.parent = builder.parent;
        this.target = builder.target;
    }

    /**
     * <p>
     * The repository branch.
     * </p>
     * 
     * @return The repository branch.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The directory in the repository.
     * </p>
     * 
     * @return The directory in the repository.
     */
    public final String directory() {
        return directory;
    }

    /**
     * <p>
     * The resource that is synced from.
     * </p>
     * 
     * @return The resource that is synced from.
     */
    public final String parent() {
        return parent;
    }

    /**
     * <p>
     * The resource that is synced to.
     * </p>
     * 
     * @return The resource that is synced to.
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(directory());
        hashCode = 31 * hashCode + Objects.hashCode(parent());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncDefinition)) {
            return false;
        }
        RepositorySyncDefinition other = (RepositorySyncDefinition) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(directory(), other.directory())
                && Objects.equals(parent(), other.parent()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySyncDefinition").add("Branch", branch()).add("Directory", directory())
                .add("Parent", parent()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "directory":
            return Optional.ofNullable(clazz.cast(directory()));
        case "parent":
            return Optional.ofNullable(clazz.cast(parent()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("branch", BRANCH_FIELD);
        map.put("directory", DIRECTORY_FIELD);
        map.put("parent", PARENT_FIELD);
        map.put("target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositorySyncDefinition, T> g) {
        return obj -> g.apply((RepositorySyncDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySyncDefinition> {
        /**
         * <p>
         * The repository branch.
         * </p>
         * 
         * @param branch
         *        The repository branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The directory in the repository.
         * </p>
         * 
         * @param directory
         *        The directory in the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directory(String directory);

        /**
         * <p>
         * The resource that is synced from.
         * </p>
         * 
         * @param parent
         *        The resource that is synced from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parent(String parent);

        /**
         * <p>
         * The resource that is synced to.
         * </p>
         * 
         * @param target
         *        The resource that is synced to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String directory;

        private String parent;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySyncDefinition model) {
            branch(model.branch);
            directory(model.directory);
            parent(model.parent);
            target(model.target);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getParent() {
            return parent;
        }

        public final void setParent(String parent) {
            this.parent = parent;
        }

        @Override
        public final Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public RepositorySyncDefinition build() {
            return new RepositorySyncDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
