/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed data about the current state of this service instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceInstanceState implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceInstanceState.Builder, ServiceInstanceState> {
    private static final SdkField<List<String>> LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("lastSuccessfulComponentDeploymentIds")
            .getter(getter(ServiceInstanceState::lastSuccessfulComponentDeploymentIds))
            .setter(setter(Builder::lastSuccessfulComponentDeploymentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lastSuccessfulComponentDeploymentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lastSuccessfulEnvironmentDeploymentId")
            .getter(getter(ServiceInstanceState::lastSuccessfulEnvironmentDeploymentId))
            .setter(setter(Builder::lastSuccessfulEnvironmentDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lastSuccessfulEnvironmentDeploymentId").build()).build();

    private static final SdkField<String> LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lastSuccessfulServicePipelineDeploymentId")
            .getter(getter(ServiceInstanceState::lastSuccessfulServicePipelineDeploymentId))
            .setter(setter(Builder::lastSuccessfulServicePipelineDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lastSuccessfulServicePipelineDeploymentId").build()).build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(ServiceInstanceState::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(ServiceInstanceState::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(ServiceInstanceState::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(ServiceInstanceState::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD, LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD,
            LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD,
            TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> lastSuccessfulComponentDeploymentIds;

    private final String lastSuccessfulEnvironmentDeploymentId;

    private final String lastSuccessfulServicePipelineDeploymentId;

    private final String spec;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private final String templateName;

    private ServiceInstanceState(BuilderImpl builder) {
        this.lastSuccessfulComponentDeploymentIds = builder.lastSuccessfulComponentDeploymentIds;
        this.lastSuccessfulEnvironmentDeploymentId = builder.lastSuccessfulEnvironmentDeploymentId;
        this.lastSuccessfulServicePipelineDeploymentId = builder.lastSuccessfulServicePipelineDeploymentId;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastSuccessfulComponentDeploymentIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasLastSuccessfulComponentDeploymentIds() {
        return lastSuccessfulComponentDeploymentIds != null
                && !(lastSuccessfulComponentDeploymentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs for the last successful components deployed for this service instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastSuccessfulComponentDeploymentIds}
     * method.
     * </p>
     * 
     * @return The IDs for the last successful components deployed for this service instance.
     */
    public final List<String> lastSuccessfulComponentDeploymentIds() {
        return lastSuccessfulComponentDeploymentIds;
    }

    /**
     * <p>
     * The ID for the last successful environment deployed for this service instance.
     * </p>
     * 
     * @return The ID for the last successful environment deployed for this service instance.
     */
    public final String lastSuccessfulEnvironmentDeploymentId() {
        return lastSuccessfulEnvironmentDeploymentId;
    }

    /**
     * <p>
     * The ID for the last successful service pipeline deployed for this service instance.
     * </p>
     * 
     * @return The ID for the last successful service pipeline deployed for this service instance.
     */
    public final String lastSuccessfulServicePipelineDeploymentId() {
        return lastSuccessfulServicePipelineDeploymentId;
    }

    /**
     * <p>
     * The service spec that was used to create the service instance.
     * </p>
     * 
     * @return The service spec that was used to create the service instance.
     */
    public final String spec() {
        return spec;
    }

    /**
     * <p>
     * The major version of the service template that was used to create the service pipeline.
     * </p>
     * 
     * @return The major version of the service template that was used to create the service pipeline.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the service template that was used to create the service pipeline.
     * </p>
     * 
     * @return The minor version of the service template that was used to create the service pipeline.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    /**
     * <p>
     * The name of the service template that was used to create the service instance.
     * </p>
     * 
     * @return The name of the service template that was used to create the service instance.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLastSuccessfulComponentDeploymentIds() ? lastSuccessfulComponentDeploymentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulEnvironmentDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulServicePipelineDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInstanceState)) {
            return false;
        }
        ServiceInstanceState other = (ServiceInstanceState) obj;
        return hasLastSuccessfulComponentDeploymentIds() == other.hasLastSuccessfulComponentDeploymentIds()
                && Objects.equals(lastSuccessfulComponentDeploymentIds(), other.lastSuccessfulComponentDeploymentIds())
                && Objects.equals(lastSuccessfulEnvironmentDeploymentId(), other.lastSuccessfulEnvironmentDeploymentId())
                && Objects.equals(lastSuccessfulServicePipelineDeploymentId(), other.lastSuccessfulServicePipelineDeploymentId())
                && Objects.equals(spec(), other.spec()) && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ServiceInstanceState")
                .add("LastSuccessfulComponentDeploymentIds",
                        hasLastSuccessfulComponentDeploymentIds() ? lastSuccessfulComponentDeploymentIds() : null)
                .add("LastSuccessfulEnvironmentDeploymentId", lastSuccessfulEnvironmentDeploymentId())
                .add("LastSuccessfulServicePipelineDeploymentId", lastSuccessfulServicePipelineDeploymentId())
                .add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion())
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastSuccessfulComponentDeploymentIds":
            return Optional.ofNullable(clazz.cast(lastSuccessfulComponentDeploymentIds()));
        case "lastSuccessfulEnvironmentDeploymentId":
            return Optional.ofNullable(clazz.cast(lastSuccessfulEnvironmentDeploymentId()));
        case "lastSuccessfulServicePipelineDeploymentId":
            return Optional.ofNullable(clazz.cast(lastSuccessfulServicePipelineDeploymentId()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastSuccessfulComponentDeploymentIds", LAST_SUCCESSFUL_COMPONENT_DEPLOYMENT_IDS_FIELD);
        map.put("lastSuccessfulEnvironmentDeploymentId", LAST_SUCCESSFUL_ENVIRONMENT_DEPLOYMENT_ID_FIELD);
        map.put("lastSuccessfulServicePipelineDeploymentId", LAST_SUCCESSFUL_SERVICE_PIPELINE_DEPLOYMENT_ID_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceInstanceState, T> g) {
        return obj -> g.apply((ServiceInstanceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceInstanceState> {
        /**
         * <p>
         * The IDs for the last successful components deployed for this service instance.
         * </p>
         * 
         * @param lastSuccessfulComponentDeploymentIds
         *        The IDs for the last successful components deployed for this service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulComponentDeploymentIds(Collection<String> lastSuccessfulComponentDeploymentIds);

        /**
         * <p>
         * The IDs for the last successful components deployed for this service instance.
         * </p>
         * 
         * @param lastSuccessfulComponentDeploymentIds
         *        The IDs for the last successful components deployed for this service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulComponentDeploymentIds(String... lastSuccessfulComponentDeploymentIds);

        /**
         * <p>
         * The ID for the last successful environment deployed for this service instance.
         * </p>
         * 
         * @param lastSuccessfulEnvironmentDeploymentId
         *        The ID for the last successful environment deployed for this service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulEnvironmentDeploymentId(String lastSuccessfulEnvironmentDeploymentId);

        /**
         * <p>
         * The ID for the last successful service pipeline deployed for this service instance.
         * </p>
         * 
         * @param lastSuccessfulServicePipelineDeploymentId
         *        The ID for the last successful service pipeline deployed for this service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulServicePipelineDeploymentId(String lastSuccessfulServicePipelineDeploymentId);

        /**
         * <p>
         * The service spec that was used to create the service instance.
         * </p>
         * 
         * @param spec
         *        The service spec that was used to create the service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * The major version of the service template that was used to create the service pipeline.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the service template that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the service template that was used to create the service pipeline.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the service template that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        /**
         * <p>
         * The name of the service template that was used to create the service instance.
         * </p>
         * 
         * @param templateName
         *        The name of the service template that was used to create the service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> lastSuccessfulComponentDeploymentIds = DefaultSdkAutoConstructList.getInstance();

        private String lastSuccessfulEnvironmentDeploymentId;

        private String lastSuccessfulServicePipelineDeploymentId;

        private String spec;

        private String templateMajorVersion;

        private String templateMinorVersion;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceInstanceState model) {
            lastSuccessfulComponentDeploymentIds(model.lastSuccessfulComponentDeploymentIds);
            lastSuccessfulEnvironmentDeploymentId(model.lastSuccessfulEnvironmentDeploymentId);
            lastSuccessfulServicePipelineDeploymentId(model.lastSuccessfulServicePipelineDeploymentId);
            spec(model.spec);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
            templateName(model.templateName);
        }

        public final Collection<String> getLastSuccessfulComponentDeploymentIds() {
            if (lastSuccessfulComponentDeploymentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return lastSuccessfulComponentDeploymentIds;
        }

        public final void setLastSuccessfulComponentDeploymentIds(Collection<String> lastSuccessfulComponentDeploymentIds) {
            this.lastSuccessfulComponentDeploymentIds = ComponentDeploymentIdListCopier
                    .copy(lastSuccessfulComponentDeploymentIds);
        }

        @Override
        public final Builder lastSuccessfulComponentDeploymentIds(Collection<String> lastSuccessfulComponentDeploymentIds) {
            this.lastSuccessfulComponentDeploymentIds = ComponentDeploymentIdListCopier
                    .copy(lastSuccessfulComponentDeploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastSuccessfulComponentDeploymentIds(String... lastSuccessfulComponentDeploymentIds) {
            lastSuccessfulComponentDeploymentIds(Arrays.asList(lastSuccessfulComponentDeploymentIds));
            return this;
        }

        public final String getLastSuccessfulEnvironmentDeploymentId() {
            return lastSuccessfulEnvironmentDeploymentId;
        }

        public final void setLastSuccessfulEnvironmentDeploymentId(String lastSuccessfulEnvironmentDeploymentId) {
            this.lastSuccessfulEnvironmentDeploymentId = lastSuccessfulEnvironmentDeploymentId;
        }

        @Override
        public final Builder lastSuccessfulEnvironmentDeploymentId(String lastSuccessfulEnvironmentDeploymentId) {
            this.lastSuccessfulEnvironmentDeploymentId = lastSuccessfulEnvironmentDeploymentId;
            return this;
        }

        public final String getLastSuccessfulServicePipelineDeploymentId() {
            return lastSuccessfulServicePipelineDeploymentId;
        }

        public final void setLastSuccessfulServicePipelineDeploymentId(String lastSuccessfulServicePipelineDeploymentId) {
            this.lastSuccessfulServicePipelineDeploymentId = lastSuccessfulServicePipelineDeploymentId;
        }

        @Override
        public final Builder lastSuccessfulServicePipelineDeploymentId(String lastSuccessfulServicePipelineDeploymentId) {
            this.lastSuccessfulServicePipelineDeploymentId = lastSuccessfulServicePipelineDeploymentId;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public ServiceInstanceState build() {
            return new ServiceInstanceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
