/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSyncBlockerResponse extends ProtonResponse implements
        ToCopyableBuilder<UpdateServiceSyncBlockerResponse.Builder, UpdateServiceSyncBlockerResponse> {
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(UpdateServiceSyncBlockerResponse::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(UpdateServiceSyncBlockerResponse::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<SyncBlocker> SERVICE_SYNC_BLOCKER_FIELD = SdkField
            .<SyncBlocker> builder(MarshallingType.SDK_POJO).memberName("serviceSyncBlocker")
            .getter(getter(UpdateServiceSyncBlockerResponse::serviceSyncBlocker)).setter(setter(Builder::serviceSyncBlocker))
            .constructor(SyncBlocker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSyncBlocker").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_INSTANCE_NAME_FIELD,
            SERVICE_NAME_FIELD, SERVICE_SYNC_BLOCKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceInstanceName;

    private final String serviceName;

    private final SyncBlocker serviceSyncBlocker;

    private UpdateServiceSyncBlockerResponse(BuilderImpl builder) {
        super(builder);
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSyncBlocker = builder.serviceSyncBlocker;
    }

    /**
     * <p>
     * The name of the service instance that you want to update the service sync blocker for.
     * </p>
     * 
     * @return The name of the service instance that you want to update the service sync blocker for.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that you want to update the service sync blocker for.
     * </p>
     * 
     * @return The name of the service that you want to update the service sync blocker for.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The detailed data on the service sync blocker that was updated.
     * </p>
     * 
     * @return The detailed data on the service sync blocker that was updated.
     */
    public final SyncBlocker serviceSyncBlocker() {
        return serviceSyncBlocker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSyncBlocker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSyncBlockerResponse)) {
            return false;
        }
        UpdateServiceSyncBlockerResponse other = (UpdateServiceSyncBlockerResponse) obj;
        return Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceSyncBlocker(), other.serviceSyncBlocker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSyncBlockerResponse").add("ServiceInstanceName", serviceInstanceName())
                .add("ServiceName", serviceName()).add("ServiceSyncBlocker", serviceSyncBlocker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "serviceSyncBlocker":
            return Optional.ofNullable(clazz.cast(serviceSyncBlocker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceSyncBlocker", SERVICE_SYNC_BLOCKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSyncBlockerResponse, T> g) {
        return obj -> g.apply((UpdateServiceSyncBlockerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceSyncBlockerResponse> {
        /**
         * <p>
         * The name of the service instance that you want to update the service sync blocker for.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that you want to update the service sync blocker for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that you want to update the service sync blocker for.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that you want to update the service sync blocker for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The detailed data on the service sync blocker that was updated.
         * </p>
         * 
         * @param serviceSyncBlocker
         *        The detailed data on the service sync blocker that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSyncBlocker(SyncBlocker serviceSyncBlocker);

        /**
         * <p>
         * The detailed data on the service sync blocker that was updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncBlocker.Builder} avoiding the need to
         * create one manually via {@link SyncBlocker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncBlocker.Builder#build()} is called immediately and its result
         * is passed to {@link #serviceSyncBlocker(SyncBlocker)}.
         * 
         * @param serviceSyncBlocker
         *        a consumer that will call methods on {@link SyncBlocker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSyncBlocker(SyncBlocker)
         */
        default Builder serviceSyncBlocker(Consumer<SyncBlocker.Builder> serviceSyncBlocker) {
            return serviceSyncBlocker(SyncBlocker.builder().applyMutation(serviceSyncBlocker).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String serviceInstanceName;

        private String serviceName;

        private SyncBlocker serviceSyncBlocker;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSyncBlockerResponse model) {
            super(model);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
            serviceSyncBlocker(model.serviceSyncBlocker);
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final SyncBlocker.Builder getServiceSyncBlocker() {
            return serviceSyncBlocker != null ? serviceSyncBlocker.toBuilder() : null;
        }

        public final void setServiceSyncBlocker(SyncBlocker.BuilderImpl serviceSyncBlocker) {
            this.serviceSyncBlocker = serviceSyncBlocker != null ? serviceSyncBlocker.build() : null;
        }

        @Override
        public final Builder serviceSyncBlocker(SyncBlocker serviceSyncBlocker) {
            this.serviceSyncBlocker = serviceSyncBlocker;
            return this;
        }

        @Override
        public UpdateServiceSyncBlockerResponse build() {
            return new UpdateServiceSyncBlockerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
