/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLibraryItemResponse extends QAppsResponse implements
        ToCopyableBuilder<CreateLibraryItemResponse.Builder, CreateLibraryItemResponse> {
    private static final SdkField<String> LIBRARY_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("libraryItemId").getter(getter(CreateLibraryItemResponse::libraryItemId))
            .setter(setter(Builder::libraryItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItemId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateLibraryItemResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateLibraryItemResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CreateLibraryItemResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(CreateLibraryItemResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(CreateLibraryItemResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Integer> RATING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ratingCount").getter(getter(CreateLibraryItemResponse::ratingCount))
            .setter(setter(Builder::ratingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIBRARY_ITEM_ID_FIELD,
            STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, RATING_COUNT_FIELD));

    private final String libraryItemId;

    private final String status;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final Integer ratingCount;

    private CreateLibraryItemResponse(BuilderImpl builder) {
        super(builder);
        this.libraryItemId = builder.libraryItemId;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.ratingCount = builder.ratingCount;
    }

    /**
     * <p>
     * The unique identifier of the new library item.
     * </p>
     * 
     * @return The unique identifier of the new library item.
     */
    public final String libraryItemId() {
        return libraryItemId;
    }

    /**
     * <p>
     * The status of the new library item, such as "Published".
     * </p>
     * 
     * @return The status of the new library item, such as "Published".
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the library item was created.
     * </p>
     * 
     * @return The date and time the library item was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the library item.
     * </p>
     * 
     * @return The user who created the library item.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the library item was last updated.
     * </p>
     * 
     * @return The date and time the library item was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who last updated the library item.
     * </p>
     * 
     * @return The user who last updated the library item.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The number of ratings the library item has received from users.
     * </p>
     * 
     * @return The number of ratings the library item has received from users.
     */
    public final Integer ratingCount() {
        return ratingCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(libraryItemId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(ratingCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLibraryItemResponse)) {
            return false;
        }
        CreateLibraryItemResponse other = (CreateLibraryItemResponse) obj;
        return Objects.equals(libraryItemId(), other.libraryItemId()) && Objects.equals(status(), other.status())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(ratingCount(), other.ratingCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLibraryItemResponse").add("LibraryItemId", libraryItemId()).add("Status", status())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).add("RatingCount", ratingCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "libraryItemId":
            return Optional.ofNullable(clazz.cast(libraryItemId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "ratingCount":
            return Optional.ofNullable(clazz.cast(ratingCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLibraryItemResponse, T> g) {
        return obj -> g.apply((CreateLibraryItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLibraryItemResponse> {
        /**
         * <p>
         * The unique identifier of the new library item.
         * </p>
         * 
         * @param libraryItemId
         *        The unique identifier of the new library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryItemId(String libraryItemId);

        /**
         * <p>
         * The status of the new library item, such as "Published".
         * </p>
         * 
         * @param status
         *        The status of the new library item, such as "Published".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the library item was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the library item was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the library item.
         * </p>
         * 
         * @param createdBy
         *        The user who created the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the library item was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the library item was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who last updated the library item.
         * </p>
         * 
         * @param updatedBy
         *        The user who last updated the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The number of ratings the library item has received from users.
         * </p>
         * 
         * @param ratingCount
         *        The number of ratings the library item has received from users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ratingCount(Integer ratingCount);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String libraryItemId;

        private String status;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private Integer ratingCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLibraryItemResponse model) {
            super(model);
            libraryItemId(model.libraryItemId);
            status(model.status);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            ratingCount(model.ratingCount);
        }

        public final String getLibraryItemId() {
            return libraryItemId;
        }

        public final void setLibraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
        }

        @Override
        public final Builder libraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Integer getRatingCount() {
            return ratingCount;
        }

        public final void setRatingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
        }

        @Override
        public final Builder ratingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
            return this;
        }

        @Override
        public CreateLibraryItemResponse build() {
            return new CreateLibraryItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
