/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A card in a Amazon Q App that generates a response based on the Amazon Q Business service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QQueryCard implements SdkPojo, Serializable, ToCopyableBuilder<QQueryCard.Builder, QQueryCard> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(QQueryCard::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(QQueryCard::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(QQueryCard::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(QQueryCard::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prompt")
            .getter(getter(QQueryCard::prompt)).setter(setter(Builder::prompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()).build();

    private static final SdkField<String> OUTPUT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputSource").getter(getter(QQueryCard::outputSourceAsString)).setter(setter(Builder::outputSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSource").build()).build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("attributeFilter")
            .getter(getter(QQueryCard::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            DEPENDENCIES_FIELD, TYPE_FIELD, PROMPT_FIELD, OUTPUT_SOURCE_FIELD, ATTRIBUTE_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final List<String> dependencies;

    private final String type;

    private final String prompt;

    private final String outputSource;

    private final AttributeFilter attributeFilter;

    private QQueryCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.outputSource = builder.outputSource;
        this.attributeFilter = builder.attributeFilter;
    }

    /**
     * <p>
     * The unique identifier of the query card.
     * </p>
     * 
     * @return The unique identifier of the query card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title or label of the query card.
     * </p>
     * 
     * @return The title or label of the query card.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return Any dependencies or requirements for the query card.
     */
    public final List<String> dependencies() {
        return dependencies;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the query card.
     * </p>
     * 
     * @return The prompt or instructions displayed for the query card.
     */
    public final String prompt() {
        return prompt;
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSource} will
     * return {@link CardOutputSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSourceAsString}.
     * </p>
     * 
     * @return The source or type of output generated by the query card.
     * @see CardOutputSource
     */
    public final CardOutputSource outputSource() {
        return CardOutputSource.fromValue(outputSource);
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSource} will
     * return {@link CardOutputSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSourceAsString}.
     * </p>
     * 
     * @return The source or type of output generated by the query card.
     * @see CardOutputSource
     */
    public final String outputSourceAsString() {
        return outputSource;
    }

    /**
     * <p>
     * The Amazon Q Business filters applied in this query card when resolving data sources
     * </p>
     * 
     * @return The Amazon Q Business filters applied in this query card when resolving data sources
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(outputSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QQueryCard)) {
            return false;
        }
        QQueryCard other = (QQueryCard) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(prompt(), other.prompt())
                && Objects.equals(outputSourceAsString(), other.outputSourceAsString())
                && Objects.equals(attributeFilter(), other.attributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QQueryCard").add("Id", id()).add("Title", title())
                .add("Dependencies", hasDependencies() ? dependencies() : null).add("Type", typeAsString())
                .add("Prompt", prompt()).add("OutputSource", outputSourceAsString()).add("AttributeFilter", attributeFilter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        case "outputSource":
            return Optional.ofNullable(clazz.cast(outputSourceAsString()));
        case "attributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QQueryCard, T> g) {
        return obj -> g.apply((QQueryCard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QQueryCard> {
        /**
         * <p>
         * The unique identifier of the query card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title or label of the query card.
         * </p>
         * 
         * @param title
         *        The title or label of the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Any dependencies or requirements for the query card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<String> dependencies);

        /**
         * <p>
         * Any dependencies or requirements for the query card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(String... dependencies);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The prompt or instructions displayed for the query card.
         * </p>
         * 
         * @param prompt
         *        The prompt or instructions displayed for the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(String prompt);

        /**
         * <p>
         * The source or type of output generated by the query card.
         * </p>
         * 
         * @param outputSource
         *        The source or type of output generated by the query card.
         * @see CardOutputSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardOutputSource
         */
        Builder outputSource(String outputSource);

        /**
         * <p>
         * The source or type of output generated by the query card.
         * </p>
         * 
         * @param outputSource
         *        The source or type of output generated by the query card.
         * @see CardOutputSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardOutputSource
         */
        Builder outputSource(CardOutputSource outputSource);

        /**
         * <p>
         * The Amazon Q Business filters applied in this query card when resolving data sources
         * </p>
         * 
         * @param attributeFilter
         *        The Amazon Q Business filters applied in this query card when resolving data sources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * <p>
         * The Amazon Q Business filters applied in this query card when resolving data sources
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String prompt;

        private String outputSource;

        private AttributeFilter attributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(QQueryCard model) {
            id(model.id);
            title(model.title);
            dependencies(model.dependencies);
            type(model.type);
            prompt(model.prompt);
            outputSource(model.outputSource);
            attributeFilter(model.attributeFilter);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getOutputSource() {
            return outputSource;
        }

        public final void setOutputSource(String outputSource) {
            this.outputSource = outputSource;
        }

        @Override
        public final Builder outputSource(String outputSource) {
            this.outputSource = outputSource;
            return this;
        }

        @Override
        public final Builder outputSource(CardOutputSource outputSource) {
            this.outputSource(outputSource == null ? null : outputSource.toString());
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        @Override
        public QQueryCard build() {
            return new QQueryCard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
