/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLibraryItemResponse extends QAppsResponse implements
        ToCopyableBuilder<UpdateLibraryItemResponse.Builder, UpdateLibraryItemResponse> {
    private static final SdkField<String> LIBRARY_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("libraryItemId").getter(getter(UpdateLibraryItemResponse::libraryItemId))
            .setter(setter(Builder::libraryItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItemId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(UpdateLibraryItemResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appVersion").getter(getter(UpdateLibraryItemResponse::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("categories")
            .getter(getter(UpdateLibraryItemResponse::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateLibraryItemResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateLibraryItemResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(UpdateLibraryItemResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateLibraryItemResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(UpdateLibraryItemResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Integer> RATING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ratingCount").getter(getter(UpdateLibraryItemResponse::ratingCount))
            .setter(setter(Builder::ratingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingCount").build()).build();

    private static final SdkField<Boolean> IS_RATED_BY_USER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRatedByUser").getter(getter(UpdateLibraryItemResponse::isRatedByUser))
            .setter(setter(Builder::isRatedByUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRatedByUser").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("userCount").getter(getter(UpdateLibraryItemResponse::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIBRARY_ITEM_ID_FIELD,
            APP_ID_FIELD, APP_VERSION_FIELD, CATEGORIES_FIELD, STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD, RATING_COUNT_FIELD, IS_RATED_BY_USER_FIELD, USER_COUNT_FIELD));

    private final String libraryItemId;

    private final String appId;

    private final Integer appVersion;

    private final List<Category> categories;

    private final String status;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final Integer ratingCount;

    private final Boolean isRatedByUser;

    private final Integer userCount;

    private UpdateLibraryItemResponse(BuilderImpl builder) {
        super(builder);
        this.libraryItemId = builder.libraryItemId;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.categories = builder.categories;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.ratingCount = builder.ratingCount;
        this.isRatedByUser = builder.isRatedByUser;
        this.userCount = builder.userCount;
    }

    /**
     * <p>
     * The unique identifier of the updated library item.
     * </p>
     * 
     * @return The unique identifier of the updated library item.
     */
    public final String libraryItemId() {
        return libraryItemId;
    }

    /**
     * <p>
     * The unique identifier of the Q App associated with the library item.
     * </p>
     * 
     * @return The unique identifier of the Q App associated with the library item.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The version of the Q App associated with the library item.
     * </p>
     * 
     * @return The version of the Q App associated with the library item.
     */
    public final Integer appVersion() {
        return appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories associated with the updated library item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The categories associated with the updated library item.
     */
    public final List<Category> categories() {
        return categories;
    }

    /**
     * <p>
     * The new status of the updated library item.
     * </p>
     * 
     * @return The new status of the updated library item.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the library item was originally created.
     * </p>
     * 
     * @return The date and time the library item was originally created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who originally created the library item.
     * </p>
     * 
     * @return The user who originally created the library item.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the library item was last updated.
     * </p>
     * 
     * @return The date and time the library item was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who last updated the library item.
     * </p>
     * 
     * @return The user who last updated the library item.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The number of ratings the library item has received.
     * </p>
     * 
     * @return The number of ratings the library item has received.
     */
    public final Integer ratingCount() {
        return ratingCount;
    }

    /**
     * <p>
     * Whether the current user has rated the library item.
     * </p>
     * 
     * @return Whether the current user has rated the library item.
     */
    public final Boolean isRatedByUser() {
        return isRatedByUser;
    }

    /**
     * <p>
     * The number of users who have the associated Q App.
     * </p>
     * 
     * @return The number of users who have the associated Q App.
     */
    public final Integer userCount() {
        return userCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(libraryItemId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(ratingCount());
        hashCode = 31 * hashCode + Objects.hashCode(isRatedByUser());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLibraryItemResponse)) {
            return false;
        }
        UpdateLibraryItemResponse other = (UpdateLibraryItemResponse) obj;
        return Objects.equals(libraryItemId(), other.libraryItemId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(appVersion(), other.appVersion()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories()) && Objects.equals(status(), other.status())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(ratingCount(), other.ratingCount()) && Objects.equals(isRatedByUser(), other.isRatedByUser())
                && Objects.equals(userCount(), other.userCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLibraryItemResponse").add("LibraryItemId", libraryItemId()).add("AppId", appId())
                .add("AppVersion", appVersion()).add("Categories", hasCategories() ? categories() : null).add("Status", status())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).add("RatingCount", ratingCount()).add("IsRatedByUser", isRatedByUser())
                .add("UserCount", userCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "libraryItemId":
            return Optional.ofNullable(clazz.cast(libraryItemId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "ratingCount":
            return Optional.ofNullable(clazz.cast(ratingCount()));
        case "isRatedByUser":
            return Optional.ofNullable(clazz.cast(isRatedByUser()));
        case "userCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLibraryItemResponse, T> g) {
        return obj -> g.apply((UpdateLibraryItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLibraryItemResponse> {
        /**
         * <p>
         * The unique identifier of the updated library item.
         * </p>
         * 
         * @param libraryItemId
         *        The unique identifier of the updated library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryItemId(String libraryItemId);

        /**
         * <p>
         * The unique identifier of the Q App associated with the library item.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Q App associated with the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The version of the Q App associated with the library item.
         * </p>
         * 
         * @param appVersion
         *        The version of the Q App associated with the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(Integer appVersion);

        /**
         * <p>
         * The categories associated with the updated library item.
         * </p>
         * 
         * @param categories
         *        The categories associated with the updated library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * The categories associated with the updated library item.
         * </p>
         * 
         * @param categories
         *        The categories associated with the updated library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * The categories associated with the updated library item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.Category.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qapps.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.Category.Builder#build()} is called immediately and its
         * result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);

        /**
         * <p>
         * The new status of the updated library item.
         * </p>
         * 
         * @param status
         *        The new status of the updated library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the library item was originally created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the library item was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who originally created the library item.
         * </p>
         * 
         * @param createdBy
         *        The user who originally created the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the library item was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the library item was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who last updated the library item.
         * </p>
         * 
         * @param updatedBy
         *        The user who last updated the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The number of ratings the library item has received.
         * </p>
         * 
         * @param ratingCount
         *        The number of ratings the library item has received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ratingCount(Integer ratingCount);

        /**
         * <p>
         * Whether the current user has rated the library item.
         * </p>
         * 
         * @param isRatedByUser
         *        Whether the current user has rated the library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRatedByUser(Boolean isRatedByUser);

        /**
         * <p>
         * The number of users who have the associated Q App.
         * </p>
         * 
         * @param userCount
         *        The number of users who have the associated Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String libraryItemId;

        private String appId;

        private Integer appVersion;

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private Integer ratingCount;

        private Boolean isRatedByUser;

        private Integer userCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLibraryItemResponse model) {
            super(model);
            libraryItemId(model.libraryItemId);
            appId(model.appId);
            appVersion(model.appVersion);
            categories(model.categories);
            status(model.status);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            ratingCount(model.ratingCount);
            isRatedByUser(model.isRatedByUser);
            userCount(model.userCount);
        }

        public final String getLibraryItemId() {
            return libraryItemId;
        }

        public final void setLibraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
        }

        @Override
        public final Builder libraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Integer getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Integer getRatingCount() {
            return ratingCount;
        }

        public final void setRatingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
        }

        @Override
        public final Builder ratingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
            return this;
        }

        public final Boolean getIsRatedByUser() {
            return isRatedByUser;
        }

        public final void setIsRatedByUser(Boolean isRatedByUser) {
            this.isRatedByUser = isRatedByUser;
        }

        @Override
        public final Builder isRatedByUser(Boolean isRatedByUser) {
            this.isRatedByUser = isRatedByUser;
            return this;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        @Override
        public UpdateLibraryItemResponse build() {
            return new UpdateLibraryItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
