/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the Q App, specifying the cards and flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppDefinition implements SdkPojo, Serializable, ToCopyableBuilder<AppDefinition.Builder, AppDefinition> {
    private static final SdkField<String> APP_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appDefinitionVersion").getter(getter(AppDefinition::appDefinitionVersion))
            .setter(setter(Builder::appDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appDefinitionVersion").build())
            .build();

    private static final SdkField<List<Card>> CARDS_FIELD = SdkField
            .<List<Card>> builder(MarshallingType.LIST)
            .memberName("cards")
            .getter(getter(AppDefinition::cards))
            .setter(setter(Builder::cards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Card> builder(MarshallingType.SDK_POJO)
                                            .constructor(Card::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CAN_EDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canEdit").getter(getter(AppDefinition::canEdit)).setter(setter(Builder::canEdit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canEdit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_DEFINITION_VERSION_FIELD,
            CARDS_FIELD, CAN_EDIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appDefinitionVersion;

    private final List<Card> cards;

    private final Boolean canEdit;

    private AppDefinition(BuilderImpl builder) {
        this.appDefinitionVersion = builder.appDefinitionVersion;
        this.cards = builder.cards;
        this.canEdit = builder.canEdit;
    }

    /**
     * <p>
     * The version of the app definition schema or specification.
     * </p>
     * 
     * @return The version of the app definition schema or specification.
     */
    public final String appDefinitionVersion() {
        return appDefinitionVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cards property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCards() {
        return cards != null && !(cards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cards that make up the Q App, such as text input, file upload, or query cards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCards} method.
     * </p>
     * 
     * @return The cards that make up the Q App, such as text input, file upload, or query cards.
     */
    public final List<Card> cards() {
        return cards;
    }

    /**
     * <p>
     * A flag indicating whether the Q App's definition can be edited by the user.
     * </p>
     * 
     * @return A flag indicating whether the Q App's definition can be edited by the user.
     */
    public final Boolean canEdit() {
        return canEdit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasCards() ? cards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canEdit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinition)) {
            return false;
        }
        AppDefinition other = (AppDefinition) obj;
        return Objects.equals(appDefinitionVersion(), other.appDefinitionVersion()) && hasCards() == other.hasCards()
                && Objects.equals(cards(), other.cards()) && Objects.equals(canEdit(), other.canEdit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppDefinition").add("AppDefinitionVersion", appDefinitionVersion())
                .add("Cards", hasCards() ? cards() : null).add("CanEdit", canEdit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appDefinitionVersion":
            return Optional.ofNullable(clazz.cast(appDefinitionVersion()));
        case "cards":
            return Optional.ofNullable(clazz.cast(cards()));
        case "canEdit":
            return Optional.ofNullable(clazz.cast(canEdit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppDefinition, T> g) {
        return obj -> g.apply((AppDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppDefinition> {
        /**
         * <p>
         * The version of the app definition schema or specification.
         * </p>
         * 
         * @param appDefinitionVersion
         *        The version of the app definition schema or specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appDefinitionVersion(String appDefinitionVersion);

        /**
         * <p>
         * The cards that make up the Q App, such as text input, file upload, or query cards.
         * </p>
         * 
         * @param cards
         *        The cards that make up the Q App, such as text input, file upload, or query cards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cards(Collection<Card> cards);

        /**
         * <p>
         * The cards that make up the Q App, such as text input, file upload, or query cards.
         * </p>
         * 
         * @param cards
         *        The cards that make up the Q App, such as text input, file upload, or query cards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cards(Card... cards);

        /**
         * <p>
         * The cards that make up the Q App, such as text input, file upload, or query cards.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.Card.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.qapps.model.Card#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.qapps.model.Card.Builder#build()}
         * is called immediately and its result is passed to {@link #cards(List<Card>)}.
         * 
         * @param cards
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.qapps.model.Card.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cards(java.util.Collection<Card>)
         */
        Builder cards(Consumer<Card.Builder>... cards);

        /**
         * <p>
         * A flag indicating whether the Q App's definition can be edited by the user.
         * </p>
         * 
         * @param canEdit
         *        A flag indicating whether the Q App's definition can be edited by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canEdit(Boolean canEdit);
    }

    static final class BuilderImpl implements Builder {
        private String appDefinitionVersion;

        private List<Card> cards = DefaultSdkAutoConstructList.getInstance();

        private Boolean canEdit;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDefinition model) {
            appDefinitionVersion(model.appDefinitionVersion);
            cards(model.cards);
            canEdit(model.canEdit);
        }

        public final String getAppDefinitionVersion() {
            return appDefinitionVersion;
        }

        public final void setAppDefinitionVersion(String appDefinitionVersion) {
            this.appDefinitionVersion = appDefinitionVersion;
        }

        @Override
        public final Builder appDefinitionVersion(String appDefinitionVersion) {
            this.appDefinitionVersion = appDefinitionVersion;
            return this;
        }

        public final List<Card.Builder> getCards() {
            List<Card.Builder> result = CardModelListCopier.copyToBuilder(this.cards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCards(Collection<Card.BuilderImpl> cards) {
            this.cards = CardModelListCopier.copyFromBuilder(cards);
        }

        @Override
        public final Builder cards(Collection<Card> cards) {
            this.cards = CardModelListCopier.copy(cards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Card... cards) {
            cards(Arrays.asList(cards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Consumer<Card.Builder>... cards) {
            cards(Stream.of(cards).map(c -> Card.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCanEdit() {
            return canEdit;
        }

        public final void setCanEdit(Boolean canEdit) {
            this.canEdit = canEdit;
        }

        @Override
        public final Builder canEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        @Override
        public AppDefinition build() {
            return new AppDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
